/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.OperatingSystem;
import org.arakhne.afc.vmutil.locale.Locale;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public class VMCommandLine {
    private static String classnameToLaunch;
    private static boolean analyzed;
    private static SortedMap<String, List<Object>> commandLineOptions;
    private static String[] commandLineParameters;

    public VMCommandLine(Class<?> classToLaunch, String ... parameters) {
        VMCommandLine.saveVMParametersIfNotSet(classToLaunch, parameters);
    }

    public VMCommandLine(String classToLaunch, String ... parameters) {
        VMCommandLine.saveVMParametersIfNotSet(classToLaunch, parameters);
    }

    public VMCommandLine(Class<?> classToLaunch, String[] optionDefinitions, String ... parameters) {
        VMCommandLine.saveVMParametersIfNotSet(classToLaunch, parameters);
        VMCommandLine.splitOptionsAndParameters(optionDefinitions);
    }

    public VMCommandLine(String classToLaunch, String[] optionDefinitions, String ... parameters) {
        VMCommandLine.saveVMParametersIfNotSet(classToLaunch, parameters);
        VMCommandLine.splitOptionsAndParameters(optionDefinitions);
    }

    public VMCommandLine() {
        if (classnameToLaunch == null) {
            throw new IllegalArgumentException(Locale.getString("E1", new Object[0]));
        }
    }

    @Pure
    public static String getExecutableFilename(String name) {
        if (OperatingSystem.WIN.isCurrentOS()) {
            return String.valueOf(name) + ".exe";
        }
        return name;
    }

    @Pure
    public static String getVMBinary() {
        String javaHome = System.getProperty("java.home");
        File binDir = new File(new File(javaHome), "bin");
        if (binDir.isDirectory()) {
            File exec = new File(binDir, VMCommandLine.getExecutableFilename("javaw"));
            if (exec.isFile()) {
                return exec.getAbsolutePath();
            }
            exec = new File(binDir, VMCommandLine.getExecutableFilename("java"));
            if (exec.isFile()) {
                return exec.getAbsolutePath();
            }
        }
        return null;
    }

    @Inline(value="VMCommandLine.launchVMWithClassPath(($1).getCanonicalName(), ($2), ($3))", imported={VMCommandLine.class}, statementExpression=true)
    public static Process launchVMWithClassPath(Class<?> classToLaunch, String classpath, String ... additionalParams) throws IOException {
        return VMCommandLine.launchVMWithClassPath(classToLaunch.getCanonicalName(), classpath, additionalParams);
    }

    public static Process launchVMWithClassPath(String classToLaunch, String classpath, String ... additionalParams) throws IOException {
        String[] params;
        int nParams;
        String javaBin = VMCommandLine.getVMBinary();
        if (javaBin == null) {
            throw new FileNotFoundException("java");
        }
        long totalMemory = Runtime.getRuntime().maxMemory() / 1024L;
        String userDir = FileSystem.getUserHomeDirectoryName();
        if (classpath != null && !"".equals(classpath)) {
            nParams = 5;
            params = new String[additionalParams.length + nParams];
            params[0] = javaBin;
            params[1] = "-Xmx" + totalMemory + "k";
            params[2] = "-classpath";
            params[3] = classpath;
            params[4] = classToLaunch;
        } else {
            nParams = 3;
            params = new String[additionalParams.length + nParams];
            params[0] = javaBin;
            params[1] = "-Xmx" + totalMemory + "k";
            params[2] = classToLaunch;
        }
        System.arraycopy(additionalParams, 0, params, nParams, additionalParams.length);
        return Runtime.getRuntime().exec(params, null, new File(userDir));
    }

    @Inline(value="VMCommandLine.launchVMWithClassPath(($1).getCanonicalName(), ($2), ($3))", imported={VMCommandLine.class}, statementExpression=true)
    public static Process launchVMWithClassPath(Class<?> classToLaunch, File[] classpath, String ... additionalParams) throws IOException {
        return VMCommandLine.launchVMWithClassPath(classToLaunch.getCanonicalName(), classpath, additionalParams);
    }

    public static Process launchVMWithClassPath(String classToLaunch, File[] classpath, String ... additionalParams) throws IOException {
        StringBuilder b = new StringBuilder();
        File[] fileArray = classpath;
        int n = classpath.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (b.length() > 0) {
                b.append(File.pathSeparator);
            }
            b.append(f.getAbsolutePath());
            ++n2;
        }
        return VMCommandLine.launchVMWithClassPath(classToLaunch, b.toString(), additionalParams);
    }

    public static Process launchVMWithJar(File jarFile, String ... additionalParams) throws IOException {
        String javaBin = VMCommandLine.getVMBinary();
        if (javaBin == null) {
            throw new FileNotFoundException("java");
        }
        long totalMemory = Runtime.getRuntime().maxMemory() / 1024L;
        String userDir = FileSystem.getUserHomeDirectoryName();
        String[] params = new String[additionalParams.length + 4];
        params[0] = javaBin;
        params[1] = "-Xmx" + totalMemory + "k";
        params[2] = "-jar";
        params[3] = jarFile.getAbsolutePath();
        System.arraycopy(additionalParams, 0, params, 4, additionalParams.length);
        return Runtime.getRuntime().exec(params, null, new File(userDir));
    }

    @Inline(value="VMCommandLine.launchVM(($1).getCanonicalName(), ($2))", imported={VMCommandLine.class}, statementExpression=true)
    public static Process launchVM(Class<?> classToLaunch, String ... additionalParams) throws IOException {
        return VMCommandLine.launchVM(classToLaunch.getCanonicalName(), additionalParams);
    }

    @Inline(value="VMCommandLine.launchVMWithClassPath(($1), System.getProperty(\"java.class.path\"), ($2))", imported={VMCommandLine.class}, statementExpression=true)
    public static Process launchVM(String classToLaunch, String ... additionalParams) throws IOException {
        return VMCommandLine.launchVMWithClassPath(classToLaunch, System.getProperty("java.class.path"), additionalParams);
    }

    @Inline(value="VMCommandLine.saveVMParameters((($1) != null) ? ($1).getCanonicalName() : null, ($2))", imported={VMCommandLine.class}, statementExpression=true)
    public static void saveVMParameters(Class<?> classToLaunch, String ... parameters) {
        VMCommandLine.saveVMParameters(classToLaunch != null ? classToLaunch.getCanonicalName() : null, parameters);
    }

    public static void saveVMParameters(String classToLaunch, String ... parameters) {
        classnameToLaunch = classToLaunch;
        commandLineParameters = parameters;
        if (commandLineOptions != null) {
            commandLineOptions.clear();
        }
        commandLineOptions = null;
        analyzed = false;
    }

    @Inline(value="VMCommandLine.saveVMParametersIfNotSet(($1).getCanonicalName(), ($2))", imported={VMCommandLine.class}, statementExpression=true)
    public static void saveVMParametersIfNotSet(Class<?> classToLaunch, String ... parameters) {
        VMCommandLine.saveVMParametersIfNotSet(classToLaunch.getCanonicalName(), parameters);
    }

    public static void saveVMParametersIfNotSet(String classToLaunch, String ... parameters) {
        if (classnameToLaunch == null || "".equals(classnameToLaunch)) {
            VMCommandLine.saveVMParameters(classToLaunch, parameters);
        }
    }

    public static Process relaunchVM() throws IOException {
        if (classnameToLaunch == null) {
            return null;
        }
        return VMCommandLine.launchVM(classnameToLaunch, VMCommandLine.getAllCommandLineParameters());
    }

    @Pure
    public static String[] getAllCommandLineParameters() {
        int osize = commandLineOptions == null ? 0 : commandLineOptions.size();
        int psize = commandLineParameters == null ? 0 : commandLineParameters.length;
        int tsize = osize > 0 && psize > 0 ? 1 : 0;
        ArrayList<String> params = new ArrayList<String>(osize + tsize);
        if (osize > 0) {
            for (Map.Entry<String, List<Object>> entry : commandLineOptions.entrySet()) {
                String name = entry.getKey();
                String prefix = name.length() > 1 ? "--" : "-";
                List<Object> values = entry.getValue();
                if (values == null || values.isEmpty()) {
                    params.add(String.valueOf(prefix) + name);
                    continue;
                }
                for (Object value : values) {
                    if (value == null) continue;
                    String v = value.toString();
                    if (v != null && v.length() > 0) {
                        params.add(String.valueOf(prefix) + name + "=" + v);
                        continue;
                    }
                    params.add(String.valueOf(prefix) + name);
                }
            }
        }
        if (tsize > 0) {
            params.add("--");
        }
        String[] tab = new String[params.size() + psize];
        params.toArray(tab);
        params.clear();
        if (psize > 0) {
            System.arraycopy(commandLineParameters, 0, tab, osize + tsize, psize);
        }
        return tab;
    }

    @Pure
    public static String[] getCommandLineParameters() {
        return commandLineParameters == null ? new String[]{} : commandLineParameters;
    }

    public static String shiftCommandLineParameters() {
        String removed = null;
        if (commandLineParameters != null) {
            if (commandLineParameters.length == 0) {
                commandLineParameters = null;
            } else if (commandLineParameters.length == 1) {
                removed = commandLineParameters[0];
                commandLineParameters = null;
            } else {
                removed = commandLineParameters[0];
                String[] newTab = new String[commandLineParameters.length - 1];
                System.arraycopy(commandLineParameters, 1, newTab, 0, commandLineParameters.length - 1);
                commandLineParameters = newTab;
            }
        }
        return removed;
    }

    @Pure
    public static Map<String, List<Object>> getCommandLineOptions() {
        if (commandLineOptions != null) {
            return Collections.unmodifiableSortedMap(commandLineOptions);
        }
        return Collections.emptyMap();
    }

    @Pure
    public static List<Object> getCommandLineOption(String name) {
        if (commandLineOptions != null && commandLineOptions.containsKey(name)) {
            List value = (List)commandLineOptions.get(name);
            return value == null ? Collections.emptyList() : value;
        }
        return Collections.emptyList();
    }

    @Pure
    public static boolean hasCommandLineOption(String name) {
        return commandLineOptions != null && commandLineOptions.containsKey(name);
    }

    private static boolean registerOptionValue(SortedMap<String, List<Object>> options, String name, Object value, OptionType type) {
        boolean success = true;
        Object optValue = value;
        ArrayList<Object> values = (ArrayList<Object>)options.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            options.put(name, values);
        }
        switch (type) {
            case AUTO_INCREMENTED: {
                long v = values.isEmpty() ? -1L : ((optValue = values.get(0)) == null ? 0L : (!(optValue instanceof Number) ? Long.parseLong(optValue.toString()) : ((Number)optValue).longValue()));
                if (values.isEmpty()) {
                    values.add(v + 1L);
                    break;
                }
                values.set(0, v + 1L);
                break;
            }
            case FLAG: {
                if (optValue == null) {
                    optValue = values.isEmpty() ? Boolean.TRUE : values.get(0);
                } else if (!(optValue instanceof Boolean)) {
                    optValue = Boolean.parseBoolean(optValue.toString());
                }
                if (values.isEmpty()) {
                    values.add(optValue);
                    break;
                }
                values.set(0, optValue);
                break;
            }
            case MANDATORY_BOOLEAN: 
            case OPTIONAL_BOOLEAN: {
                if (optValue == null) {
                    optValue = Boolean.TRUE;
                } else if (!(optValue instanceof Boolean)) {
                    optValue = Boolean.parseBoolean(optValue.toString());
                }
                values.add(optValue);
                break;
            }
            case MANDATORY_FLOAT: 
            case OPTIONAL_FLOAT: {
                try {
                    optValue = optValue == null ? Double.valueOf(0.0) : (!(optValue instanceof Number) ? Double.valueOf(Double.parseDouble(optValue.toString())) : Double.valueOf(((Number)optValue).doubleValue()));
                }
                catch (NumberFormatException e) {
                    if (type.isOptional()) {
                        success = false;
                        optValue = 0.0;
                    }
                    throw e;
                }
                values.add(optValue);
                break;
            }
            case MANDATORY_INTEGER: 
            case OPTIONAL_INTEGER: {
                try {
                    optValue = optValue == null ? Long.valueOf(0L) : (!(optValue instanceof Number) ? Long.valueOf(Long.parseLong(optValue.toString())) : Long.valueOf(((Number)optValue).longValue()));
                }
                catch (NumberFormatException e) {
                    if (type.isOptional()) {
                        success = false;
                        optValue = 0L;
                    }
                    throw e;
                }
                values.add(optValue);
                break;
            }
            case MANDATORY_STRING: 
            case OPTIONAL_STRING: {
                values.add(optValue == null ? "" : optValue.toString());
                break;
            }
            case SIMPLE: {
                values.add(optValue);
            }
        }
        return success;
    }

    public static void splitOptionsAndParameters(String ... optionDefinitions) {
        String opt;
        if (analyzed) {
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        TreeMap<String, List<Object>> options = new TreeMap<String, List<Object>>();
        TreeMap<String, OptionType> defs = new TreeMap<String, OptionType>();
        String[] stringArray = optionDefinitions;
        int n = optionDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            String def = stringArray[n2];
            if (def.endsWith("!")) {
                opt = def.substring(0, def.length() - 1);
                defs.put(opt, OptionType.FLAG);
                VMCommandLine.registerOptionValue(options, opt, Boolean.FALSE, OptionType.FLAG);
            } else if (def.endsWith("+")) {
                opt = def.substring(0, def.length() - 1);
                defs.put(opt, OptionType.AUTO_INCREMENTED);
                VMCommandLine.registerOptionValue(options, opt, 0L, OptionType.AUTO_INCREMENTED);
            } else if (def.endsWith("=b")) {
                opt = def.substring(0, def.length() - 2);
                defs.put(opt, OptionType.MANDATORY_BOOLEAN);
            } else if (def.endsWith(":b")) {
                opt = def.substring(0, def.length() - 2);
                defs.put(opt, OptionType.OPTIONAL_BOOLEAN);
            } else if (def.endsWith("=f")) {
                opt = def.substring(0, def.length() - 2);
                defs.put(opt, OptionType.MANDATORY_FLOAT);
            } else if (def.endsWith(":f")) {
                opt = def.substring(0, def.length() - 2);
                defs.put(opt, OptionType.OPTIONAL_FLOAT);
            } else if (def.endsWith("=i")) {
                opt = def.substring(0, def.length() - 2);
                defs.put(opt, OptionType.MANDATORY_INTEGER);
            } else if (def.endsWith(":i")) {
                opt = def.substring(0, def.length() - 2);
                defs.put(opt, OptionType.OPTIONAL_INTEGER);
            } else if (def.endsWith("=s")) {
                opt = def.substring(0, def.length() - 2);
                defs.put(opt, OptionType.MANDATORY_STRING);
            } else if (def.endsWith(":s")) {
                opt = def.substring(0, def.length() - 2);
                defs.put(opt, OptionType.OPTIONAL_STRING);
            } else {
                defs.put(def, OptionType.SIMPLE);
            }
            ++n2;
        }
        OptionType waitingValue = null;
        String valueOptionName = null;
        boolean allParameters = false;
        String[] stringArray2 = commandLineParameters;
        int n3 = commandLineParameters.length;
        int n4 = 0;
        while (n4 < n3) {
            block44: {
                String val;
                String base;
                int idx;
                block51: {
                    boolean success;
                    String param;
                    block48: {
                        block50: {
                            block49: {
                                block47: {
                                    block46: {
                                        block45: {
                                            block43: {
                                                param = stringArray2[n4];
                                                if (!allParameters) break block43;
                                                params.add(param);
                                                break block44;
                                            }
                                            if (waitingValue == null || !waitingValue.isMandatory()) break block45;
                                            success = VMCommandLine.registerOptionValue(options, valueOptionName, param, waitingValue);
                                            waitingValue = null;
                                            valueOptionName = null;
                                            if (success) break block44;
                                        }
                                        if (!"--".equals(param)) break block46;
                                        if (waitingValue != null) {
                                            VMCommandLine.registerOptionValue(options, valueOptionName, null, waitingValue);
                                            waitingValue = null;
                                            valueOptionName = null;
                                        }
                                        allParameters = true;
                                        break block44;
                                    }
                                    if (File.separatorChar == '/' || !param.startsWith("/")) break block47;
                                    opt = param.substring(1);
                                    break block48;
                                }
                                if (!param.startsWith("--")) break block49;
                                opt = param.substring(2);
                                break block48;
                            }
                            if (param.startsWith("-")) break block50;
                            if (waitingValue != null) {
                                success = VMCommandLine.registerOptionValue(options, valueOptionName, param, waitingValue);
                                waitingValue = null;
                                valueOptionName = null;
                                if (!success) {
                                    params.add(param);
                                }
                            } else {
                                params.add(param);
                            }
                            break block44;
                        }
                        opt = param.substring(1);
                    }
                    if (waitingValue == null) break block51;
                    success = VMCommandLine.registerOptionValue(options, valueOptionName, param, waitingValue);
                    waitingValue = null;
                    valueOptionName = null;
                    if (success) break block44;
                }
                if ((idx = opt.indexOf(61)) > 0) {
                    base = opt.substring(0, idx);
                    val = opt.substring(idx + 1);
                } else {
                    base = opt;
                    val = null;
                }
                String nbase = null;
                OptionType type = (OptionType)((Object)defs.get(base));
                if (type == null && base.toLowerCase().startsWith("no")) {
                    nbase = base.substring(2);
                    type = (OptionType)((Object)defs.get(nbase));
                }
                if (type != null) {
                    switch (type) {
                        case FLAG: {
                            if (nbase == null) {
                                VMCommandLine.registerOptionValue(options, base, Boolean.TRUE, type);
                                break;
                            }
                            VMCommandLine.registerOptionValue(options, nbase, Boolean.FALSE, type);
                            break;
                        }
                        case MANDATORY_STRING: 
                        case OPTIONAL_STRING: 
                        case MANDATORY_INTEGER: 
                        case OPTIONAL_INTEGER: 
                        case MANDATORY_FLOAT: 
                        case OPTIONAL_FLOAT: 
                        case MANDATORY_BOOLEAN: 
                        case OPTIONAL_BOOLEAN: {
                            if (val != null) {
                                VMCommandLine.registerOptionValue(options, base, val, type);
                                break;
                            }
                            waitingValue = type;
                            valueOptionName = base;
                            break;
                        }
                        default: {
                            VMCommandLine.registerOptionValue(options, base, val, type);
                            break;
                        }
                    }
                } else {
                    VMCommandLine.registerOptionValue(options, base, val, OptionType.SIMPLE);
                }
            }
            ++n4;
        }
        if (waitingValue != null && waitingValue.isMandatory()) {
            throw new IllegalStateException(Locale.getString("E2", valueOptionName));
        }
        commandLineParameters = new String[params.size()];
        params.toArray(commandLineParameters);
        params.clear();
        commandLineOptions = options;
        analyzed = true;
    }

    @Pure
    public boolean hasOption(String optionLabel) {
        return VMCommandLine.hasCommandLineOption(optionLabel);
    }

    @Pure
    public Object getFirstOptionValue(String optionLabel) {
        List<Object> options = VMCommandLine.getCommandLineOption(optionLabel);
        if (options == null || options.isEmpty()) {
            return null;
        }
        return options.get(0);
    }

    @Pure
    public List<Object> getOptionValues(String optionLabel) {
        List<Object> options = VMCommandLine.getCommandLineOption(optionLabel);
        if (options == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(options);
    }

    @Pure
    public String[] getParameters() {
        return VMCommandLine.getCommandLineParameters();
    }

    public String shiftParameters() {
        return VMCommandLine.shiftCommandLineParameters();
    }

    @Pure
    public int getParameterCount() {
        return VMCommandLine.getCommandLineParameters().length;
    }

    @Pure
    public String getParameterAt(int index) {
        return VMCommandLine.getCommandLineParameters()[index];
    }

    @Pure
    public boolean isParameterExists(int index) {
        String[] params = VMCommandLine.getCommandLineParameters();
        return index >= 0 && index < params.length && params[index] != null;
    }

    private static enum OptionType {
        SIMPLE,
        MANDATORY_STRING,
        OPTIONAL_STRING,
        MANDATORY_INTEGER,
        OPTIONAL_INTEGER,
        MANDATORY_FLOAT,
        OPTIONAL_FLOAT,
        MANDATORY_BOOLEAN,
        OPTIONAL_BOOLEAN,
        AUTO_INCREMENTED,
        FLAG;


        @Pure
        public boolean isMandatory() {
            return this == MANDATORY_BOOLEAN || this == MANDATORY_FLOAT || this == MANDATORY_STRING || this == MANDATORY_INTEGER;
        }

        @Pure
        public boolean isOptional() {
            return this == OPTIONAL_BOOLEAN || this == OPTIONAL_FLOAT || this == OPTIONAL_STRING || this == OPTIONAL_INTEGER;
        }
    }
}

