/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.util.Deque;
import java.util.EmptyStackException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.arakhne.afc.vmutil.ThreadServiceProvider;
import org.eclipse.xtext.xbase.lib.Pure;

public final class ThreadServiceFinder {
    private static final Deque<ThreadServiceProvider> SERVICES = new ConcurrentLinkedDeque<ThreadServiceProvider>();

    static {
        SERVICES.push(new DefaultProvider());
    }

    private ThreadServiceFinder() {
    }

    @Pure
    public static ThreadServiceProvider getProvider() {
        try {
            return SERVICES.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public static void addPreferredProvider(ThreadServiceProvider provider) {
        SERVICES.push(provider);
    }

    public static void removeProvider() {
        SERVICES.pop();
    }

    static class DefaultProvider
    implements ThreadServiceProvider {
        private ExecutorService executorService;
        private ScheduledExecutorService scheduledExecutorService;

        DefaultProvider() {
        }

        @Override
        @Pure
        public ExecutorService getExecutorService() {
            if (this.executorService == null) {
                this.executorService = Executors.newCachedThreadPool();
            }
            return this.executorService;
        }

        @Override
        @Pure
        public ScheduledExecutorService getScheduledExecutorService() {
            if (this.scheduledExecutorService == null) {
                this.scheduledExecutorService = Executors.newScheduledThreadPool(3);
            }
            return this.scheduledExecutorService;
        }
    }
}

