/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.util;

import java.io.Serializable;
import java.util.Objects;
import org.arakhne.afc.vmutil.locale.Locale;
import org.eclipse.xtext.xbase.lib.Pure;

public class MultiValue<T>
implements Serializable {
    private static final long serialVersionUID = -3030110135594544927L;
    private boolean isSet;
    private boolean isMultiple;
    private T object;

    public MultiValue(T initialValue) {
        this.object = initialValue;
        this.isSet = true;
    }

    public MultiValue() {
        this.object = null;
    }

    @Pure
    public String toString() {
        return this.toString(Locale.getString("MULTIPLE_VALUES", new Object[0]));
    }

    @Pure
    public String toString(String multiValueLabel) {
        if (this.isSet) {
            if (this.isMultiple) {
                return multiValueLabel;
            }
            if (this.object != null) {
                return this.object.toString();
            }
        }
        return "";
    }

    @Pure
    public T get() {
        return this.object;
    }

    @Pure
    public Class<? extends T> getValueType() {
        if (this.object == null) {
            return null;
        }
        return this.object.getClass();
    }

    public void add(T newValue) {
        if (this.isSet) {
            if (!(this.isMultiple || newValue == this.object || newValue != null && newValue.equals(this.object))) {
                this.isMultiple = true;
                this.object = null;
            }
        } else {
            this.object = newValue;
            this.isSet = true;
            this.isMultiple = false;
        }
    }

    public void clear() {
        this.object = null;
        this.isSet = false;
        this.isMultiple = false;
    }

    @Pure
    public boolean isSet() {
        return this.isSet;
    }

    @Pure
    public boolean isMultipleDifferentValues() {
        return this.isMultiple;
    }

    public void setMultipleDifferentValues(boolean multiple) {
        this.isMultiple = true;
        this.isSet = true;
    }

    @Pure
    public boolean equals(Object obj) {
        if (obj instanceof MultiValue) {
            MultiValue v = (MultiValue)obj;
            if (this.isSet != v.isSet || this.isMultiple != v.isMultiple) {
                return false;
            }
        }
        return this.object == obj || this.object != null && this.object.equals(obj);
    }

    @Pure
    public int hashCode() {
        int hash = Boolean.hashCode(this.isSet);
        hash = 31 * hash + Boolean.hashCode(this.isMultiple);
        if (this.object != null) {
            hash = 31 * hash + Objects.hashCode(this.object);
        }
        return hash ^ hash >> 31;
    }
}

