/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.xtext.xbase.lib.Pure;

public class MultiCollection<E>
implements Collection<E> {
    private final List<Collection<? extends E>> collections = new ArrayList<Collection<? extends E>>();

    public void addCollection(Collection<? extends E> collection) {
        if (collection != null && !collection.isEmpty()) {
            this.collections.add(collection);
        }
    }

    public boolean removeCollection(Collection<? extends E> collection) {
        return this.collections.remove(collection);
    }

    @Override
    public void clear() {
        this.collections.clear();
    }

    @Override
    public boolean add(E value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Pure
    public boolean contains(Object obj) {
        for (Collection<E> c : this.collections) {
            if (!c.contains(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Pure
    public boolean containsAll(Collection<?> collection) {
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Pure
    public boolean isEmpty() {
        for (Collection<E> c : this.collections) {
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Pure
    public Iterator<E> iterator() {
        return new MultiIterator<E>(this.collections.iterator());
    }

    @Override
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Pure
    public int size() {
        int t = 0;
        for (Collection<E> c : this.collections) {
            t += c.size();
        }
        return t;
    }

    @Override
    @Pure
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        throw new UnsupportedOperationException();
    }

    public static class MultiIterator<E>
    implements Iterator<E> {
        private final Iterator<Collection<? extends E>> iterator;
        private Iterator<? extends E> currentIterator;

        public MultiIterator(Iterator<Collection<? extends E>> iterator) {
            this.iterator = iterator;
            this.searchNext();
        }

        private void searchNext() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                this.currentIterator = null;
                while (this.currentIterator == null && this.iterator.hasNext()) {
                    Collection<E> iterable = this.iterator.next();
                    Iterator<E> iter = iterable.iterator();
                    if (!iter.hasNext()) continue;
                    this.currentIterator = iter;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public E next() {
            if (this.currentIterator == null) {
                throw new NoSuchElementException();
            }
            E n = this.currentIterator.next();
            this.searchNext();
            return n;
        }
    }
}

