/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.util;

import java.util.Comparator;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Pure;

public final class ListUtil {
    private ListUtil() {
    }

    public static <E> int remove(List<E> list, Comparator<? super E> comparator, E data) {
        assert (list != null);
        assert (comparator != null);
        assert (data != null);
        int first = 0;
        int last = list.size() - 1;
        while (last >= first) {
            int center = (first + last) / 2;
            E dt = list.get(center);
            int cmpR = comparator.compare(data, dt);
            if (cmpR == 0) {
                list.remove(center);
                return center;
            }
            if (cmpR < 0) {
                last = center - 1;
                continue;
            }
            first = center + 1;
        }
        return -1;
    }

    public static <E> int add(List<E> list, Comparator<? super E> comparator, E data, boolean allowMultipleOccurencesOfSameValue, boolean allowReplacement) {
        assert (list != null);
        assert (comparator != null);
        assert (data != null);
        int first = 0;
        int last = list.size() - 1;
        while (last >= first) {
            int center = (first + last) / 2;
            E dt = list.get(center);
            int cmpR = comparator.compare(data, dt);
            if (cmpR == 0 && !allowMultipleOccurencesOfSameValue) {
                if (allowReplacement) {
                    list.set(center, data);
                    return center;
                }
                return -1;
            }
            if (cmpR < 0) {
                last = center - 1;
                continue;
            }
            first = center + 1;
        }
        list.add(first, data);
        return first;
    }

    @Pure
    public static <E> boolean contains(List<E> list, Comparator<? super E> comparator, E data) {
        assert (list != null);
        assert (comparator != null);
        assert (data != null);
        int first = 0;
        int last = list.size() - 1;
        while (last >= first) {
            int center = (first + last) / 2;
            E dt = list.get(center);
            int cmpR = comparator.compare(data, dt);
            if (cmpR == 0) {
                return true;
            }
            if (cmpR < 0) {
                last = center - 1;
                continue;
            }
            first = center + 1;
        }
        return false;
    }

    @Pure
    public static <T> int indexOf(List<T> list, Comparator<? super T> comparator, T elt) {
        block10: {
            assert (comparator != null);
            assert (list != null);
            if (elt != null) break block10;
            return -1;
        }
        try {
            int first = 0;
            int last = list.size() - 1;
            while (last >= first) {
                int center = (first + last) / 2;
                T indata = list.get(center);
                int cmp = comparator.compare(elt, indata);
                if (cmp == 0) {
                    while (--center >= 0 && comparator.compare(elt, list.get(center)) == 0) {
                    }
                    return center + 1;
                }
                if (cmp < 0) {
                    last = center - 1;
                    continue;
                }
                first = center + 1;
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {}
        return -1;
    }

    @Pure
    public static <T> int lastIndexOf(List<T> list, Comparator<? super T> comparator, T elt) {
        block10: {
            assert (comparator != null);
            assert (list != null);
            if (elt != null) break block10;
            return -1;
        }
        try {
            int first = 0;
            int last = list.size() - 1;
            while (last >= first) {
                int c = (first + last) / 2;
                T indata = list.get(c);
                int cmp = comparator.compare(elt, indata);
                if (cmp == 0) {
                    while (++c < list.size() && comparator.compare(elt, list.get(c)) == 0) {
                    }
                    return c - 1;
                }
                if (cmp < 0) {
                    last = c - 1;
                    continue;
                }
                first = c + 1;
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {}
        return -1;
    }

    @Pure
    public static <T> int getInsertionIndex(List<T> list, Comparator<? super T> comparator, T elt) {
        return ListUtil.getInsertionIndex(list, comparator, elt, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Pure
    public static <T> int getInsertionIndex(List<T> list, Comparator<? super T> comparator, T elt, boolean allowMultiple) {
        try {
            assert (comparator != null);
            assert (list != null);
            if (elt == null) {
                return -1;
            }
            int first = 0;
            int last = list.size() - 1;
            while (true) {
                if (last < first) {
                    return first;
                }
                int center = (first + last) / 2;
                T indata = list.get(center);
                int comparison = comparator.compare(elt, indata);
                if (!allowMultiple && comparison == 0) {
                    return -1;
                }
                if (comparison < 0) {
                    last = center - 1;
                    continue;
                }
                first = center + 1;
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    @Pure
    public static <T> int ceilingIndex(List<T> list, Comparator<? super T> comparator, T elt) {
        block11: {
            assert (comparator != null);
            assert (list != null);
            if (elt != null) break block11;
            return -1;
        }
        try {
            int first = 0;
            int last = list.size() - 1;
            while (last >= first) {
                int c = (first + last) / 2;
                T indata = list.get(c);
                int cmp = comparator.compare(elt, indata);
                if (cmp == 0) {
                    while (--c >= 0 && comparator.compare(elt, list.get(c)) == 0) {
                    }
                    return c + 1;
                }
                if (cmp < 0) {
                    last = c - 1;
                    continue;
                }
                first = c + 1;
            }
            if (first >= list.size()) {
                first = -1;
            }
            return first;
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    @Pure
    public static <T> int floorIndex(List<T> list, Comparator<? super T> comparator, T elt) {
        block10: {
            assert (comparator != null);
            assert (list != null);
            if (elt != null) break block10;
            return -1;
        }
        try {
            int first = 0;
            int last = list.size() - 1;
            while (last >= first) {
                int center = (first + last) / 2;
                T indata = list.get(center);
                int cmp = comparator.compare(elt, indata);
                if (cmp == 0) {
                    while (++center < list.size() && comparator.compare(elt, list.get(center)) == 0) {
                    }
                    return center - 1;
                }
                if (cmp < 0) {
                    last = center - 1;
                    continue;
                }
                first = center + 1;
            }
            return last;
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    @Pure
    public static <T> int higherIndex(List<T> list, Comparator<? super T> comparator, T elt) {
        block9: {
            assert (comparator != null);
            assert (list != null);
            if (elt != null) break block9;
            return -1;
        }
        try {
            int first = 0;
            int last = list.size() - 1;
            while (last >= first) {
                int center = (first + last) / 2;
                T indata = list.get(center);
                int cmp = comparator.compare(elt, indata);
                if (cmp < 0) {
                    last = center - 1;
                    continue;
                }
                first = center + 1;
            }
            if (++last >= list.size()) {
                last = -1;
            }
            return last;
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    @Pure
    public static <T> int lowerIndex(List<T> list, Comparator<? super T> comparator, T elt) {
        block8: {
            assert (comparator != null);
            assert (list != null);
            if (elt != null) break block8;
            return -1;
        }
        try {
            int first = 0;
            int last = list.size() - 1;
            while (last >= first) {
                int center = (first + last) / 2;
                T indata = list.get(center);
                int cmp = comparator.compare(elt, indata);
                if (cmp <= 0) {
                    last = center - 1;
                    continue;
                }
                first = center + 1;
            }
            return last;
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }
}

