/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.TreeSet;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public class IntegerList
implements SortedSet<Integer>,
List<Integer> {
    private int[] values;
    private int size;

    public IntegerList() {
        this.values = null;
        this.size = 0;
    }

    public IntegerList(int value) {
        this.values = new int[]{value, value};
        this.size = 1;
    }

    public IntegerList(int start, int end) {
        int theStart = start;
        int theEnd = end;
        if (theStart > theEnd) {
            int tmp = theStart;
            theStart = theEnd;
            theEnd = tmp;
        }
        this.values = new int[]{theStart, theEnd};
        this.size = theEnd - theStart + 1;
    }

    public IntegerList(Collection<? extends Integer> collection) {
        this.values = null;
        this.size = 0;
        this.addAll(collection);
    }

    @Pure
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        if (this.values != null) {
            int idxStart = 0;
            while (idxStart < this.values.length - 1) {
                if (idxStart > 0) {
                    buffer.append(',');
                }
                if (this.values[idxStart] == this.values[idxStart + 1]) {
                    buffer.append(this.values[idxStart]);
                } else if (this.values[idxStart] + 1 == this.values[idxStart + 1]) {
                    buffer.append(this.values[idxStart]);
                    buffer.append(',');
                    buffer.append(this.values[idxStart + 1]);
                } else {
                    buffer.append(this.values[idxStart]);
                    buffer.append('-');
                    buffer.append(this.values[idxStart + 1]);
                }
                idxStart += 2;
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    @Override
    @Pure
    @Inline(value="null", constantExpression=true)
    public Comparator<? super Integer> comparator() {
        return null;
    }

    @Override
    @Pure
    public Integer first() {
        if (this.values == null) {
            throw new NoSuchElementException();
        }
        return this.values[0];
    }

    @Override
    @Pure
    public SortedSet<Integer> headSet(Integer toElement) {
        TreeSet<Integer> theset = new TreeSet<Integer>();
        if (this.values != null) {
            int idxStart = 0;
            while (idxStart < this.values.length - 1) {
                if (this.values[idxStart] >= toElement) break;
                int intToAdd = this.values[idxStart];
                while (intToAdd < toElement && intToAdd <= this.values[idxStart + 1]) {
                    theset.add(intToAdd);
                    ++intToAdd;
                }
                idxStart += 2;
            }
        }
        return theset;
    }

    @Override
    @Pure
    public Integer last() {
        if (this.values == null) {
            throw new NoSuchElementException();
        }
        return this.values[this.values.length - 1];
    }

    @Override
    @Pure
    public SortedSet<Integer> subSet(Integer fromElement, Integer toElement) {
        TreeSet<Integer> theset = new TreeSet<Integer>();
        if (this.values != null) {
            int max;
            int firstSegment = -1;
            int idxSegment = 0;
            while (firstSegment == -1 && idxSegment < this.values.length) {
                max = this.values[idxSegment + 1];
                if (fromElement.compareTo(max) <= 0) {
                    firstSegment = idxSegment;
                }
                idxSegment += 2;
            }
            if (firstSegment != -1) {
                idxSegment = firstSegment;
                while (idxSegment < this.values.length) {
                    int min = this.values[idxSegment];
                    max = this.values[idxSegment + 1];
                    if (toElement.compareTo(min) <= 0) {
                        idxSegment = this.values.length;
                    } else {
                        int value = min;
                        while (toElement.compareTo(value) > 0 && value <= max) {
                            assert (toElement.compareTo(value) > 0);
                            if (fromElement.compareTo(value) <= 0) {
                                theset.add(value);
                            }
                            ++value;
                        }
                    }
                    idxSegment += 2;
                }
            }
        }
        return theset;
    }

    @Override
    @Pure
    public SortedSet<Integer> tailSet(Integer fromElement) {
        TreeSet<Integer> theset = new TreeSet<Integer>();
        if (this.values != null) {
            int idxStart = 0;
            while (idxStart < this.values.length - 1) {
                if (this.values[idxStart + 1] >= fromElement) {
                    int intToAdd;
                    if (fromElement >= this.values[idxStart]) {
                        intToAdd = fromElement;
                        while (intToAdd <= this.values[idxStart + 1]) {
                            theset.add(intToAdd);
                            ++intToAdd;
                        }
                    }
                    if (fromElement < this.values[idxStart]) {
                        intToAdd = this.values[idxStart];
                        while (intToAdd <= this.values[idxStart + 1]) {
                            theset.add(intToAdd);
                            ++intToAdd;
                        }
                    }
                }
                idxStart += 2;
            }
        }
        return theset;
    }

    @Override
    public final void add(int index, Integer element) {
        this.add(element);
    }

    @Override
    public boolean add(Integer value) {
        if (this.values == null) {
            this.values = new int[]{value, value};
            this.size = 1;
        } else {
            int first = 0;
            int last = this.getSegmentCount() - 1;
            while (first <= last) {
                int center = (first + last) / 2;
                int min = this.values[center * 2];
                int max = this.values[center * 2 + 1];
                if (value.compareTo(min) >= 0 && value.compareTo(max) <= 0) {
                    return false;
                }
                if (value.compareTo(min) < 0) {
                    last = center - 1;
                    continue;
                }
                first = center + 1;
            }
            int index = first * 2;
            boolean mergeWithPrevious = index > 0 && value.compareTo(this.values[index - 1] + 1) == 0;
            boolean mergeWithNext = index < this.values.length && value.compareTo(this.values[index] - 1) == 0;
            ++this.size;
            if (mergeWithPrevious && mergeWithNext) {
                this.values[index - 1] = this.values[index + 1];
                int[] nValues = new int[this.values.length - 2];
                System.arraycopy(this.values, 0, nValues, 0, index);
                System.arraycopy(this.values, index + 2, nValues, index, this.values.length - index - 2);
                this.values = nValues;
            } else if (mergeWithPrevious) {
                this.values[index - 1] = value;
            } else if (mergeWithNext) {
                this.values[index] = value;
            } else {
                int[] nValues = new int[this.values.length + 2];
                System.arraycopy(this.values, 0, nValues, 0, index);
                nValues[index] = value;
                nValues[index + 1] = nValues[index];
                System.arraycopy(this.values, index, nValues, index + 2, this.values.length - index);
                this.values = nValues;
            }
        }
        return true;
    }

    @Override
    public final boolean addAll(int index, Collection<? extends Integer> collection) {
        return this.addAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        boolean changed = false;
        for (Integer n : collection) {
            changed |= this.add(n);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.values = null;
        this.size = 0;
    }

    @Override
    @Pure
    public boolean contains(Object obj) {
        if (this.values != null && obj instanceof Number) {
            int e = ((Number)obj).intValue();
            int idxStart = 0;
            while (idxStart < this.values.length - 1) {
                if (e < this.values[idxStart]) {
                    return false;
                }
                if (e >= this.values[idxStart] && e <= this.values[idxStart + 1]) {
                    return true;
                }
                idxStart += 2;
            }
        }
        return false;
    }

    @Override
    @Pure
    public boolean containsAll(Collection<?> collection) {
        if (this.values == null) {
            return false;
        }
        TreeSet<Integer> elements = new TreeSet<Integer>();
        for (Object o : collection) {
            if (!(o instanceof Number)) continue;
            elements.add(((Number)o).intValue());
        }
        int idxStart = 0;
        block1: for (Integer e : elements) {
            while (idxStart < this.values.length - 1) {
                if (e < this.values[idxStart]) {
                    return false;
                }
                if (e >= this.values[idxStart] && e <= this.values[idxStart + 1]) continue block1;
                idxStart += 2;
            }
        }
        return true;
    }

    @Override
    @Pure
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @Pure
    public Iterator<Integer> iterator() {
        return new IntegerListIterator();
    }

    @Pure
    public Iterator<IntegerSegment> segmentIterator() {
        return new SegmentIterator();
    }

    @Pure
    public Iterable<IntegerSegment> toSegmentIterable() {
        return new Iterable<IntegerSegment>(){

            @Override
            public Iterator<IntegerSegment> iterator() {
                return new SegmentIterator();
            }
        };
    }

    @Override
    public boolean remove(Object obj) {
        int e;
        int segmentIndex;
        return this.values != null && obj instanceof Number && (segmentIndex = this.getSegmentIndexFor(e = ((Number)obj).intValue())) >= 0 && this.removeElementInSegment(segmentIndex, e);
    }

    @Override
    public Integer remove(int index) {
        if (this.values == null) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int firstIndex = 0;
        int idxStart = 0;
        while (idxStart < this.values.length - 1) {
            int endIndex = this.values[idxStart + 1] - this.values[idxStart] + firstIndex;
            if (index >= firstIndex && index <= endIndex) {
                int elementToRemove = this.values[idxStart] + index - firstIndex;
                if (!this.removeElementInSegment(idxStart, elementToRemove)) {
                    throw new IndexOutOfBoundsException(Integer.toString(index));
                }
                return elementToRemove;
            }
            firstIndex = endIndex + 1;
            idxStart += 2;
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    protected boolean removeElementInSegment(int segmentIndex, int element) {
        if (element == this.values[segmentIndex] && element == this.values[segmentIndex + 1]) {
            if (this.values.length == 2) {
                this.values = null;
                this.size = 0;
            } else {
                int[] newTab = new int[this.values.length - 2];
                System.arraycopy(this.values, 0, newTab, 0, segmentIndex);
                System.arraycopy(this.values, segmentIndex + 2, newTab, segmentIndex, newTab.length - segmentIndex);
                this.values = newTab;
                --this.size;
            }
            return true;
        }
        if (element >= this.values[segmentIndex] && element <= this.values[segmentIndex + 1]) {
            if (element == this.values[segmentIndex]) {
                int n = segmentIndex;
                this.values[n] = this.values[n] + 1;
                --this.size;
            } else if (element == this.values[segmentIndex + 1]) {
                int n = segmentIndex + 1;
                this.values[n] = this.values[n] - 1;
                --this.size;
            } else {
                int[] newTab = new int[this.values.length + 2];
                System.arraycopy(this.values, 0, newTab, 0, segmentIndex + 1);
                System.arraycopy(this.values, segmentIndex + 1, newTab, segmentIndex + 3, newTab.length - segmentIndex - 3);
                newTab[segmentIndex + 1] = element - 1;
                newTab[segmentIndex + 2] = element + 1;
                this.values = newTab;
                --this.size;
            }
            return true;
        }
        return false;
    }

    protected boolean removeSegment(int segmentIndex) {
        if (this.values == null || segmentIndex < 0 || segmentIndex >= this.values.length - 1) {
            return false;
        }
        if (this.values.length == 2) {
            this.values = null;
            this.size = 0;
        } else {
            int count = this.values[segmentIndex + 1] - this.values[segmentIndex] + 1;
            int[] newTab = new int[this.values.length - 2];
            System.arraycopy(this.values, 0, newTab, 0, segmentIndex);
            System.arraycopy(this.values, segmentIndex + 2, newTab, segmentIndex, this.values.length - segmentIndex);
            this.values = newTab;
            this.size -= count;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object o : collection) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        SortedSet<Integer> theset = this.toSortedSet();
        boolean changed = theset.retainAll(collection);
        if (changed) {
            this.set(theset);
        }
        return changed;
    }

    @Override
    public Integer set(int index, Integer element) {
        Integer oldValue = this.remove(index);
        this.add(element);
        return oldValue;
    }

    public void set(SortedSet<? extends Number> collection) {
        this.values = null;
        this.size = 0;
        for (Number number : collection) {
            int e = number.intValue();
            if (this.values != null && e == this.values[this.values.length - 1] + 1) {
                int n = this.values.length - 1;
                this.values[n] = this.values[n] + 1;
                ++this.size;
            }
            if (this.values != null && e > this.values[this.values.length - 1] + 1) {
                int[] newTab = new int[this.values.length + 2];
                System.arraycopy(this.values, 0, newTab, 0, this.values.length);
                newTab[newTab.length - 2] = e;
                newTab[newTab.length - 1] = newTab[newTab.length - 2];
                this.values = newTab;
                ++this.size;
                continue;
            }
            if (this.values != null) continue;
            this.values = new int[]{e, e};
            this.size = 1;
        }
    }

    @Override
    @Pure
    public int size() {
        return this.size;
    }

    protected int getSegmentCount() {
        return this.values == null ? 0 : this.values.length / 2;
    }

    protected int getLastValueOnSegment(int idxSegment) {
        assert (idxSegment % 2 == 0);
        if (this.values == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[idxSegment + 1];
    }

    protected int getFirstValueOnSegment(int idxSegment) {
        assert (idxSegment % 2 == 0);
        if (this.values == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[idxSegment];
    }

    protected int getSegmentIndexFor(int value) {
        if (this.values != null) {
            int first = 0;
            int last = this.getSegmentCount() - 1;
            while (first <= last) {
                int center = (first + last) / 2;
                int min = this.values[center * 2];
                int max = this.values[center * 2 + 1];
                if (value >= min && value <= max) {
                    return center * 2;
                }
                if (value < min) {
                    last = center - 1;
                    continue;
                }
                first = center + 1;
            }
        }
        return -1;
    }

    @Override
    @Pure
    public Integer get(int index) {
        if (this.values == null) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int firstIndex = 0;
        int idxStart = 0;
        while (idxStart < this.values.length - 1) {
            int endIndex = this.values[idxStart + 1] - this.values[idxStart] + firstIndex;
            if (index >= firstIndex && index <= endIndex) {
                return this.values[idxStart] + index - firstIndex;
            }
            firstIndex = endIndex + 1;
            idxStart += 2;
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    protected boolean get(int offset, int[] tofill) {
        if (this.values != null) {
            int idxTab = 0;
            int idxStart = 0;
            while (idxStart < this.values.length - 1) {
                int n = this.values[idxStart];
                while (n <= this.values[idxStart + 1]) {
                    if (offset == idxTab) {
                        tofill[0] = idxStart;
                        tofill[1] = n;
                        return true;
                    }
                    ++idxTab;
                    ++n;
                }
                idxStart += 2;
            }
        }
        tofill[0] = -1;
        tofill[1] = 0;
        return false;
    }

    @Override
    @Pure
    public Object[] toArray() {
        Object[] tab = new Object[this.size];
        if (this.values != null) {
            int idxTab = 0;
            int idxStart = 0;
            while (idxStart < this.values.length - 1) {
                int n = this.values[idxStart];
                while (n <= this.values[idxStart + 1]) {
                    tab[idxTab++] = n;
                    ++n;
                }
                idxStart += 2;
            }
        }
        return tab;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Class<Integer> clazz = array.getClass().getComponentType();
        if (!clazz.isAssignableFrom(Integer.class)) {
            throw new ArrayStoreException();
        }
        Object[] tab = array;
        if (tab.length < this.size) {
            tab = (Object[])Array.newInstance(clazz, this.size);
        }
        if (this.values != null) {
            int idxTab = 0;
            int idxStart = 0;
            while (idxStart < this.values.length - 1) {
                int n = this.values[idxStart];
                while (n <= this.values[idxStart + 1]) {
                    tab[idxTab++] = n;
                    ++n;
                }
                idxStart += 2;
            }
        }
        return tab;
    }

    @Pure
    public int[] toIntArray() {
        int[] tab = new int[this.size];
        if (this.values != null) {
            int idxTab = 0;
            int idxStart = 0;
            while (idxStart < this.values.length - 1) {
                int n = this.values[idxStart];
                while (n <= this.values[idxStart + 1]) {
                    tab[idxTab++] = n++;
                }
                idxStart += 2;
            }
        }
        return tab;
    }

    @Pure
    public SortedSet<Integer> toSortedSet() {
        TreeSet<Integer> theset = new TreeSet<Integer>();
        if (this.values != null) {
            int idxStart = 0;
            while (idxStart < this.values.length - 1) {
                int n = this.values[idxStart];
                while (n <= this.values[idxStart + 1]) {
                    theset.add(n);
                    ++n;
                }
                idxStart += 2;
            }
        }
        return theset;
    }

    @Override
    @Pure
    public int indexOf(Object obj) {
        if (obj instanceof Number) {
            int e = ((Number)obj).intValue();
            if (this.values != null) {
                int idx = 0;
                int idxStart = 0;
                while (idxStart < this.values.length - 1) {
                    int n = this.values[idxStart];
                    while (n <= this.values[idxStart + 1]) {
                        if (n == e) {
                            return idx;
                        }
                        ++idx;
                        ++n;
                    }
                    idxStart += 2;
                }
            }
            return -1;
        }
        if (obj == null) {
            throw new NullPointerException();
        }
        throw new ClassCastException();
    }

    @Override
    @Pure
    public int lastIndexOf(Object obj) {
        if (obj instanceof Number) {
            int e = ((Number)obj).intValue();
            if (this.values != null) {
                int idx = this.size - 1;
                int idxStart = this.values.length - 2;
                while (idxStart >= 0) {
                    int n = this.values[idxStart + 1];
                    while (n >= this.values[idxStart]) {
                        if (n == e) {
                            return idx;
                        }
                        --idx;
                        --n;
                    }
                    idxStart -= 2;
                }
            }
            return -1;
        }
        if (obj == null) {
            throw new NullPointerException();
        }
        throw new ClassCastException();
    }

    @Override
    @Pure
    public ListIterator<Integer> listIterator() {
        return new IntegerListIterator();
    }

    @Override
    @Pure
    public ListIterator<Integer> listIterator(int index) {
        return new IntegerListIterator(index);
    }

    @Override
    @Pure
    public List<Integer> subList(int fromIndex, int toIndex) {
        ArrayList<Integer> theList = new ArrayList<Integer>();
        if (this.values != null) {
            int min;
            int max;
            int firstSegment = -1;
            int idxValue = 0;
            int idxSegment = 0;
            while (firstSegment == -1 && idxSegment < this.values.length) {
                max = this.values[idxSegment + 1];
                min = this.values[idxSegment];
                int nb = max - min + 1;
                if (fromIndex < idxValue + nb) {
                    firstSegment = idxSegment;
                } else {
                    idxValue += nb;
                }
                idxSegment += 2;
            }
            if (firstSegment != -1) {
                idxSegment = firstSegment;
                while (idxSegment < this.values.length) {
                    min = this.values[idxSegment];
                    max = this.values[idxSegment + 1];
                    if (toIndex <= idxValue) {
                        idxSegment = this.values.length;
                    } else {
                        int value = min;
                        while (idxValue < toIndex && value <= max) {
                            if (fromIndex <= idxValue) {
                                theList.add(value);
                            }
                            ++idxValue;
                            ++value;
                        }
                    }
                    idxSegment += 2;
                }
            }
        }
        return theList;
    }

    @Override
    @Pure
    public Spliterator<Integer> spliterator() {
        return SortedSet.super.spliterator();
    }

    private class IntegerListIterator
    implements ListIterator<Integer> {
        private final int offset;
        private int tabIndex;
        private int segmentIndex;
        private int number;

        IntegerListIterator(int startingIndex) {
            this.offset = startingIndex;
            int lsize = IntegerList.this.size();
            if (startingIndex >= 0 && startingIndex < lsize) {
                this.tabIndex = startingIndex;
                int[] tab = new int[2];
                IntegerList.this.get(startingIndex, tab);
                this.segmentIndex = tab[0];
                this.number = tab[1];
            } else {
                this.tabIndex = -1;
                this.segmentIndex = -1;
            }
        }

        IntegerListIterator() {
            this.offset = 0;
            if (IntegerList.this.isEmpty()) {
                this.tabIndex = -1;
                this.segmentIndex = -1;
            } else {
                this.tabIndex = 0;
                this.segmentIndex = 0;
                this.number = IntegerList.this.getFirstValueOnSegment(this.segmentIndex);
            }
        }

        @Override
        public boolean hasNext() {
            return this.tabIndex >= this.offset && this.tabIndex < IntegerList.this.size();
        }

        @Override
        public int nextIndex() {
            int lsize = IntegerList.this.size();
            if (this.tabIndex >= this.offset && this.tabIndex < lsize) {
                return this.tabIndex;
            }
            return lsize;
        }

        @Override
        public Integer next() {
            if (this.tabIndex < this.offset || this.tabIndex >= IntegerList.this.size()) {
                throw new NoSuchElementException();
            }
            int n = this.number;
            int lsize = IntegerList.this.size();
            ++this.tabIndex;
            if (this.tabIndex >= this.offset && this.tabIndex < lsize) {
                if (this.number == IntegerList.this.getLastValueOnSegment(this.segmentIndex)) {
                    this.segmentIndex += 2;
                    this.number = IntegerList.this.getFirstValueOnSegment(this.segmentIndex);
                } else {
                    ++this.number;
                }
            }
            return n;
        }

        @Override
        public boolean hasPrevious() {
            int idx = this.tabIndex - 1;
            return idx >= this.offset && idx < IntegerList.this.size();
        }

        @Override
        public int previousIndex() {
            int idx = this.tabIndex - 1;
            return idx >= this.offset && idx < IntegerList.this.size() ? idx : -1;
        }

        @Override
        public Integer previous() {
            int idx = this.tabIndex - 1;
            if (idx < this.offset || idx >= IntegerList.this.size()) {
                throw new NoSuchElementException();
            }
            int n = IntegerList.this.get(idx);
            int lsize = IntegerList.this.size();
            --this.tabIndex;
            if (this.tabIndex >= this.offset && this.tabIndex < lsize) {
                if (this.number == IntegerList.this.getFirstValueOnSegment(this.segmentIndex)) {
                    this.segmentIndex -= 2;
                    this.number = IntegerList.this.getLastValueOnSegment(this.segmentIndex);
                } else {
                    --this.number;
                }
            }
            return n;
        }

        @Override
        public void add(Integer value) {
            if (value == this.number) {
                return;
            }
            if (IntegerList.this.add(value) && value < this.number) {
                ++this.tabIndex;
                this.segmentIndex = IntegerList.this.getSegmentIndexFor(this.number);
            }
        }

        @Override
        public void set(Integer vallue) {
            this.add(vallue);
        }

        @Override
        public void remove() {
            int lsize = IntegerList.this.size();
            if (this.tabIndex > 1 && this.tabIndex < lsize) {
                IntegerList.this.remove(this.tabIndex - 1);
                --this.tabIndex;
                this.segmentIndex = IntegerList.this.getSegmentIndexFor(this.number);
            }
            throw new IllegalStateException();
        }
    }

    public class IntegerSegment {
        private final int first;
        private final int last;

        IntegerSegment(int first, int last) {
            this.first = first;
            this.last = last;
        }

        public int getFirst() {
            return this.first;
        }

        public int getLast() {
            return this.last;
        }
    }

    private class SegmentIterator
    implements Iterator<IntegerSegment> {
        private int index = 0;
        private boolean removable = false;

        SegmentIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < IntegerList.this.values.length;
        }

        @Override
        public IntegerSegment next() {
            if (this.index >= IntegerList.this.values.length) {
                throw new ConcurrentModificationException();
            }
            try {
                int first = IntegerList.this.values[this.index];
                int last = IntegerList.this.values[this.index + 1];
                this.index += 2;
                this.removable = true;
                return new IntegerSegment(first, last);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            int idx;
            if (this.removable) {
                idx = this.index - 2;
                if (idx < 0 || idx >= IntegerList.this.values.length) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new NoSuchElementException();
            }
            IntegerList.this.removeSegment(idx);
            this.removable = false;
        }
    }
}

