/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.progress;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.arakhne.afc.progress.Progression;

public class ProgressionOuputStream
extends FilterOutputStream {
    private final Progression monitor;
    private final int totalSize;
    private int write;

    public ProgressionOuputStream(OutputStream out, int totalSize, Progression progression) {
        super(out);
        this.monitor = progression;
        this.totalSize = totalSize >= 0 ? totalSize : 0;
        this.monitor.setProperties(0, 0, this.totalSize, false);
    }

    public Progression getProgression() {
        return this.monitor;
    }

    @Override
    public void write(int abyte) throws IOException {
        this.out.write(abyte);
        this.monitor.setValue(++this.write);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.out.write(buffer);
        this.write += buffer.length;
        this.monitor.setValue(this.write);
    }

    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        this.out.write(buffer, off, len);
        this.write += len;
        this.monitor.setValue(this.write);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.monitor.end();
    }
}

