/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.util;

import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public final class Collections3 {
    public static final SynchronizedSet<Object> EMPTY_SET = new EmptySet();

    private Collections3() {
    }

    public static <T> SynchronizedSet<T> synchronizedSet(Set<T> set, Object mutex) {
        return new SynchronizedSetWrapper<T>(set, mutex);
    }

    public static <T> SynchronizedCollection<T> synchronizedCollection(Collection<T> collection, Object mutex) {
        return new SynchronizedCollectionWrapper<T>(collection, mutex);
    }

    public static <T> SynchronizedSet<T> emptySynchronizedSet() {
        return EMPTY_SET;
    }

    public static <T> SynchronizedSet<T> synchronizedSingleton(T element) {
        return new SingletonSet<T>(element);
    }

    public static <T> SynchronizedSet<T> unmodifiableSynchronizedSet(SynchronizedSet<T> elements) {
        return new UnmodifiableSetWrapper<T>(elements);
    }

    public static <T> SynchronizedSet<T> unmodifiableSynchronizedSet(Set<T> elements, Object mutex) {
        return new UnmodifiableSynchronizedSetWrapper<T>(elements, mutex);
    }

    private static class EmptySet
    extends AbstractSet<Object>
    implements SynchronizedSet<Object>,
    Serializable {
        private static final long serialVersionUID = -3127287187730958288L;

        EmptySet() {
        }

        @Override
        public Object mutex() {
            return new Object();
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    private static class SingletonSet<T>
    extends AbstractSet<T>
    implements SynchronizedSet<T>,
    Serializable {
        private static final long serialVersionUID = -143726600219970259L;
        private final T singleton;

        SingletonSet(T singleton) {
            this.singleton = singleton;
        }

        @Override
        public Object mutex() {
            return this;
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.singleton(this.singleton).iterator();
        }

        @Override
        public int size() {
            return 1;
        }
    }

    private static class SynchronizedCollectionWrapper<E>
    implements Serializable,
    SynchronizedCollection<E> {
        private static final long serialVersionUID = -7369575596119505391L;
        final Collection<E> collection;
        final Object mutex;

        SynchronizedCollectionWrapper(Collection<E> collection, Object mutex) {
            this.collection = collection;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.equals(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.collection.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] output) {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.toArray(output);
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.collection.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E element) {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.add(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object element) {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.remove(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.containsAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.addAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.removeAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.retainAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.collection.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.collection.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }

        @Override
        public Object mutex() {
            return this.mutex;
        }
    }

    private static class SynchronizedSetWrapper<E>
    extends SynchronizedCollectionWrapper<E>
    implements SynchronizedSet<E> {
        private static final long serialVersionUID = -4653222127490655349L;

        SynchronizedSetWrapper(Set<E> set, Object mutex) {
            super(set, mutex);
        }
    }

    private static class UnmodifiableIterator<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;

        UnmodifiableIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableSetWrapper<E>
    implements Serializable,
    SynchronizedSet<E> {
        private static final long serialVersionUID = -6836341328672221159L;
        private final SynchronizedSet<E> collection;

        UnmodifiableSetWrapper(SynchronizedSet<E> set) {
            this.collection = set;
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.collection.contains(object);
        }

        @Override
        public Iterator<E> iterator() {
            return new UnmodifiableIterator(this.collection.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.collection.toArray();
        }

        @Override
        public <T> T[] toArray(T[] output) {
            return this.collection.toArray(output);
        }

        @Override
        public boolean add(E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.collection.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object mutex() {
            return this.collection.mutex();
        }
    }

    private static class UnmodifiableSynchronizedSetWrapper<E>
    extends SynchronizedSetWrapper<E> {
        private static final long serialVersionUID = 4528746726889467656L;

        UnmodifiableSynchronizedSetWrapper(Set<E> set, Object mutex) {
            super(set, mutex);
        }

        @Override
        public boolean add(E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            return new UnmodifiableIterator(super.iterator());
        }
    }
}

