/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.scoping.batch;

import com.google.common.annotations.GwtCompatible;
import java.util.concurrent.TimeUnit;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

@GwtCompatible
public final class SARLTimeExtensions {
    private SARLTimeExtensions() {
    }

    @Pure
    @Inline(value="$1")
    public static <T extends Number> T milliseconds(T milis) {
        return milis;
    }

    @Pure
    @Inline(value="$1 * TimeExtensionsConstants.MILLIS_IN_SECOND", imported={TimeExtensionsConstants.class})
    public static long seconds(Integer secs) {
        return secs.longValue() * 1000L;
    }

    @Pure
    @Inline(value="$1 * TimeExtensionsConstants.MILLIS_IN_MINUTE", imported={TimeExtensionsConstants.class})
    public static long minutes(Integer mins) {
        return mins.longValue() * 60000L;
    }

    @Pure
    @Inline(value="$1 * TimeExtensionsConstants.MILLIS_IN_HOUR", imported={TimeExtensionsConstants.class})
    public static long hours(Integer hours) {
        return hours.longValue() * 3600000L;
    }

    @Pure
    @Inline(value="$1 * TimeExtensionsConstants.MILLIS_IN_DAY", imported={TimeExtensionsConstants.class})
    public static long days(Integer days) {
        return days.longValue() * 86400000L;
    }

    @Pure
    @Inline(value="$1 * TimeExtensionsConstants.MILLIS_IN_WEEK", imported={TimeExtensionsConstants.class})
    public static long weeks(Integer weeks) {
        return weeks.longValue() * 604800000L;
    }

    @Pure
    public static double convertFromTo(double time, TimeUnit source, TimeUnit target) {
        double millis;
        assert (source != null);
        assert (target != null);
        if (source == target) {
            return time;
        }
        switch (source) {
            case DAYS: {
                millis = time * 8.64E7;
                break;
            }
            case HOURS: {
                millis = time * 3600000.0;
                break;
            }
            case MINUTES: {
                millis = time * 60000.0;
                break;
            }
            case SECONDS: {
                millis = time * 1000.0;
                break;
            }
            case MILLISECONDS: {
                millis = time;
                break;
            }
            case NANOSECONDS: {
                millis = time * 1.0E-8;
                break;
            }
            case MICROSECONDS: {
                millis = time * 1.0E-5;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        switch (target) {
            case DAYS: {
                return millis / 8.64E7;
            }
            case HOURS: {
                return millis / 3600000.0;
            }
            case MINUTES: {
                return millis / 60000.0;
            }
            case SECONDS: {
                return millis / 1000.0;
            }
            case MILLISECONDS: {
                return millis;
            }
            case NANOSECONDS: {
                return millis / 1.0E-8;
            }
            case MICROSECONDS: {
                return millis / 1.0E-5;
            }
        }
        throw new IllegalArgumentException();
    }

    @GwtCompatible
    public final class TimeExtensionsConstants {
        public static final long MILLIS_IN_SECOND = 1000L;
        public static final long MILLIS_IN_MINUTE = 60000L;
        public static final long MILLIS_IN_HOUR = 3600000L;
        public static final long MILLIS_IN_DAY = 86400000L;
        public static final long MILLIS_IN_WEEK = 604800000L;
        public static final double MILLIS_IN_MICROSECOND = 1.0E-5;
        public static final double MILLIS_IN_NANOSECOND = 1.0E-8;

        private TimeExtensionsConstants() {
        }
    }
}

