/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.scoping.batch;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

@GwtCompatible
public final class SARLMapExtensions {
    private SARLMapExtensions() {
    }

    @Inline(value="$1.put($2.getKey(), $2.getValue())", statementExpression=true)
    public static <K, V> V operator_add(Map<K, V> map, Pair<? extends K, ? extends V> entry) {
        return map.put(entry.getKey(), entry.getValue());
    }

    @Inline(value="$1.putAll($2)", statementExpression=true)
    public static <K, V> void operator_add(Map<K, V> outputMap, Map<? extends K, ? extends V> inputMap) {
        outputMap.putAll(inputMap);
    }

    @Pure
    @Inline(value="SARLMapExtensions.union($1, Collections.singletonMap($2.getKey(), $2.getValue()))", imported={SARLMapExtensions.class, Collections.class})
    public static <K, V> Map<K, V> operator_plus(Map<K, V> left, Pair<? extends K, ? extends V> right) {
        return SARLMapExtensions.union(left, Collections.singletonMap(right.getKey(), right.getValue()));
    }

    @Pure
    @Inline(value="SARLMapExtensions.union($1, $2)", imported={SARLMapExtensions.class})
    public static <K, V> Map<K, V> operator_plus(Map<K, V> left, Map<? extends K, ? extends V> right) {
        return SARLMapExtensions.union(left, right);
    }

    @Inline(value="$1.remove($2)", statementExpression=true)
    public static <K, V> V operator_remove(Map<K, V> map, K key) {
        return map.remove(key);
    }

    public static <K, V> void operator_remove(Map<K, V> map, Iterable<? super K> keysToRemove) {
        for (K key : keysToRemove) {
            map.remove(key);
        }
    }

    @Pure
    public static <K, V> Map<K, V> operator_minus(Map<K, V> map, final K key) {
        return Maps.filterKeys(map, new Predicate<K>(){

            @Override
            public boolean apply(K input) {
                return !Objects.equal(input, key);
            }
        });
    }

    @Pure
    @Inline(value="SARLMapExtensions.operator_minus(left, right.keySet())", imported={SARLMapExtensions.class})
    public static <K, V> Map<K, V> operator_minus(Map<K, V> left, Map<? extends K, ? extends V> right) {
        return SARLMapExtensions.operator_minus(left, right.keySet());
    }

    @Pure
    public static <K, V> Map<K, V> operator_minus(Map<K, V> map, final Iterable<?> keys) {
        return Maps.filterKeys(map, new Predicate<K>(){

            @Override
            public boolean apply(K input) {
                return !Iterables.contains(keys, input);
            }
        });
    }

    @Pure
    @Inline(value="$1.get($2)")
    public static <K, V> V operator_mappedTo(Map<K, V> map, K key) {
        return map.get(key);
    }

    public static <K, V> Map<K, V> union(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        return new MergingMap<K, V>(left, right);
    }

    private static class MergingMap<K, V>
    implements Map<K, V> {
        private final Map<? extends K, ? extends V> left;
        private final Map<? extends K, ? extends V> filteredLeft;
        private final Map<? extends K, ? extends V> right;

        MergingMap(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
            this.left = left;
            this.right = right;
            this.filteredLeft = Maps.filterKeys(this.left, new Predicate<K>(){

                @Override
                public boolean apply(K input) {
                    return !right.containsKey(input);
                }
            });
        }

        @Override
        public int size() {
            return this.right.size() + this.filteredLeft.size();
        }

        @Override
        public boolean isEmpty() {
            return this.right.isEmpty() && this.left.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.right.containsKey(key) || this.left.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (this.right.containsValue(value)) {
                return true;
            }
            return this.filteredLeft.containsValue(value);
        }

        @Override
        public V get(Object key) {
            if (this.right.containsKey(key)) {
                return this.right.get(key);
            }
            return this.left.get(key);
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> keySet() {
            return Sets.union(this.right.keySet(), this.filteredLeft.keySet());
        }

        @Override
        public Collection<V> values() {
            return new MergingCollection();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<? extends K, ? extends V>> ks1 = this.right.entrySet();
            Set<Map.Entry<? extends K, ? extends V>> ks2 = this.filteredLeft.entrySet();
            return Sets.union(ks1, ks2);
        }

        private class MergingCollection
        implements Collection<V> {
            MergingCollection() {
            }

            @Override
            public int size() {
                return MergingMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return MergingMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return MergingMap.this.containsValue(object);
            }

            @Override
            public Iterator<V> iterator() {
                return Iterators.concat(MergingMap.this.right.values().iterator(), MergingMap.this.filteredLeft.values().iterator());
            }

            @Override
            public Object[] toArray() {
                Object[] tab = new Object[MergingMap.this.size()];
                Iterator iterator = this.iterator();
                int i = 0;
                while (i < tab.length) {
                    tab[i] = iterator.next();
                    ++i;
                }
                return tab;
            }

            @Override
            public <T> T[] toArray(T[] output) {
                Object[] tab = output;
                int size = MergingMap.this.size();
                if (tab == null || tab.length < size) {
                    tab = (Object[])Array.newInstance(Object.class, size);
                }
                Iterator iterator = this.iterator();
                int i = 0;
                while (i < tab.length) {
                    tab[i] = iterator.next();
                    ++i;
                }
                return tab;
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                for (Object o : collection) {
                    if (MergingMap.this.containsValue(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean add(V element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends V> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

