/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentProtectedAPIObject;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Skill;
import java.lang.ref.WeakReference;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

abstract class AgentTrait
extends AgentProtectedAPIObject {
    private WeakReference<Agent> agentRef;

    AgentTrait(Agent agent) {
        this.agentRef = new WeakReference<Agent>(agent);
    }

    AgentTrait() {
        this.agentRef = new WeakReference<Object>(null);
    }

    @Override
    @Pure
    protected String attributesToString() {
        StringBuilder result = new StringBuilder();
        result.append("owner = ");
        result.append(this.getOwner());
        return result.toString();
    }

    @Pure
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + this.attributesToString() + "]";
    }

    void setOwner(Agent agent) {
        this.agentRef = new WeakReference<Agent>(agent);
    }

    @Pure
    protected Agent getOwner() {
        return (Agent)this.agentRef.get();
    }

    @Override
    @Pure
    protected <S extends Capacity> S getSkill(Class<S> capacity) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return null;
        }
        return owner.getSkill(capacity);
    }

    @Override
    @Inline(value="$setSkill($2, $1)")
    protected <S extends Skill> void operator_mappedTo(Class<? extends Capacity> capacity, S skill) {
        this.setSkill(skill, capacity);
    }

    @Override
    @SafeVarargs
    @Inline(value="$setSkill($1, $2)")
    protected final <S extends Skill> S setSkill(S skill, Class<? extends Capacity> ... capacities) {
        return this.$setSkill(skill, capacities);
    }

    @Override
    protected <S extends Skill> S $setSkill(S skill, Class<? extends Capacity> ... capacities) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return skill;
        }
        return owner.$setSkill(skill, capacities);
    }

    @Override
    protected <S extends Capacity> S clearSkill(Class<S> capacity) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return null;
        }
        return owner.clearSkill(capacity);
    }

    @Override
    @Pure
    protected boolean hasSkill(Class<? extends Capacity> capacity) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        return owner.hasSkill(capacity);
    }

    @Override
    @Pure
    protected boolean isMe(Address address) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        return owner.isMe(address);
    }

    @Override
    @Pure
    protected boolean isMe(UUID uID) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        return owner.isMe(uID);
    }

    @Override
    @Pure
    protected boolean isFromMe(Event event) {
        Agent owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        return owner.isFromMe(event);
    }
}

