/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import com.google.common.reflect.TypeToken;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.AgentProtectedAPIObject;
import io.sarl.lang.core.BuiltinCapacitiesProvider;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Identifiable;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.UnimplementedCapacityException;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.4")
public class Agent
extends AgentProtectedAPIObject
implements Identifiable {
    private final UUID id;
    private final Map<Class<? extends Capacity>, Skill> skills = new ConcurrentHashMap<Class<? extends Capacity>, Skill>();
    private final UUID parentID;

    public Agent(BuiltinCapacitiesProvider provider, UUID parentID, UUID agentID) {
        Map<Class<? extends Capacity>, Skill> builtinCapacities;
        this.parentID = parentID;
        UUID uUID = this.id = agentID == null ? UUID.randomUUID() : agentID;
        if (provider != null && (builtinCapacities = provider.getBuiltinCapacities(this)) != null && !builtinCapacities.isEmpty()) {
            this.skills.putAll(builtinCapacities);
        }
    }

    @Override
    protected String attributesToString() {
        StringBuilder builder = new StringBuilder();
        builder.append("id = ");
        builder.append(this.id);
        builder.append(", parentID=");
        builder.append(this.parentID);
        return builder.toString();
    }

    @Pure
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + this.attributesToString() + "]";
    }

    @Pure
    public UUID getParentID() {
        return this.parentID;
    }

    @Override
    @Pure
    public UUID getID() {
        return this.id;
    }

    @Inline(value="setSkill($2, $1)")
    @Deprecated
    protected <S extends Skill> S setSkill(Class<? extends Capacity> capacity, S skill) {
        return this.setSkill(skill, capacity);
    }

    @Override
    @SafeVarargs
    @Inline(value="$setSkill($1, $2)")
    protected final <S extends Skill> S setSkill(S skill, Class<? extends Capacity> ... capacities) {
        return this.$setSkill(skill, capacities);
    }

    @Override
    protected <S extends Skill> S $setSkill(S skill, Class<? extends Capacity> ... iCapacities) {
        assert (skill != null) : "the skill parameter must not be null";
        skill.setOwner(this);
        if (iCapacities == null || iCapacities.length == 0) {
            Agent.runOnImplementedCapacities(skill, capacity -> {
                Skill oldS = this.skills.put((Class<? extends Capacity>)capacity, skill);
                skill.registerUse();
                if (oldS != null && oldS != skill) {
                    oldS.unregisterUse();
                }
            });
        } else {
            Class<? extends Capacity>[] classArray = iCapacities;
            int n = iCapacities.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Capacity> capacity2 = classArray[n2];
                assert (capacity2 != null) : "the capacity parameter must not be null";
                assert (capacity2.isInterface()) : "the capacity parameter must be an interface";
                if (!capacity2.isInstance(skill)) {
                    throw new InvalidParameterException("the skill must implement the given capacity " + capacity2.getName());
                }
                Skill oldS = this.skills.put(capacity2, skill);
                skill.registerUse();
                if (oldS != null && oldS != skill) {
                    oldS.unregisterUse();
                }
                ++n2;
            }
        }
        return skill;
    }

    private static void runOnImplementedCapacities(Skill skill, Procedures.Procedure1<Class<? extends Capacity>> callback) {
        ((Stream)TypeToken.of(skill.getClass()).getTypes().interfaces().stream().parallel()).forEach(it -> {
            Class type = it.getRawType();
            if (Capacity.class.isAssignableFrom(type) && !Capacity.class.equals(type)) {
                callback.apply(type.asSubclass(Capacity.class));
            }
        });
    }

    @Override
    @Inline(value="$setSkill($2, $1)")
    protected <S extends Skill> void operator_mappedTo(Class<? extends Capacity> capacity, S skill) {
        this.$setSkill(skill, capacity);
    }

    @Override
    protected <S extends Capacity> S clearSkill(Class<S> capacity) {
        assert (capacity != null);
        Skill skill = this.skills.remove(capacity);
        if (skill != null) {
            skill.unregisterUse();
        }
        return (S)((Capacity)capacity.cast(skill));
    }

    @Override
    @Pure
    protected <S extends Capacity> S getSkill(Class<S> capacity) {
        assert (capacity != null);
        Capacity skill = (Capacity)capacity.cast(this.skills.get(capacity));
        if (skill == null) {
            throw new UnimplementedCapacityException(capacity, this.getID());
        }
        return (S)skill;
    }

    @Override
    @Pure
    protected boolean hasSkill(Class<? extends Capacity> capacity) {
        assert (capacity != null);
        return this.skills.containsKey(capacity);
    }

    @Override
    @Pure
    protected boolean isMe(Address address) {
        return address != null && this.id.equals(address.getUUID());
    }

    @Override
    @Pure
    protected boolean isMe(UUID uID) {
        return uID != null && this.id.equals(uID);
    }

    @Override
    @Pure
    protected boolean isFromMe(Event event) {
        return event != null && this.isMe(event.getSource());
    }
}

