/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import io.janusproject.util.DataViewDelegate;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class MultisetView<K, V>
extends AbstractCollection<K>
implements Multiset<K>,
Serializable,
DataViewDelegate.Delegator<Multimap<K, V>> {
    private static final long serialVersionUID = -4540240956327121021L;
    private final Multimap<K, V> multimap;
    private transient ElementSet elementSet;
    private transient EntrySet entrySet;

    public MultisetView(Multimap<K, V> map) {
        this.multimap = map;
    }

    @Override
    public Multimap<K, V> getDelegatedObject() {
        return this.multimap;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Multiset) {
            Multiset that = (Multiset)obj;
            if (this.size() != that.size() || this.entrySet().size() != that.entrySet().size()) {
                return false;
            }
            for (Multiset.Entry entry : that.entrySet()) {
                if (this.count(entry.getElement()) == entry.getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public String toString() {
        return this.entrySet().toString();
    }

    @Override
    public int size() {
        return this.getDelegatedObject().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegatedObject().isEmpty();
    }

    @Override
    public void clear() {
        this.getDelegatedObject().clear();
    }

    @Override
    public int count(Object element) {
        try {
            Collection values = this.getDelegatedObject().get(element);
            return values.size();
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, 1) > 0;
    }

    @Override
    public int remove(Object element, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException();
        }
        if (occurrences > 0) {
            Collection values;
            block6: {
                Object key = element;
                values = this.getDelegatedObject().get(key);
                if (!values.isEmpty()) break block6;
                return 0;
            }
            try {
                int oldCount = values.size();
                int numberRemoved = oldCount > occurrences ? occurrences : oldCount;
                Iterator valueIterator = values.iterator();
                int i = 0;
                while (i < numberRemoved && valueIterator.hasNext()) {
                    valueIterator.next();
                    valueIterator.remove();
                    ++i;
                }
                return oldCount;
            }
            catch (ClassCastException classCastException) {}
        }
        return this.count(element);
    }

    @Override
    public int setCount(K element, int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        int currentCount = this.count(element);
        return this.setCountImpl(element, currentCount, count);
    }

    @Override
    public boolean setCount(K element, int oldCount, int newCount) {
        if (oldCount < 0 || newCount < 0) {
            throw new IllegalArgumentException();
        }
        int count = this.count(element);
        if (count == oldCount) {
            this.setCountImpl(element, count, newCount);
            return true;
        }
        return false;
    }

    private int setCountImpl(K element, int oldCount, int newCount) {
        int delta = newCount - oldCount;
        if (delta > 0) {
            this.add(element, delta);
        } else if (delta < 0) {
            this.remove(element, -delta);
        }
        return oldCount;
    }

    @Override
    public boolean addAll(Collection<? extends K> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (collection instanceof Multiset) {
            Multiset that = (Multiset)collection;
            for (Multiset.Entry entry : that.entrySet()) {
                this.add((K)entry.getElement(), entry.getCount());
            }
        } else {
            Iterators.addAll(this, collection.iterator());
        }
        return true;
    }

    @Override
    public Set<K> elementSet() {
        if (this.elementSet == null) {
            this.elementSet = new ElementSet();
        }
        return this.elementSet;
    }

    @Override
    public Set<Multiset.Entry<K>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Iterator<K> iterator() {
        return new MultisetIterator(this.entrySet().iterator());
    }

    @Override
    public boolean contains(Object element) {
        return this.count(element) > 0;
    }

    @Override
    public int add(K element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(K element) {
        throw new UnsupportedOperationException();
    }

    private class ElementSet
    extends AbstractSet<K> {
        ElementSet() {
        }

        protected Multiset<K> multiset() {
            return MultisetView.this;
        }

        @Override
        public void clear() {
            this.multiset().clear();
        }

        @Override
        public boolean contains(Object obj) {
            return this.multiset().contains(obj);
        }

        @Override
        public boolean containsAll(Collection<?> col) {
            return this.multiset().containsAll(col);
        }

        @Override
        public boolean isEmpty() {
            return this.multiset().isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return new TransformedIterator(MultisetView.this, this.multiset().entrySet().iterator()){

                @Override
                protected K transform(Multiset.Entry<K> entry) {
                    return entry.getElement();
                }
            };
        }

        @Override
        public boolean remove(Object obj) {
            int count = this.multiset().count(obj);
            if (count > 0) {
                this.multiset().remove(obj, count);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return this.multiset().entrySet().size();
        }
    }

    private class EntrySet
    extends AbstractSet<Multiset.Entry<K>> {
        EntrySet() {
        }

        protected Multiset<K> multiset() {
            return MultisetView.this;
        }

        @Override
        public boolean contains(Object obj) {
            if (obj instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)obj;
                if (entry.getCount() <= 0) {
                    return false;
                }
                int count = this.multiset().count(entry.getElement());
                return count == entry.getCount();
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                Object element = entry.getElement();
                int entryCount = entry.getCount();
                if (entryCount != 0) {
                    Multiset multiset = this.multiset();
                    return multiset.setCount(element, entryCount, 0);
                }
            }
            return false;
        }

        @Override
        public void clear() {
            this.multiset().clear();
        }

        @Override
        public Iterator<Multiset.Entry<K>> iterator() {
            final Iterator backingEntries = MultisetView.this.getDelegatedObject().keySet().iterator();
            return new Iterator<Multiset.Entry<K>>(){
                private boolean canRemove;

                @Override
                public boolean hasNext() {
                    return backingEntries.hasNext();
                }

                @Override
                public Multiset.Entry<K> next() {
                    final Object entryKey = backingEntries.next();
                    final Collection entryValues = MultisetView.this.getDelegatedObject().get(entryKey);
                    this.canRemove = true;
                    return new Multiset.Entry<K>(){

                        @Override
                        public boolean equals(Object object) {
                            if (object instanceof Multiset.Entry) {
                                Multiset.Entry that = (Multiset.Entry)object;
                                return this.getCount() == that.getCount() && Objects.equal(this.getElement(), that.getElement());
                            }
                            return false;
                        }

                        @Override
                        public int hashCode() {
                            Object element = this.getElement();
                            return (element == null ? 0 : element.hashCode()) ^ this.getCount();
                        }

                        @Override
                        public String toString() {
                            StringBuilder b = new StringBuilder();
                            b.append(String.valueOf(this.getElement()));
                            int elementCount = this.getCount();
                            if (elementCount != 1) {
                                b.append(" x ");
                                b.append(elementCount);
                            }
                            return b.toString();
                        }

                        @Override
                        public K getElement() {
                            return entryKey;
                        }

                        @Override
                        public int getCount() {
                            Collection values = entryValues;
                            if (values == null || values.size() == 0) {
                                values = MultisetView.this.getDelegatedObject().get(this.getElement());
                            }
                            return values == null ? 0 : values.size();
                        }
                    };
                }

                @Override
                public void remove() {
                    if (!this.canRemove) {
                        throw new IllegalStateException();
                    }
                    backingEntries.remove();
                    this.canRemove = false;
                }
            };
        }

        @Override
        public int size() {
            return MultisetView.this.getDelegatedObject().keySet().size();
        }
    }

    private class MultisetIterator
    implements Iterator<K> {
        private final Iterator<Multiset.Entry<K>> entryIterator;
        private Multiset.Entry<K> currentEntry;
        private int laterCount;
        private int totalCount;
        private boolean canRemove;

        MultisetIterator(Iterator<Multiset.Entry<K>> entryIterator) {
            this.entryIterator = entryIterator;
        }

        @Override
        public boolean hasNext() {
            return this.laterCount > 0 || this.entryIterator.hasNext();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.laterCount == 0) {
                this.currentEntry = this.entryIterator.next();
                this.totalCount = this.laterCount = this.currentEntry.getCount();
            }
            --this.laterCount;
            this.canRemove = true;
            return this.currentEntry.getElement();
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (this.totalCount == 1) {
                this.entryIterator.remove();
            } else {
                MultisetView.this.remove(this.currentEntry.getElement());
            }
            --this.totalCount;
            this.canRemove = false;
        }
    }

    private abstract class TransformedIterator
    implements Iterator<K> {
        final Iterator<? extends Multiset.Entry<K>> backingIterator;

        TransformedIterator(Iterator<? extends Multiset.Entry<K>> backingIterator) {
            assert (backingIterator != null);
            this.backingIterator = backingIterator;
        }

        protected abstract K transform(Multiset.Entry<K> var1);

        @Override
        public final boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public final K next() {
            return this.transform(this.backingIterator.next());
        }

        @Override
        public final void remove() {
            this.backingIterator.remove();
        }
    }
}

