/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.services.spawn;

import io.janusproject.services.DependentService;
import io.janusproject.services.spawn.KernelAgentSpawnListener;
import io.janusproject.services.spawn.Messages;
import io.janusproject.services.spawn.SpawnServiceListener;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import java.text.MessageFormat;
import java.util.UUID;

public interface SpawnService
extends DependentService {
    public UUID spawn(AgentContext var1, UUID var2, Class<? extends Agent> var3, Object ... var4);

    public void killAgent(UUID var1) throws AgentKillException;

    public void addSpawnServiceListener(UUID var1, SpawnServiceListener var2);

    public void addSpawnServiceListener(SpawnServiceListener var1);

    public void removeSpawnServiceListener(UUID var1, SpawnServiceListener var2);

    public void removeSpawnServiceListener(SpawnServiceListener var1);

    public void addKernelAgentSpawnListener(KernelAgentSpawnListener var1);

    public void removeKernelAgentSpawnListener(KernelAgentSpawnListener var1);

    public static class AgentKillException
    extends Exception {
        private static final long serialVersionUID = -7911946040378324212L;
        private final UUID agent;

        public AgentKillException(UUID agent) {
            super(MessageFormat.format(Messages.SpawnService_0, agent));
            this.agent = agent;
            this.fillInStackTrace();
        }

        public AgentKillException(UUID agent, Throwable cause) {
            super(MessageFormat.format(Messages.SpawnService_1, agent, cause), cause);
            this.agent = agent;
        }

        public UUID getAgent() {
            return this.agent;
        }
    }
}

