/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules.eventserial;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import io.janusproject.JanusConfig;
import io.janusproject.kernel.services.gson.GsonEventSerializer;
import io.janusproject.kernel.services.jdk.network.AESEventEncrypter;
import io.janusproject.kernel.services.jdk.network.PlainTextEventEncrypter;
import io.janusproject.services.network.EventEncrypter;
import io.janusproject.services.network.EventSerializer;
import java.lang.reflect.Type;
import java.util.Properties;

public class NetworkEventModule
extends AbstractModule {
    public static void getDefaultValues(Properties defaultValues) {
        defaultValues.put("network.serializer.class", GsonEventSerializer.class.getName());
        defaultValues.put("network.encrypter.class", PlainTextEventEncrypter.class.getName());
    }

    @Override
    protected void configure() {
    }

    @Provides
    private static Gson createGson() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)Class.class), new GsonEventSerializer.ClassTypeAdapter()).setPrettyPrinting().create();
    }

    @Provides
    private static EventSerializer createEventSerializer(Injector injector) {
        Class serializerType = GsonEventSerializer.class;
        String serializerClassname = JanusConfig.getSystemProperty("network.serializer.class");
        if (serializerClassname != null && !serializerClassname.isEmpty()) {
            Class<?> type;
            try {
                type = Class.forName(serializerClassname);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (type != null && EventSerializer.class.isAssignableFrom(type)) {
                serializerType = type.asSubclass(EventSerializer.class);
            }
            assert (injector != null);
            return injector.getInstance(serializerType);
        }
        return injector.getInstance(serializerType);
    }

    @Provides
    private static EventEncrypter getEncrypter(Injector injector) {
        Class encrypterType = null;
        String encrypterClassname = JanusConfig.getSystemProperty("network.encrypter.class");
        if (encrypterClassname != null && !encrypterClassname.isEmpty()) {
            try {
                Class<?> type = Class.forName(encrypterClassname);
                if (type != null && EventEncrypter.class.isAssignableFrom(type)) {
                    encrypterType = type.asSubclass(EventEncrypter.class);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (encrypterType == null) {
            String aesKey = JanusConfig.getSystemProperty("network.encrypter.aes.key");
            encrypterType = aesKey != null && !aesKey.isEmpty() ? AESEventEncrypter.class : PlainTextEventEncrypter.class;
        }
        assert (injector != null);
        return (EventEncrypter)injector.getInstance(encrypterType);
    }
}

