/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules;

import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.janusproject.kernel.services.jdk.contextspace.StandardContextSpaceService;
import io.janusproject.kernel.services.jdk.logging.StandardLogService;
import io.janusproject.kernel.services.jdk.spawn.StandardSpawnService;
import io.janusproject.modules.executors.JdkExecutorModule;
import io.janusproject.modules.kernel.MandatoryKernelModule;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryService;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.network.NetworkService;
import io.janusproject.services.spawn.SpawnService;

public class StandardCoreModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(LogService.class).to(StandardLogService.class).in(Singleton.class);
        this.bind(ContextSpaceService.class).to(StandardContextSpaceService.class).in(Singleton.class);
        this.bind(SpawnService.class).to(StandardSpawnService.class).in(Singleton.class);
        this.install(new JdkExecutorModule());
        this.install(new MandatoryKernelModule());
        this.requireBinding(DistributedDataStructureService.class);
        this.requireBinding(KernelDiscoveryService.class);
        this.requireBinding(ExecutorService.class);
        this.requireBinding(ContextSpaceService.class);
        this.requireBinding(LogService.class);
        this.requireBinding(NetworkService.class);
        this.requireBinding(SpawnService.class);
        Multibinder<Service> serviceSetBinder = Multibinder.newSetBinder(this.binder(), Service.class);
        serviceSetBinder.addBinding().to(LogService.class);
        serviceSetBinder.addBinding().to(ExecutorService.class);
        serviceSetBinder.addBinding().to(ContextSpaceService.class);
        serviceSetBinder.addBinding().to(KernelDiscoveryService.class);
        serviceSetBinder.addBinding().to(SpawnService.class);
        serviceSetBinder.addBinding().to(DistributedDataStructureService.class);
    }
}

