/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.executors;

import com.google.inject.Inject;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class JdkThreadFactory
implements ThreadFactory {
    private final ThreadFactory defaultThreadFactory;
    private final Thread.UncaughtExceptionHandler handler;

    @Inject
    public JdkThreadFactory(Thread.UncaughtExceptionHandler handler) {
        this.handler = handler;
        this.defaultThreadFactory = Executors.defaultThreadFactory();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = this.defaultThreadFactory.newThread(runnable);
        t.setDaemon(false);
        assert (this.handler != null);
        t.setUncaughtExceptionHandler(this.handler);
        return t;
    }
}

