/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.executors;

import io.janusproject.services.executor.ChuckNorrisException;
import java.util.concurrent.ExecutionException;

final class JdkExecutorUtil {
    private JdkExecutorUtil() {
    }

    public static boolean log(Thread thread, Throwable exception) {
        if (exception != null) {
            Throwable realException = exception;
            while (realException instanceof ExecutionException) {
                realException = ((ExecutionException)realException).getCause();
            }
            if (!(realException instanceof ChuckNorrisException)) {
                Thread.UncaughtExceptionHandler handler = thread.getUncaughtExceptionHandler();
                if (handler == null) {
                    handler = Thread.getDefaultUncaughtExceptionHandler();
                }
                if (handler != null) {
                    handler.uncaughtException(thread, realException);
                } else {
                    System.err.println(realException.toString());
                    realException.printStackTrace();
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

