/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic.internaleventdispatching;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.janusproject.kernel.bic.internaleventdispatching.BehaviorGuardEvaluator;
import io.janusproject.kernel.bic.internaleventdispatching.Messages;
import io.sarl.lang.core.Event;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class BehaviorGuardEvaluatorRegistry {
    private static final LoadingCache<Class<?>, ImmutableSet<Class<?>>> FLATTEN_HIERARCHY_CACHE = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableSet<Class<?>>>(){

        @Override
        public ImmutableSet<Class<?>> load(Class<?> concreteClass) {
            return ImmutableSet.copyOf(TypeToken.of(concreteClass).getTypes().rawTypes());
        }
    });
    private final LoadingCache<Class<?>, ImmutableList<Method>> perceptGuardEvaluatorMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableList<Method>>(){

        @Override
        public ImmutableList<Method> load(Class<?> concreteClass) throws Exception {
            return BehaviorGuardEvaluatorRegistry.this.getAnnotatedMethodsNotCached(concreteClass);
        }
    });
    private final Class<? extends Annotation> perceptGuardEvaluatorAnnotation;
    private final ConcurrentMap<Class<? extends Event>, CopyOnWriteArraySet<BehaviorGuardEvaluator>> behaviorGuardEvaluators = Maps.newConcurrentMap();

    BehaviorGuardEvaluatorRegistry(Class<? extends Annotation> annotation) {
        this.perceptGuardEvaluatorAnnotation = annotation;
    }

    void register(Object listener) {
        Multimap<Class<? extends Event>, BehaviorGuardEvaluator> listenerMethods = this.findAllBehaviorGuardEvaluators(listener);
        for (Map.Entry<Class<? extends Event>, Collection<BehaviorGuardEvaluator>> entry : listenerMethods.asMap().entrySet()) {
            Class<? extends Event> eventType = entry.getKey();
            Collection<BehaviorGuardEvaluator> eventMethodsInListener = entry.getValue();
            CopyOnWriteArraySet<BehaviorGuardEvaluator> eventSubscribers = (CopyOnWriteArraySet<BehaviorGuardEvaluator>)this.behaviorGuardEvaluators.get(eventType);
            if (eventSubscribers == null) {
                CopyOnWriteArraySet newSet = new CopyOnWriteArraySet();
                eventSubscribers = MoreObjects.firstNonNull(this.behaviorGuardEvaluators.putIfAbsent(eventType, newSet), newSet);
            }
            eventSubscribers.addAll(eventMethodsInListener);
        }
    }

    void unregister(Object listener) {
        Multimap<Class<? extends Event>, BehaviorGuardEvaluator> listenerMethods = this.findAllBehaviorGuardEvaluators(listener);
        for (Map.Entry<Class<? extends Event>, Collection<BehaviorGuardEvaluator>> entry : listenerMethods.asMap().entrySet()) {
            Class<? extends Event> eventType = entry.getKey();
            Collection<BehaviorGuardEvaluator> listenerMethodsForType = entry.getValue();
            CopyOnWriteArraySet currentSubscribers = (CopyOnWriteArraySet)this.behaviorGuardEvaluators.get(eventType);
            if (currentSubscribers == null || currentSubscribers.isEmpty()) continue;
            currentSubscribers.removeAll(listenerMethodsForType);
        }
    }

    Collection<BehaviorGuardEvaluator> getBehaviorGuardEvaluators(Event event) {
        ImmutableSet<Class<?>> eventTypes = BehaviorGuardEvaluatorRegistry.flattenHierarchy(event.getClass());
        ArrayList<BehaviorGuardEvaluator> iBehaviorGuardEvaluators = Lists.newArrayListWithCapacity(eventTypes.size());
        for (Class clazz : eventTypes) {
            CopyOnWriteArraySet eventSubscribers = (CopyOnWriteArraySet)this.behaviorGuardEvaluators.get(clazz);
            if (eventSubscribers == null) continue;
            iBehaviorGuardEvaluators.addAll(eventSubscribers);
        }
        return iBehaviorGuardEvaluators;
    }

    private Multimap<Class<? extends Event>, BehaviorGuardEvaluator> findAllBehaviorGuardEvaluators(Object listener) {
        HashMultimap<Class<? extends Event>, BehaviorGuardEvaluator> methodsInListener = HashMultimap.create();
        Class<?> clazz = listener.getClass();
        for (Method method : this.getAnnotatedMethods(clazz)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> eventType = parameterTypes[0];
            methodsInListener.put(eventType, BehaviorGuardEvaluator.create(listener, method));
        }
        return methodsInListener;
    }

    private ImmutableList<Method> getAnnotatedMethods(Class<?> clazz) {
        return this.perceptGuardEvaluatorMethodsCache.getUnchecked(clazz);
    }

    private ImmutableList<Method> getAnnotatedMethodsNotCached(Class<?> clazz) {
        Set supertypes = TypeToken.of(clazz).getTypes().rawTypes();
        HashMap<MethodIdentifier, Method> identifiers = Maps.newHashMap();
        for (Class supertype : supertypes) {
            Method[] methodArray = supertype.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(this.perceptGuardEvaluatorAnnotation) && !method.isSynthetic()) {
                    Object[] parameterTypes = method.getParameterTypes();
                    try {
                        if (parameterTypes.length != 2 || parameterTypes[0] == null || parameterTypes[1] == null) {
                            throw new IllegalArgumentException(MessageFormat.format(Messages.BehaviorGuardEvaluatorRegistry_1, method, this.perceptGuardEvaluatorAnnotation.toString(), parameterTypes.length, Arrays.toString(parameterTypes)));
                        }
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    MethodIdentifier ident = new MethodIdentifier(method, (Class<?>[])parameterTypes);
                    identifiers.put(ident, method);
                }
                ++n2;
            }
        }
        return ImmutableList.copyOf(identifiers.values());
    }

    private static ImmutableSet<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        try {
            return FLATTEN_HIERARCHY_CACHE.getUnchecked(concreteClass);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    private static final class MethodIdentifier {
        private final String name;
        private final List<Class<?>> parameterTypes;

        MethodIdentifier(Method method, Class<?>[] parameterTypes) {
            this.name = method.getDeclaringClass() + method.getName();
            this.parameterTypes = Arrays.asList(parameterTypes);
        }

        public int hashCode() {
            return Objects.hashCode(this.name, this.parameterTypes);
        }

        public boolean equals(Object object) {
            if (object instanceof MethodIdentifier) {
                MethodIdentifier ident = (MethodIdentifier)object;
                return this.name.equals(ident.name) && this.parameterTypes.equals(ident.parameterTypes);
            }
            return false;
        }
    }
}

