/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.janusproject.kernel.Kernel;
import io.janusproject.kernel.bic.AgentLifeCycleSupport;
import io.janusproject.kernel.bic.BehaviorsSkill;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.DefaultContextInteractionsSkill;
import io.janusproject.kernel.bic.ExternalContextAccessSkill;
import io.janusproject.kernel.bic.InnerContextSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.kernel.bic.InternalEventBusSkill;
import io.janusproject.kernel.bic.LifecycleSkill;
import io.janusproject.kernel.bic.LoggingSkill;
import io.janusproject.kernel.bic.MicroKernelCapacity;
import io.janusproject.kernel.bic.MicroKernelSkill;
import io.janusproject.kernel.bic.SchedulesSkill;
import io.janusproject.kernel.bic.TimeSkill;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.janusproject.services.spawn.SpawnService;
import io.sarl.core.Behaviors;
import io.sarl.core.DefaultContextInteractions;
import io.sarl.core.ExternalContextAccess;
import io.sarl.core.InnerContextAccess;
import io.sarl.core.Lifecycle;
import io.sarl.core.Logging;
import io.sarl.core.Schedules;
import io.sarl.core.Time;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.BuiltinCapacitiesProvider;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.SpaceID;
import io.sarl.util.OpenEventSpaceSpecification;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class StandardBuiltinCapacitiesProvider
implements BuiltinCapacitiesProvider {
    static final Class<? extends BuiltinSkill>[] SKILL_INSTALLATION_ORDER = new Class[]{InternalEventBusSkill.class, MicroKernelSkill.class, InnerContextSkill.class, BehaviorsSkill.class, LifecycleSkill.class, ExternalContextAccessSkill.class, DefaultContextInteractionsSkill.class, SchedulesSkill.class, LoggingSkill.class, TimeSkill.class};
    @Inject
    private Injector injector;
    @Inject
    private SpawnService spawnService;
    @Inject
    private ContextSpaceService contextRepository;

    @Override
    public Map<Class<? extends Capacity>, Skill> getBuiltinCapacities(Agent agent) {
        UUID innerContextID = agent.getID();
        SpaceID innerSpaceID = new SpaceID(innerContextID, UUID.randomUUID(), OpenEventSpaceSpecification.class);
        Address agentAddressInInnerSpace = new Address(innerSpaceID, agent.getID());
        Kernel k = this.injector.getInstance(Kernel.class);
        InternalEventBusSkill eventBusSkill = new InternalEventBusSkill(agent, agentAddressInInnerSpace);
        InnerContextSkill innerContextSkill = new InnerContextSkill(agent, agentAddressInInnerSpace);
        BehaviorsSkill behaviorSkill = new BehaviorsSkill(agent, agentAddressInInnerSpace);
        LifecycleSkill lifecycleSkill = new LifecycleSkill(agent);
        ExternalContextAccessSkill externalContextSkill = new ExternalContextAccessSkill(agent);
        DefaultContextInteractionsSkill interactionSkill = new DefaultContextInteractionsSkill(agent, this.contextRepository.getContext(agent.getParentID()));
        SchedulesSkill scheduleSkill = new SchedulesSkill(agent);
        LoggingSkill loggingSkill = new LoggingSkill(agent);
        TimeSkill timeSkill = new TimeSkill(agent);
        this.injector.injectMembers(eventBusSkill);
        this.injector.injectMembers(innerContextSkill);
        this.injector.injectMembers(behaviorSkill);
        this.injector.injectMembers(lifecycleSkill);
        this.injector.injectMembers(externalContextSkill);
        this.injector.injectMembers(interactionSkill);
        this.injector.injectMembers(scheduleSkill);
        this.injector.injectMembers(loggingSkill);
        this.injector.injectMembers(timeSkill);
        MicroKernelSkill microKernelSkill = new MicroKernelSkill(agent, k);
        HashMap<Class<? extends Capacity>, Skill> result = new HashMap<Class<? extends Capacity>, Skill>();
        result.put(MicroKernelCapacity.class, microKernelSkill);
        result.put(InternalEventBusCapacity.class, eventBusSkill);
        result.put(InnerContextAccess.class, innerContextSkill);
        result.put(Behaviors.class, behaviorSkill);
        result.put(Lifecycle.class, lifecycleSkill);
        result.put(ExternalContextAccess.class, externalContextSkill);
        result.put(DefaultContextInteractions.class, interactionSkill);
        result.put(Schedules.class, scheduleSkill);
        result.put(Logging.class, loggingSkill);
        result.put(Time.class, timeSkill);
        this.spawnService.addSpawnServiceListener(agent.getID(), new AgentLifeCycleSupport(agent.getID(), this.spawnService, eventBusSkill));
        assert (result.get(Behaviors.class) != null);
        assert (result.get(DefaultContextInteractions.class) != null);
        assert (result.get(InternalEventBusCapacity.class) != null);
        assert (result.get(ExternalContextAccess.class) != null);
        assert (result.get(InnerContextAccess.class) != null);
        assert (result.get(Lifecycle.class) != null);
        assert (result.get(Schedules.class) != null);
        assert (result.get(MicroKernelCapacity.class) != null);
        assert (result.get(Logging.class) != null);
        assert (result.get(Time.class) != null);
        return result;
    }
}

