/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.base.MoreObjects;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.Messages;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.executor.JanusScheduledFutureTask;
import io.janusproject.services.logging.LogService;
import io.sarl.core.AgentTask;
import io.sarl.core.Schedules;
import io.sarl.lang.core.Agent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SchedulesSkill
extends BuiltinSkill
implements Schedules {
    private static int installationOrder = -1;
    @Inject
    private ExecutorService executorService;
    @Inject
    private LogService logger;
    private final Map<String, AgentTask> tasks = new HashMap<String, AgentTask>();
    private final Map<String, ScheduledFuture<?>> futures = new HashMap();

    SchedulesSkill(Agent agent) {
        super(agent);
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = SchedulesSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    protected String attributesToString() {
        return String.valueOf(super.attributesToString()) + ", tasks = " + this.tasks;
    }

    private synchronized void finishTask(String name) {
        this.tasks.remove(name);
        this.futures.remove(name);
    }

    synchronized Collection<String> getActiveTasks() {
        return new ArrayList<String>(this.tasks.keySet());
    }

    synchronized Collection<ScheduledFuture<?>> getActiveFutures() {
        return new ArrayList(this.futures.values());
    }

    @Override
    protected synchronized void uninstall() {
        for (Map.Entry<String, ScheduledFuture<?>> futureDescription : this.futures.entrySet()) {
            ScheduledFuture<?> future = futureDescription.getValue();
            if (future instanceof JanusScheduledFutureTask && ((JanusScheduledFutureTask)future).isCurrentThread()) {
                this.logger.fineInfo(Messages.SchedulesSkill_0, futureDescription.getKey(), future);
                continue;
            }
            future.cancel(true);
            this.logger.fineInfo(Messages.SchedulesSkill_1, futureDescription.getKey(), future);
        }
        this.futures.clear();
        this.tasks.clear();
    }

    @Override
    public AgentTask in(long delay, Procedures.Procedure1<? super Agent> procedure) {
        return this.in(Schedules.$DEFAULT_VALUE$IN_0, delay, procedure);
    }

    @Override
    public synchronized AgentTask in(AgentTask task, long delay, Procedures.Procedure1<? super Agent> procedure) {
        AgentTask rtask = task == null ? this.task("task-" + UUID.randomUUID()) : task;
        rtask.setProcedure(procedure);
        ScheduledFuture<?> sf = this.executorService.schedule(new AgentRunnableTask(rtask, false), delay, TimeUnit.MILLISECONDS);
        this.futures.put(rtask.getName(), sf);
        return rtask;
    }

    @Override
    public synchronized AgentTask task(String name) {
        if (this.tasks.containsKey(name)) {
            return this.tasks.get(name);
        }
        AgentTask t = new AgentTask();
        t.setName(name);
        t.setGuard(new Functions.Function1<Agent, Boolean>(){

            @Override
            public Boolean apply(Agent arg0) {
                return Boolean.TRUE;
            }
        });
        this.tasks.put(name, t);
        return t;
    }

    @Override
    public final boolean cancel(AgentTask task) {
        return this.cancel(task, true);
    }

    @Override
    public synchronized boolean cancel(AgentTask task, boolean mayInterruptIfRunning) {
        String name;
        ScheduledFuture<?> future;
        if (task != null && (future = this.futures.get(name = task.getName())) != null && !future.isDone() && !future.isCancelled() && future.cancel(mayInterruptIfRunning)) {
            this.finishTask(name);
        }
        return false;
    }

    @Override
    public AgentTask every(long period, Procedures.Procedure1<? super Agent> procedure) {
        return this.every(Schedules.$DEFAULT_VALUE$EVERY_0, period, procedure);
    }

    @Override
    public synchronized AgentTask every(AgentTask task, long period, Procedures.Procedure1<? super Agent> procedure) {
        AgentTask rtask = task == null ? this.task("task-" + UUID.randomUUID()) : task;
        rtask.setProcedure(procedure);
        ScheduledFuture<?> sf = this.executorService.scheduleAtFixedRate(new AgentRunnableTask(rtask, true), 0L, period, TimeUnit.MILLISECONDS);
        this.futures.put(rtask.getName(), sf);
        return rtask;
    }

    private class AgentRunnableTask
    implements Runnable {
        private WeakReference<AgentTask> agentTaskRef;
        private final boolean isPeriodic;

        AgentRunnableTask(AgentTask task, boolean isPeriodic) {
            this.agentTaskRef = new WeakReference<AgentTask>(task);
            this.isPeriodic = isPeriodic;
        }

        @Override
        public void run() {
            AgentTask task = (AgentTask)this.agentTaskRef.get();
            if (task == null) {
                throw new RuntimeException(Messages.SchedulesSkill_2);
            }
            try {
                Agent owner = SchedulesSkill.this.getOwner();
                if (task.getGuard().apply(owner).booleanValue()) {
                    task.getProcedure().apply(owner);
                }
            }
            finally {
                if (!this.isPeriodic) {
                    SchedulesSkill.this.finishTask(task.getName());
                }
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", ((AgentTask)this.agentTaskRef.get()).getName()).add("agent", SchedulesSkill.this.getOwner().getID()).toString();
        }
    }
}

