/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import io.janusproject.kernel.bic.BuiltinSkill;
import io.sarl.core.DefaultContextInteractions;
import io.sarl.core.Lifecycle;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.util.Scopes;
import java.util.UUID;

public class DefaultContextInteractionsSkill
extends BuiltinSkill
implements DefaultContextInteractions {
    private static int installationOrder = -1;
    private AgentContext parentContext;
    private EventSpace defaultSpace;
    private Address addressInParentDefaultSpace;

    DefaultContextInteractionsSkill(Agent agent, AgentContext parentContext) {
        super(agent);
        this.parentContext = parentContext;
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = DefaultContextInteractionsSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    protected String attributesToString() {
        return String.valueOf(super.attributesToString()) + ", parentContext = " + this.parentContext + ", defaultSpace = " + this.defaultSpace + ", addressInDefaultspace = " + this.addressInParentDefaultSpace;
    }

    @Override
    protected void install() {
        this.defaultSpace = this.parentContext.getDefaultSpace();
    }

    @Override
    public void emit(Event event) {
        event.setSource(this.getDefaultAddress());
        this.defaultSpace.emit(event);
    }

    @Override
    public void emit(Event event, Scope<Address> scope) {
        event.setSource(this.getDefaultAddress());
        this.defaultSpace.emit(event, scope);
    }

    @Override
    public Address getDefaultAddress() {
        Address adr = this.addressInParentDefaultSpace;
        if (adr == null) {
            adr = this.defaultSpace.getAddress(this.getOwner().getID());
            assert (adr != null) : "The agent has no address in the default space";
            this.addressInParentDefaultSpace = adr;
        }
        return adr;
    }

    @Override
    public AgentContext getDefaultContext() {
        return this.parentContext;
    }

    @Override
    public EventSpace getDefaultSpace() {
        return this.defaultSpace;
    }

    @Override
    @Deprecated
    public void receive(UUID receiverID, Event event) {
        this.willReceive(receiverID, event);
    }

    @Override
    public void willReceive(UUID receiverID, Event event) {
        Address recAddr = this.defaultSpace.getAddress(receiverID);
        this.emit(event, Scopes.addresses(recAddr));
    }

    @Override
    public UUID spawn(Class<? extends Agent> agentType, Object ... params) {
        return this.getSkill(Lifecycle.class).spawnInContext(agentType, this.parentContext, params);
    }

    @Override
    public boolean isDefaultSpace(Space space) {
        return this.isDefaultSpace(space.getSpaceID());
    }

    @Override
    public boolean isDefaultSpace(SpaceID space) {
        return this.isDefaultSpace(space.getID());
    }

    @Override
    public boolean isDefaultSpace(UUID space) {
        return space.equals(this.defaultSpace.getSpaceID().getID());
    }

    @Override
    public boolean isInDefaultSpace(Event event) {
        Address adr;
        if (event != null && (adr = event.getSource()) != null) {
            return this.isDefaultSpace(adr.getSpaceId());
        }
        return false;
    }

    @Override
    public boolean isDefaultContext(AgentContext context) {
        return this.isDefaultContext(context.getID());
    }

    @Override
    public boolean isDefaultContext(UUID contextID) {
        return contextID.equals(this.defaultSpace.getSpaceID().getContextID());
    }
}

