/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import io.janusproject.kernel.bic.InnerContextSkill;
import io.sarl.core.ExternalContextAccess;
import io.sarl.core.InnerContextAccess;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.util.SynchronizedCollection;
import java.lang.reflect.Method;

public final class BuiltinCapacityUtil {
    private BuiltinCapacityUtil() {
    }

    public static SynchronizedCollection<AgentContext> getContextsOf(Agent agent) throws Exception {
        ExternalContextAccess skill;
        Method method = Agent.class.getDeclaredMethod("getSkill", Class.class);
        boolean isAccessible = method.isAccessible();
        try {
            method.setAccessible(true);
            skill = (ExternalContextAccess)method.invoke((Object)agent, ExternalContextAccess.class);
        }
        finally {
            method.setAccessible(isAccessible);
        }
        return skill.getAllContexts();
    }

    public static AgentContext getContextIn(Agent agent) throws Exception {
        InnerContextAccess skill;
        Method method = Agent.class.getDeclaredMethod("getSkill", Class.class);
        boolean isAccessible = method.isAccessible();
        try {
            method.setAccessible(true);
            skill = (InnerContextAccess)method.invoke((Object)agent, InnerContextAccess.class);
        }
        finally {
            method.setAccessible(isAccessible);
        }
        if (skill instanceof InnerContextSkill) {
            InnerContextSkill janusSkill = (InnerContextSkill)skill;
            if (janusSkill.hasInnerContext()) {
                return janusSkill.getInnerContext();
            }
            return null;
        }
        return skill.getInnerContext();
    }
}

