/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel;

import com.google.common.util.concurrent.Service;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import io.janusproject.kernel.Messages;
import io.janusproject.services.IServiceManager;
import io.janusproject.services.Services;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.spawn.KernelAgentSpawnListener;
import io.janusproject.services.spawn.SpawnService;
import io.janusproject.util.LoggerCreator;
import io.janusproject.util.TwoStepConstruction;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@Singleton
@TwoStepConstruction(names={"setJanusContext"})
public class Kernel {
    private AgentContext janusContext;
    private final IServiceManager serviceManager;
    private final SpawnService spawnService;
    private final LogService loggingService;
    private Logger rawLogger;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);

    @Inject
    Kernel(IServiceManager serviceManager, SpawnService spawnService, LogService loggingService, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.serviceManager = serviceManager;
        this.spawnService = spawnService;
        this.loggingService = loggingService;
        Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
        this.spawnService.addKernelAgentSpawnListener(new KernelStoppingListener());
        Services.startServices(this.serviceManager);
    }

    public static final Kernel create(Module ... modules) {
        Injector injector = Guice.createInjector(modules);
        Kernel k = injector.getInstance(Kernel.class);
        return k;
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public UUID spawn(Class<? extends Agent> agent, Object ... params) {
        return this.spawnService.spawn(this.janusContext, null, agent, params);
    }

    public UUID spawn(UUID agentID, Class<? extends Agent> agent, Object ... params) {
        return this.spawnService.spawn(this.janusContext, agentID, agent, params);
    }

    public <S extends Service> S getService(Class<S> type) {
        for (Service serv : this.serviceManager.servicesByState().values()) {
            if (!serv.isRunning() || !type.isInstance(serv)) continue;
            return (S)((Service)type.cast(serv));
        }
        return null;
    }

    public Logger getLogger() {
        Logger log = this.loggingService.getLogger();
        if (log == null) {
            if (this.rawLogger == null) {
                this.rawLogger = LoggerCreator.createLogger("Janus SRE");
            }
            log = this.rawLogger;
        }
        return log;
    }

    @Inject
    void setJanusContext(@io.janusproject.kernel.annotations.Kernel AgentContext janusContext) {
        assert (janusContext != null);
        this.janusContext = janusContext;
    }

    private class KernelStoppingListener
    implements KernelAgentSpawnListener {
        KernelStoppingListener() {
        }

        @Override
        public void kernelAgentSpawn() {
        }

        @Override
        public void kernelAgentDestroy() {
            StopTheKernel t = new StopTheKernel();
            t.start();
        }
    }

    private class StopTheKernel
    implements ThreadFactory,
    Runnable,
    Thread.UncaughtExceptionHandler {
        StopTheKernel() {
        }

        public void start() {
            Thread t = this.newThread(this);
            t.start();
        }

        @Override
        public void run() {
            Logger logger = Kernel.this.getLogger();
            logger.info(Messages.Kernel_0);
            Services.stopServices(Kernel.this.serviceManager);
            logger.info(Messages.Kernel_1);
            Kernel.this.isRunning.set(false);
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = Executors.defaultThreadFactory().newThread(runnable);
            t.setName("Janus kernel shutdown");
            t.setDaemon(false);
            t.setUncaughtExceptionHandler(this);
            return t;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable exception) {
            assert (thread != null);
            assert (exception != null);
            LogRecord record = new LogRecord(Level.SEVERE, exception.getLocalizedMessage());
            record.setThrown(exception);
            StackTraceElement elt = exception.getStackTrace()[0];
            assert (elt != null);
            record.setSourceClassName(elt.getClassName());
            record.setSourceMethodName(elt.getMethodName());
            Logger logger = Kernel.this.getLogger();
            logger.log(record);
        }
    }
}

