/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil.locale;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.eclipse.xtext.xbase.lib.Pure;

public class LocaleMessageFormat
extends MessageFormat {
    public static final String RAW_FORMAT_STYLE = "raw";
    private static final long serialVersionUID = 6637824487735941754L;

    public LocaleMessageFormat(String pattern) {
        super(pattern);
    }

    public LocaleMessageFormat(String pattern, Locale locale) {
        super(pattern, locale);
    }

    @Pure
    public static String format(String pattern, Object ... arguments) {
        LocaleMessageFormat temp = new LocaleMessageFormat(pattern);
        return temp.format(arguments);
    }

    @Override
    public void applyPattern(String pattern) {
        super.applyPattern(pattern);
        Format[] formats = this.getFormats();
        boolean changed = false;
        int i = 0;
        while (i < formats.length) {
            try {
                DecimalFormat df = (DecimalFormat)formats[i];
                if (df != null && RAW_FORMAT_STYLE.equalsIgnoreCase(df.getPositivePrefix())) {
                    formats[i] = new RawNumberFormat(pattern, df.getGroupingSize(), df.getMinimumIntegerDigits(), df.getMaximumIntegerDigits(), df.getMinimumFractionDigits(), df.getMaximumFractionDigits(), df.getRoundingMode());
                    changed = true;
                }
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        if (changed) {
            this.setFormats(formats);
        }
    }

    private static class RawNumberFormat
    extends NumberFormat {
        private static final long serialVersionUID = 7091190928835741939L;
        private static final char RAW_NEGATIVE_SIGN = '-';
        private static final char RAW_DECIMAL_SEPARATOR = '.';
        private static final char RAW_ZERO_DIGIT = '0';
        private final boolean isUnformatted;
        private final RoundingMode roundingMode;

        RawNumberFormat(String pattern, int groupSize, int minInt, int maxInt, int minFrac, int maxFrac, RoundingMode roundingMode) {
            this.roundingMode = roundingMode;
            this.isUnformatted = groupSize == 0 && minInt == 0 && maxInt == Integer.MAX_VALUE && minFrac == 0 && maxFrac == 0;
            this.setMinimumIntegerDigits(minInt);
            this.setMaximumIntegerDigits(maxInt);
            this.setMinimumFractionDigits(minFrac);
            this.setMaximumFractionDigits(maxFrac);
        }

        @Override
        public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
            try {
                return this.format((BigInteger)number, toAppendTo, pos);
            }
            catch (ClassCastException classCastException) {
                try {
                    return this.format((BigDecimal)number, toAppendTo, pos);
                }
                catch (ClassCastException classCastException2) {
                    return super.format(number, toAppendTo, pos);
                }
            }
        }

        public StringBuffer format(BigInteger number, StringBuffer toAppendTo, FieldPosition pos) {
            if (this.isUnformatted) {
                toAppendTo.append(number.toString());
            } else {
                this.formatInteger(number.signum() < 0, number.abs().toString(), toAppendTo);
            }
            return toAppendTo;
        }

        public StringBuffer format(BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
            if (this.isUnformatted) {
                toAppendTo.append(number.toPlainString());
            } else {
                this.formatDecimal(number, toAppendTo);
            }
            return toAppendTo;
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            if (this.isUnformatted) {
                toAppendTo.append(Double.toString(number));
            } else {
                this.formatDecimal(new BigDecimal(number), toAppendTo);
            }
            return toAppendTo;
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            if (this.isUnformatted) {
                toAppendTo.append(Long.toString(number));
            } else {
                this.formatInteger(number < 0L, Long.toString(Math.abs(number)), toAppendTo);
            }
            return toAppendTo;
        }

        private void formatInteger(boolean negative, String number, StringBuffer toAppendTo) {
            assert (!this.isUnformatted);
            if (negative) {
                toAppendTo.append('-');
            }
            int c = this.getMinimumIntegerDigits() - number.length();
            while (c > 0) {
                toAppendTo.append('0');
                --c;
            }
            toAppendTo.append(number);
            int n = this.getMinimumFractionDigits();
            if (n > 0) {
                toAppendTo.append('.');
                int c2 = 0;
                while (c2 < n) {
                    toAppendTo.append('0');
                    ++c2;
                }
            }
        }

        private void formatDecimal(BigDecimal number, StringBuffer toAppendTo) {
            String decimal;
            String integer;
            assert (!this.isUnformatted);
            boolean negative = number.compareTo(BigDecimal.ZERO) < 0;
            int minInt = this.getMinimumIntegerDigits();
            int minFrac = this.getMinimumFractionDigits();
            int maxFrac = this.getMaximumFractionDigits();
            BigDecimal n = number.setScale(maxFrac, this.roundingMode);
            String rawString = n.abs().toPlainString();
            int decimalPos = rawString.indexOf(46);
            if (decimalPos < 0) {
                integer = rawString;
                decimal = "";
            } else {
                integer = rawString.substring(0, decimalPos);
                decimal = rawString.substring(decimalPos + 1);
            }
            if (negative) {
                toAppendTo.append('-');
            }
            int c = minInt - integer.length();
            while (c > 0) {
                toAppendTo.append('0');
                --c;
            }
            toAppendTo.append(integer);
            if (minFrac > 0 || maxFrac > 0 && decimal.length() > 0) {
                toAppendTo.append('.');
                toAppendTo.append(decimal);
                c = minFrac - decimal.length();
                while (c > 0) {
                    toAppendTo.append('0');
                    --c;
                }
            }
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            throw new UnsupportedOperationException();
        }
    }
}

