/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.asserts.AssertMessages;
import org.arakhne.afc.vmutil.locale.Locale;

class URLConnection
extends java.net.URLConnection {
    private File file;
    private String contentType;

    protected URLConnection(URL url) {
        super(url);
    }

    @Override
    public String getHeaderField(int index) {
        assert (index >= 0) : AssertMessages.positiveOrZeroParameter();
        try {
            this.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        switch (index) {
            case 0: {
                return this.contentType;
            }
            case 1: {
                return Long.toString(this.file.length());
            }
            case 2: {
                return Long.toString(this.file.lastModified());
            }
        }
        return null;
    }

    @Override
    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if ("content-type".equals(name)) {
            return this.contentType;
        }
        if ("content-length".equals(name)) {
            return Long.toString(this.file.length());
        }
        if ("last-modified".equals(name)) {
            return Long.toString(this.file.lastModified());
        }
        return null;
    }

    @Override
    public String getHeaderFieldKey(int index) {
        assert (index >= 0) : AssertMessages.positiveOrZeroParameter();
        switch (index) {
            case 0: {
                return "content-type";
            }
            case 1: {
                return "content-length";
            }
            case 2: {
                return "last-modified";
            }
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            this.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        HashMap<String, List<String>> flds = new HashMap<String, List<String>>();
        flds.put("content-type", URLConnection.singletonList(this.contentType));
        flds.put("content-length", URLConnection.singletonList(Long.toString(this.file.length())));
        flds.put("last-modified", URLConnection.singletonList(Long.toString(this.file.lastModified())));
        return flds;
    }

    private static List<String> singletonList(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(value);
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.file = FileSystem.convertURLToFile(this.url);
            if (this.file == null) {
                throw new FileNotFoundException(this.url.toExternalForm());
            }
            this.contentType = new MimetypesFileTypeMap().getContentType(this.file);
            this.connected = true;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.connect();
        if (this.getDoOutput()) {
            OutputStream os = new FileOutputStream(this.file);
            if (this.getUseCaches()) {
                os = new BufferedOutputStream(os);
            }
            return os;
        }
        throw new UnknownServiceException(Locale.getString("E1", new Object[0]));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.getDoInput()) {
            InputStream is = new FileInputStream(this.file);
            if (this.getUseCaches()) {
                is = new BufferedInputStream(is);
            }
            return is;
        }
        throw new UnknownServiceException("E2");
    }
}

