/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.arakhne.afc.vmutil.ClassComparator;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.asserts.AssertMessages;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    @Pure
    public static boolean isInstance(Class<?> type, Object obj) {
        assert (type != null);
        if (obj == null) {
            return false;
        }
        if (type.isInstance(obj)) {
            return true;
        }
        if (type.isPrimitive() && type != Void.class && type != Void.TYPE) {
            if (type == Boolean.class) {
                return Boolean.TYPE.isInstance(obj);
            }
            if (type == Boolean.TYPE) {
                return Boolean.class.isInstance(obj);
            }
            if (type == Character.class) {
                return Character.TYPE.isInstance(obj);
            }
            if (type == Character.TYPE) {
                return Character.class.isInstance(obj);
            }
            if (type == Byte.class) {
                return Byte.TYPE.isInstance(obj);
            }
            if (type == Byte.TYPE) {
                return Byte.class.isInstance(obj);
            }
            if (type == Short.class) {
                return Short.TYPE.isInstance(obj);
            }
            if (type == Short.TYPE) {
                return Short.class.isInstance(obj);
            }
            if (type == Integer.class) {
                return Integer.TYPE.isInstance(obj);
            }
            if (type == Integer.TYPE) {
                return Integer.class.isInstance(obj);
            }
            if (type == Long.class) {
                return Long.TYPE.isInstance(obj);
            }
            if (type == Long.TYPE) {
                return Long.class.isInstance(obj);
            }
            if (type == Float.class) {
                return Float.TYPE.isInstance(obj);
            }
            if (type == Float.TYPE) {
                return Float.class.isInstance(obj);
            }
            if (type == Double.class) {
                return Double.TYPE.isInstance(obj);
            }
            if (type == Double.TYPE) {
                return Double.class.isInstance(obj);
            }
            if (type == Void.class) {
                return Void.TYPE.isInstance(obj);
            }
            if (type == Void.TYPE) {
                return Void.class.isInstance(obj);
            }
            assert (false) : AssertMessages.unsupportedPrimitiveType();
        }
        return false;
    }

    @Pure
    public static boolean isAssignableFrom(Class<?> assignementTarget, Class<?> assignementSource) {
        assert (assignementSource != null);
        assert (assignementTarget != null);
        if (assignementTarget.isAssignableFrom(assignementSource)) {
            return true;
        }
        return assignementTarget.isPrimitive() && assignementSource.isPrimitive() && assignementTarget != Void.class && assignementTarget != Void.TYPE && assignementSource != Void.class && assignementSource != Void.TYPE;
    }

    @Pure
    public static Class<?> forName(String name) throws ClassNotFoundException {
        if (name == null || "".equals(name) || "null".equals(name) || "void".equals(name)) {
            return Void.TYPE;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("char".equals(name)) {
            return Character.TYPE;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        return Class.forName(name);
    }

    @Pure
    @Inline(value="ReflectionUtil.forName(($1), true, ($2))", imported={ReflectionUtil.class})
    public static Class<?> forName(String name, ClassLoader loader) throws ClassNotFoundException {
        return ReflectionUtil.forName(name, true, loader);
    }

    @Pure
    public static Class<?> forName(String name, boolean typeInitialization, ClassLoader loader) throws ClassNotFoundException {
        if (name == null || "".equals(name) || "null".equals(name) || "void".equals(name)) {
            return Void.TYPE;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("char".equals(name)) {
            return Character.TYPE;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        return Class.forName(name, typeInitialization, loader);
    }

    @Pure
    @Inline(value="ReflectionUtil.getPackageClasses(($1).getName())", imported={ReflectionUtil.class})
    public static Collection<Class<?>> getPackageClasses(Package pkg) {
        return ReflectionUtil.getPackageClasses(pkg.getName());
    }

    @Pure
    public static Collection<Class<?>> getPackageClasses(String packageName) {
        String[] entries;
        ArrayList classes = new ArrayList();
        String[] stringArray = entries = System.getProperty("java.class.path").split(Pattern.quote(System.getProperty("path.separator")));
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String lentry = path.toLowerCase();
            if (lentry.endsWith(".jar") || lentry.endsWith(".war")) {
                ReflectionUtil.getPackageClassesFromJar(classes, path, packageName);
            } else {
                ReflectionUtil.getPackageClassesFromFileSystem(classes, path, packageName);
            }
            ++n2;
        }
        return classes;
    }

    private static String basename(String name) {
        int idx = name.lastIndexOf(47);
        if (idx >= 0 && idx < name.length()) {
            return name.substring(idx + 1);
        }
        return name;
    }

    private static String filename(String name) {
        String basename = ReflectionUtil.basename(name);
        int idx = basename.indexOf(46);
        if (idx >= 0 && idx < basename.length()) {
            return basename.substring(0, idx);
        }
        return name;
    }

    private static void getPackageClassesFromJar(Collection<Class<?>> classes, String jarFilename, String packageName) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (JarFile jarFile = new JarFile(jarFilename);){
                String packagePath = packageName.replace(".", "/");
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryPath = entry.getName();
                    if (!entryPath.startsWith(packagePath) || entryPath.endsWith("/") || entryPath.contains("$")) continue;
                    String entryClassname = String.valueOf(packageName) + "." + ReflectionUtil.filename(entryPath);
                    try {
                        classes.add(Class.forName(entryClassname));
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    private static void getPackageClassesFromFileSystem(Collection<Class<?>> classes, String directory, String packageName) {
        String packagePath = packageName.replace(".", File.separator);
        File packageDirectory = new File(directory, packagePath);
        if (packageDirectory.isDirectory()) {
            String[] stringArray = packageDirectory.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entryPath = stringArray[n2];
                if (!entryPath.contains("$")) {
                    String entryClassname = String.valueOf(packageName) + "." + FileSystem.shortBasename(entryPath);
                    try {
                        classes.add(Class.forName(entryClassname));
                    }
                    catch (AssertionError e) {
                        throw e;
                    }
                    catch (Throwable throwable) {}
                }
                ++n2;
            }
        }
    }

    @Pure
    public static <T> Collection<Class<? extends T>> getSubClasses(Class<T> className) {
        ArrayList<Class<? extends T>> list = new ArrayList<Class<? extends T>>();
        ReflectionUtil.getSubClasses(className, true, true, true, list);
        return list;
    }

    public static <T> void getSubClasses(Class<T> className, boolean allowAbstract, boolean allowInterface, boolean allowEnum, Collection<Class<? extends T>> result) {
        String[] entries;
        String[] stringArray = entries = System.getProperty("java.class.path").split(Pattern.quote(System.getProperty("path.separator")));
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String lentry = path.toLowerCase();
            if (lentry.endsWith(".jar") || lentry.endsWith(".war")) {
                ReflectionUtil.getSubClassesFromJar(result, path, className, allowAbstract, allowInterface, allowEnum);
            } else {
                ReflectionUtil.getSubClassesFromFileSystem(result, path, className, allowAbstract, allowInterface, allowEnum);
            }
            ++n2;
        }
    }

    private static <T> void getSubClassesFromJar(Collection<Class<? extends T>> classes, String jarFilename, Class<T> className, boolean allowAbstract, boolean allowInterface, boolean allowEnum) {
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (JarFile jarFile = new JarFile(jarFilename);){
                String classN = className.getCanonicalName();
                if (classN != null) {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String entryPath = entry.getName();
                        if (!entryPath.endsWith(".class") || entryPath.contains("$")) continue;
                        String entryClassname = entryPath.substring(0, entryPath.length() - 6).replaceAll(Pattern.quote(File.separator), ".");
                        try {
                            Class<?> clazz = Class.forName(entryClassname);
                            if (!className.isAssignableFrom(clazz) || !allowAbstract && Modifier.isAbstract(clazz.getModifiers()) || !allowInterface && clazz.isInterface() || !allowEnum && clazz.isEnum()) continue;
                            classes.add(clazz);
                        }
                        catch (AssertionError e) {
                            throw e;
                        }
                        catch (Throwable throwable2) {}
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    private static <T> void getSubClassesFromFileSystem(Collection<Class<? extends T>> classes, String directory, Class<T> className, boolean allowAbstract, boolean allowInterface, boolean allowEnum) {
        String classN = className.getCanonicalName();
        if (classN != null) {
            ArrayList<String> directories = new ArrayList<String>();
            directories.add("");
            while (!directories.isEmpty()) {
                String ldir = (String)directories.remove(0);
                File dir = new File(directory, ldir);
                if (!dir.isDirectory()) continue;
                String[] stringArray = dir.list();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String entryPath = stringArray[n2];
                    File fullFile = new File(dir, entryPath);
                    if (fullFile.isDirectory()) {
                        if (ldir == null || "".equals(ldir)) {
                            directories.add(entryPath);
                        } else {
                            directories.add(new File(ldir, entryPath).toString());
                        }
                    } else if (entryPath.endsWith(".class") && !entryPath.contains("$")) {
                        assert (ldir != null);
                        String entryClassname = String.valueOf(ldir.replaceAll(Pattern.quote(File.separator), ".")) + "." + FileSystem.shortBasename(entryPath);
                        try {
                            Class<?> clazz = Class.forName(entryClassname);
                            if (!(!className.isAssignableFrom(clazz) || !allowAbstract && Modifier.isAbstract(clazz.getModifiers()) || !allowInterface && clazz.isInterface() || !allowEnum && clazz.isEnum())) {
                                classes.add(clazz);
                            }
                        }
                        catch (AssertionError e) {
                            throw e;
                        }
                        catch (Throwable throwable) {}
                    }
                    ++n2;
                }
            }
        }
    }

    @Pure
    public static <T, I> Set<Class<? extends I>> getAllDirectInterfaces(Class<? extends T> lowestType, Class<T> highestType, Class<I> interfaceType) {
        boolean cont;
        assert (lowestType != null);
        TreeSet<Class<I>> collection = new TreeSet<Class<I>>(ClassComparator.SINGLETON);
        Class<T> type = lowestType;
        do {
            Class<?>[] classArray = type.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> directInterface = classArray[n2];
                if (interfaceType == null || interfaceType.isAssignableFrom(directInterface)) {
                    collection.add(directInterface);
                }
                ++n2;
            }
            cont = highestType == null || !type.equals(highestType);
        } while ((type = type.getSuperclass()) != null && cont);
        return collection;
    }

    public static <T> Set<Class<?>> getAllDirectInterfaces(Class<? extends T> lowestType, Class<T> highestType) {
        boolean cont;
        assert (lowestType != null);
        TreeSet collection = new TreeSet(ClassComparator.SINGLETON);
        Class<T> type = lowestType;
        do {
            Class<?>[] classArray = type.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> directInterface = classArray[n2];
                collection.add(directInterface);
                ++n2;
            }
            cont = highestType == null || !type.equals(highestType);
        } while ((type = type.getSuperclass()) != null && cont);
        return collection;
    }

    @Pure
    public static <T> Collection<Class<? super T>> getSuperClasses(Class<T> className) {
        assert (className != null);
        ArrayList<Class<T>> list = new ArrayList<Class<T>>();
        Class<T> type = className.getSuperclass();
        while (type != null && !Object.class.equals(type)) {
            list.add(type);
            type = type.getSuperclass();
        }
        return list;
    }

    public static Class<?> getCommonType(Class<?> type1, Class<?> type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        Class<?> top = type1;
        while (!top.isAssignableFrom(type2)) {
            top = top.getSuperclass();
            assert (top != null);
        }
        return top;
    }

    @Pure
    public static Class<?> getCommonType(Object instance1, Object instance2) {
        if (instance1 == null) {
            return instance2 == null ? null : instance2.getClass();
        }
        if (instance2 == null) {
            return instance1.getClass();
        }
        Class<?> top = instance1.getClass();
        while (!top.isInstance(instance2)) {
            top = top.getSuperclass();
            assert (top != null);
        }
        return top;
    }

    @Pure
    public static Class<?> getOutboxingType(Class<?> type) {
        if (Void.TYPE.equals(type)) {
            return Void.class;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        return type;
    }

    @Pure
    public static Class<?> getInboxingType(Class<?> type) {
        if (Void.class.equals(type)) {
            return Void.TYPE;
        }
        if (Boolean.class.equals(type)) {
            return Boolean.TYPE;
        }
        if (Byte.class.equals(type)) {
            return Byte.TYPE;
        }
        if (Character.class.equals(type)) {
            return Character.TYPE;
        }
        if (Double.class.equals(type)) {
            return Double.TYPE;
        }
        if (Float.class.equals(type)) {
            return Float.TYPE;
        }
        if (Integer.class.equals(type)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(type)) {
            return Long.TYPE;
        }
        if (Short.class.equals(type)) {
            return Short.TYPE;
        }
        return type;
    }

    @Pure
    public static boolean matchesParameters(Class<?>[] formalParameters, Object ... parameterValues) {
        if (formalParameters == null) {
            return parameterValues == null;
        }
        if (parameterValues != null && formalParameters.length == parameterValues.length) {
            int i = 0;
            while (i < formalParameters.length) {
                if (!ReflectionUtil.isInstance(formalParameters[i], parameterValues[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Pure
    @Inline(value="ReflectionUtil.matchesParameters(($1).getParameterTypes(), ($2))", imported={ReflectionUtil.class})
    public static boolean matchesParameters(Method method, Object ... parameters) {
        return ReflectionUtil.matchesParameters(method.getParameterTypes(), parameters);
    }
}

