/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.File;
import org.arakhne.afc.vmutil.AbstractOperatingSystemWrapper;
import org.arakhne.afc.vmutil.OperatingSystemIdentificationType;

class OperatingSystemDiskUtilWrapper
extends AbstractOperatingSystemWrapper {
    OperatingSystemDiskUtilWrapper() {
    }

    private static String runDiskUtil(File file, String key) {
        String result = OperatingSystemDiskUtilWrapper.runCommand("diskutil", "info", file.toString());
        return OperatingSystemDiskUtilWrapper.cut(":", 1, OperatingSystemDiskUtilWrapper.grep(String.valueOf(key) + ":", result));
    }

    @Override
    public String getOSSerialNumber(boolean enableSuperUser, boolean enableGUI) {
        File file = new File("/dev/disk0s1");
        if (file.exists()) {
            return OperatingSystemDiskUtilWrapper.runDiskUtil(file, "Volume UUID");
        }
        return null;
    }

    @Override
    public String getOSUUID(boolean enableSuperUser, boolean enableGUI) {
        File file = new File("/dev/disk0s1");
        if (file.exists()) {
            return OperatingSystemDiskUtilWrapper.runDiskUtil(file, "Volume UUID");
        }
        return null;
    }

    @Override
    public OperatingSystemIdentificationType getIdentificationType() {
        return OperatingSystemIdentificationType.HARD_DISK;
    }
}

