/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.arakhne.afc.vmutil.ClassLoaderFinder;
import org.arakhne.afc.vmutil.Resources;
import org.arakhne.afc.vmutil.URISchemeType;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class LibraryLoader {
    private static final int BUFFER_SIZE = 4096;
    private static volatile boolean disable;

    private LibraryLoader() {
    }

    @Pure
    public static boolean isEnable() {
        return !disable;
    }

    public static void setEnable(boolean enable) {
        disable = !enable;
    }

    public static void load(String filename) {
        if (disable) {
            return;
        }
        Runtime.getRuntime().load(filename);
    }

    public static void load(URL filename) throws IOException {
        if (disable) {
            return;
        }
        if (URISchemeType.FILE.isURL(filename)) {
            try {
                LibraryLoader.load(new File(filename.toURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new FileNotFoundException(filename.toExternalForm());
            }
        }
        String libName = System.mapLibraryName("javaDynLib");
        String suffix = ".dll";
        String prefix = "javaDynLib";
        int pos = libName.lastIndexOf(46);
        if (pos >= 0) {
            suffix = libName.substring(pos);
            prefix = libName.substring(0, pos);
        }
        File file = File.createTempFile(prefix, suffix);
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileOutputStream outs = new FileOutputStream(file);){
            Throwable throwable2 = null;
            Object var10_13 = null;
            try (InputStream ins = filename.openStream();){
                int lu;
                byte[] buffer = new byte[4096];
                while ((lu = ins.read(buffer)) > 0) {
                    outs.write(buffer, 0, lu);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        LibraryLoader.load(file);
        file.deleteOnExit();
    }

    public static void load(File filename) {
        if (disable) {
            return;
        }
        Runtime.getRuntime().load(filename.getAbsolutePath());
    }

    public static void loadLibrary(String libname) {
        if (disable) {
            return;
        }
        Runtime.getRuntime().loadLibrary(libname);
    }

    @Pure
    public static URL findLibraryURL(String libName) {
        return LibraryLoader.findLibraryURL(null, libName, null, null);
    }

    @Pure
    public static URL findLibraryURL(String path, String libName) {
        return LibraryLoader.findLibraryURL(path, libName, null, null);
    }

    private static URL findLibraryURL(String path, String libName, String platform, String arch) {
        URL libRes;
        String realLibName;
        StringBuilder buf;
        ClassLoader cl = ClassLoaderFinder.findClassLoader();
        assert (cl != null);
        String resourcePath = path;
        if (resourcePath == null) {
            resourcePath = "";
        } else if (resourcePath.length() > 0 && !resourcePath.endsWith("/")) {
            resourcePath = String.valueOf(resourcePath) + "/";
        }
        if (platform != null) {
            int idx;
            buf = new StringBuilder(libName);
            buf.append("-");
            buf.append(platform);
            if (arch != null) {
                buf.append(arch);
            }
            if ((idx = (realLibName = System.mapLibraryName(buf.toString())).indexOf(libName)) > 0) {
                realLibName = realLibName.substring(idx);
            }
        } else {
            buf = new StringBuilder(libName);
            if (arch != null) {
                buf.append(arch);
            }
            realLibName = System.mapLibraryName(buf.toString());
        }
        if ((libRes = Resources.getResource(cl, String.valueOf(resourcePath) + realLibName)) != null) {
            return libRes;
        }
        return Resources.getResource(cl, realLibName);
    }

    @Pure
    static int getOperatingSystemArchitectureDataModel() {
        String arch = System.getProperty("sun.arch.data.model");
        if (arch != null) {
            try {
                return Integer.parseInt(arch);
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable throwable) {}
        }
        return 0;
    }

    private static URL getPlatformDependentLibrary(String[] paths, String libname, String platform) {
        int dataModel = LibraryLoader.getOperatingSystemArchitectureDataModel();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            URL url;
            String path = stringArray[n2];
            if (dataModel == 64 ? (url = LibraryLoader.findLibraryURL(path, libname, platform, "64")) != null : dataModel == 32 && (url = LibraryLoader.findLibraryURL(path, libname, platform, "32")) != null) {
                return url;
            }
            url = LibraryLoader.findLibraryURL(path, libname, platform, null);
            if (url != null) {
                return url;
            }
            ++n2;
        }
        return null;
    }

    @Inline(value="LibraryLoader.loadPlatformDependentLibrary(null, $1)", imported={LibraryLoader.class}, statementExpression=true)
    public static void loadPlatformDependentLibrary(String libname) throws IOException {
        LibraryLoader.loadPlatformDependentLibrary(null, libname);
    }

    public static void loadPlatformDependentLibrary(String path, String libname) throws IOException {
        LibraryLoader.loadPlatformDependentLibrary(libname, null, path);
    }

    static void loadPlatformDependentLibrary(String libname, String platform, String ... paths) throws IOException {
        URL url = LibraryLoader.getPlatformDependentLibrary(paths, libname, null);
        if (url != null) {
            try {
                LibraryLoader.load(url);
                return;
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable throwable) {}
        }
        if (platform != null && (url = LibraryLoader.getPlatformDependentLibrary(paths, libname, platform)) != null) {
            try {
                LibraryLoader.load(url);
                return;
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable throwable) {}
        }
        LibraryLoader.loadLibrary(libname);
    }
}

