/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.arakhne.afc.vmutil.Android;
import org.arakhne.afc.vmutil.ClasspathUtil;
import org.arakhne.afc.vmutil.OperatingSystem;
import org.arakhne.afc.vmutil.Resources;
import org.arakhne.afc.vmutil.URISchemeType;
import org.arakhne.afc.vmutil.URLHandlerUtil;
import org.arakhne.afc.vmutil.locale.Locale;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class FileSystem {
    public static final char EXTENSION_SEPARATOR_CHAR = '.';
    public static final String CURRENT_DIRECTORY = ".";
    public static final String PARENT_DIRECTORY = "..";
    public static final char URL_PATH_SEPARATOR_CHAR = '/';
    public static final String URL_PATH_SEPARATOR = "/";
    public static final String EXTENSION_SEPARATOR = ".";
    public static final String JAR_URL_FILE_ROOT = "!/";
    public static final char WINDOWS_SEPARATOR_CHAR = '\\';
    public static final String WINDOWS_SEPARATOR_STRING = "\\";
    public static final String UNIX_SEPARATOR_STRING = "/";
    private static final String WINDOW_NATIVE_FILENAME_PATTERN;
    private static final Random RANDOM;
    private static final DeleteOnExitHook DELETE_ON_EXIT_HOOK;
    private static Boolean isFileCompatibleWithURL;
    private static final int BUFFER_SIZE = 4096;
    private static final char[] FILE_PREFIX;

    static {
        URLHandlerUtil.installArakhneHandlers();
        StringBuilder pattern = new StringBuilder();
        pattern.append("^");
        pattern.append("(([a-zA-Z][:|]");
        pattern.append("[^\\\\/:*?\"<>|]");
        pattern.append("*)|(");
        pattern.append("[^\\\\/:*?\"<>|]");
        pattern.append("+");
        pattern.append("\\\\");
        pattern.append("[^\\\\/:*?\"<>|]");
        pattern.append("+)|(");
        pattern.append("\\\\");
        pattern.append("))?(");
        pattern.append("\\\\");
        pattern.append("[^\\\\/:*?\"<>|]");
        pattern.append("*)*");
        pattern.append("$");
        WINDOW_NATIVE_FILENAME_PATTERN = pattern.toString();
        RANDOM = new Random();
        DELETE_ON_EXIT_HOOK = new DeleteOnExitHook();
        FILE_PREFIX = new char[]{'f', 'i', 'l', 'e', ':', '/', '/'};
    }

    private FileSystem() {
    }

    private static String decodeHTMLEntities(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, Charset.defaultCharset().displayName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private static String encodeHTMLEntities(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, Charset.defaultCharset().displayName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private static String fromFileStandardToURLStandard(File file) {
        if (file == null) {
            return null;
        }
        return FileSystem.fromFileStandardToURLStandard(file.getPath());
    }

    private static String fromFileStandardToURLStandard(String file) {
        if (file == null) {
            return null;
        }
        if (isFileCompatibleWithURL == null) {
            isFileCompatibleWithURL = "/".equals(File.separator);
        }
        String filePath = file;
        if (!isFileCompatibleWithURL.booleanValue()) {
            filePath = filePath.replaceAll(Pattern.quote(File.separator), Matcher.quoteReplacement("/"));
        }
        if (Pattern.matches("^[a-zA-Z][:|].*$", filePath)) {
            filePath = "/" + filePath;
        }
        return filePath;
    }

    @Pure
    @Inline(value="URISchemeType.JAR.isURL($1)", imported={URISchemeType.class})
    public static boolean isJarURL(URL url) {
        return URISchemeType.JAR.isURL(url);
    }

    @Pure
    public static URL getJarURL(URL url) {
        if (!FileSystem.isJarURL(url)) {
            return null;
        }
        String path = url.getPath();
        int idx = path.lastIndexOf(JAR_URL_FILE_ROOT);
        if (idx >= 0) {
            path = path.substring(0, idx);
        }
        try {
            return new URL(path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Pure
    public static File getJarFile(URL url) {
        String path;
        int idx;
        if (FileSystem.isJarURL(url) && (idx = (path = url.getPath()).lastIndexOf(JAR_URL_FILE_ROOT)) >= 0) {
            return new File(FileSystem.decodeHTMLEntities(path.substring(idx + 1)));
        }
        return null;
    }

    @Pure
    public static URL toJarURL(File jarFile, File insideFile) throws MalformedURLException {
        if (jarFile == null || insideFile == null) {
            return null;
        }
        return FileSystem.toJarURL(jarFile, FileSystem.fromFileStandardToURLStandard(insideFile));
    }

    @Pure
    @Inline(value="toJarURL(($1).toURI().toURL(), ($2))")
    public static URL toJarURL(File jarFile, String insideFile) throws MalformedURLException {
        return FileSystem.toJarURL(jarFile.toURI().toURL(), insideFile);
    }

    @Pure
    public static URL toJarURL(URL jarFile, File insideFile) throws MalformedURLException {
        if (jarFile == null || insideFile == null) {
            return null;
        }
        return FileSystem.toJarURL(jarFile, FileSystem.fromFileStandardToURLStandard(insideFile));
    }

    @Pure
    public static URL toJarURL(URL jarFile, String insideFile) throws MalformedURLException {
        if (jarFile == null || insideFile == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("jar:");
        buf.append(jarFile.toExternalForm());
        buf.append(JAR_URL_FILE_ROOT);
        String path = FileSystem.fromFileStandardToURLStandard(insideFile);
        if (path.startsWith("/")) {
            buf.append(path.substring("/".length()));
        } else {
            buf.append(path);
        }
        return new URL(buf.toString());
    }

    @Pure
    public static boolean isCaseSensitiveFilenameSystem() {
        switch (OperatingSystem.getCurrentOS()) {
            case LINUX: 
            case ANDROID: 
            case SOLARIS: 
            case FREEBSD: 
            case NETBSD: 
            case BSD: 
            case OPENBSD: 
            case AIX: 
            case HPUX: {
                return true;
            }
        }
        return false;
    }

    @Pure
    @Inline(value="EXTENSION_SEPARATOR_CHAR", constantExpression=true)
    public static char getFileExtensionCharacter() {
        return '.';
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Pure
    public static URL dirname(File filename) {
        if (filename == null) {
            return null;
        }
        String parent = FileSystem.fromFileStandardToURLStandard(filename.getParent());
        try {
            if (parent == null || "".equals(parent)) {
                if (filename.isAbsolute()) {
                    return null;
                }
                return new URL(URISchemeType.FILE.name(), "", ".");
            }
            if (Pattern.matches("^/?[a-zA-Z][:|]$", parent)) {
                parent = String.valueOf(parent) + "/";
            }
            return new URL(URISchemeType.FILE.name(), "", parent);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Pure
    public static URL dirname(URL filename) {
        String path;
        if (filename == null) {
            return null;
        }
        URL prefix = null;
        if (FileSystem.isJarURL(filename)) {
            prefix = FileSystem.getJarURL(filename);
            path = FileSystem.fromFileStandardToURLStandard(FileSystem.getJarFile(filename));
        } else {
            path = filename.getPath();
        }
        if ("".equals(path)) {
            return null;
        }
        int idx = path.lastIndexOf(47);
        if (idx == path.length() - 1) {
            idx = path.lastIndexOf(47, path.length() - 2);
        }
        path = idx < 0 ? (URISchemeType.getSchemeType(filename).isFileBasedScheme() ? "." : "/") : path.substring(0, idx + 1);
        try {
            if (prefix != null) {
                return FileSystem.toJarURL(prefix, path);
            }
            return new URI(filename.getProtocol(), filename.getUserInfo(), filename.getHost(), filename.getPort(), FileSystem.decodeHTMLEntities(path), null, null).toURL();
        }
        catch (Throwable throwable) {
            try {
                return new URL(filename.getProtocol(), filename.getHost(), path);
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    @Pure
    public static String largeBasename(String filename) {
        if (filename == null) {
            return null;
        }
        if (FileSystem.isWindowsNativeFilename(filename)) {
            return FileSystem.largeBasename(FileSystem.normalizeWindowsNativeFilename(filename));
        }
        try {
            return FileSystem.largeBasename(new URL(filename));
        }
        catch (Exception exception) {
            int idx;
            int end = filename.length();
            while ((idx = filename.lastIndexOf(File.separatorChar, --end)) >= 0 && end >= 0 && idx >= end) {
            }
            if (idx < 0) {
                if (end < filename.length() - 1) {
                    return filename.substring(0, end + 1);
                }
                return filename;
            }
            return filename.substring(idx + 1, end + 1);
        }
    }

    @Pure
    @Inline(value="((($1) == null) ? null : ($1).getName())")
    public static String largeBasename(File filename) {
        if (filename == null) {
            return null;
        }
        return filename.getName();
    }

    @Pure
    public static String largeBasename(URL filename) {
        int idx;
        if (filename == null) {
            return null;
        }
        String fullPath = filename.getPath();
        assert (!FileSystem.isWindowsNativeFilename(fullPath));
        int end = fullPath.length();
        while ((idx = fullPath.lastIndexOf(47, --end)) >= 0 && end >= 0 && idx >= end) {
        }
        String result = idx < 0 ? (end < fullPath.length() - 1 ? fullPath.substring(0, end + 1) : fullPath) : fullPath.substring(idx + 1, end + 1);
        return FileSystem.decodeHTMLEntities(result);
    }

    @Pure
    public static String basename(String filename) {
        if (filename == null) {
            return null;
        }
        if (FileSystem.isWindowsNativeFilename(filename)) {
            return FileSystem.basename(FileSystem.normalizeWindowsNativeFilename(filename));
        }
        try {
            return FileSystem.basename(new URL(filename));
        }
        catch (Exception exception) {
            int idx;
            int end = filename.length();
            while ((idx = filename.lastIndexOf(File.separatorChar, --end)) >= 0 && end >= 0 && idx >= end) {
            }
            String basename = idx < 0 ? (end < filename.length() - 1 ? filename.substring(0, end + 1) : filename) : filename.substring(idx + 1, end + 1);
            idx = basename.lastIndexOf(FileSystem.getFileExtensionCharacter());
            if (idx < 0) {
                return basename;
            }
            return basename.substring(0, idx);
        }
    }

    @Pure
    public static String basename(File filename) {
        if (filename == null) {
            return null;
        }
        String largeBasename = filename.getName();
        int idx = largeBasename.lastIndexOf(FileSystem.getFileExtensionCharacter());
        if (idx <= 0) {
            return largeBasename;
        }
        return largeBasename.substring(0, idx);
    }

    @Pure
    public static String basename(URL filename) {
        int idx;
        if (filename == null) {
            return null;
        }
        String largeBasename = filename.getPath();
        assert (!FileSystem.isWindowsNativeFilename(largeBasename));
        int end = largeBasename.length();
        while ((idx = largeBasename.lastIndexOf(47, --end)) >= 0 && end >= 0 && idx >= end) {
        }
        String basename = idx < 0 ? (end < largeBasename.length() - 1 ? largeBasename.substring(0, end + 1) : largeBasename) : largeBasename.substring(idx + 1, end + 1);
        idx = basename.lastIndexOf(FileSystem.getFileExtensionCharacter());
        if (idx >= 0) {
            basename = basename.substring(0, idx);
        }
        return FileSystem.decodeHTMLEntities(basename);
    }

    @Pure
    public static String shortBasename(String filename) {
        if (filename == null) {
            return null;
        }
        if (FileSystem.isWindowsNativeFilename(filename)) {
            return FileSystem.shortBasename(FileSystem.normalizeWindowsNativeFilename(filename));
        }
        try {
            return FileSystem.shortBasename(new URL(filename));
        }
        catch (Exception exception) {
            int idx;
            String normalizedFilename = FileSystem.fromFileStandardToURLStandard(filename);
            int end = normalizedFilename.length();
            while ((idx = normalizedFilename.lastIndexOf(47, --end)) >= 0 && end >= 0 && idx >= end) {
            }
            String basename = idx < 0 ? (end < normalizedFilename.length() - 1 ? normalizedFilename.substring(0, end + 1) : normalizedFilename) : normalizedFilename.substring(idx + 1, end + 1);
            idx = basename.indexOf(FileSystem.getFileExtensionCharacter());
            if (idx < 0) {
                return basename;
            }
            return basename.substring(0, idx);
        }
    }

    @Pure
    public static String shortBasename(File filename) {
        if (filename == null) {
            return null;
        }
        String largeBasename = filename.getName();
        int idx = largeBasename.indexOf(FileSystem.getFileExtensionCharacter());
        if (idx < 0) {
            return largeBasename;
        }
        return largeBasename.substring(0, idx);
    }

    @Pure
    public static String shortBasename(URL filename) {
        int idx;
        if (filename == null) {
            return null;
        }
        String largeBasename = filename.getPath();
        assert (!FileSystem.isWindowsNativeFilename(largeBasename));
        int end = largeBasename.length();
        while ((idx = largeBasename.lastIndexOf(47, --end)) >= 0 && end >= 0 && idx >= end) {
        }
        String basename = idx < 0 ? (end < largeBasename.length() - 1 ? largeBasename.substring(0, end + 1) : largeBasename) : largeBasename.substring(idx + 1, end + 1);
        idx = basename.indexOf(FileSystem.getFileExtensionCharacter());
        if (idx >= 0) {
            basename = basename.substring(0, idx);
        }
        return FileSystem.decodeHTMLEntities(basename);
    }

    @Pure
    public static String extension(File filename) {
        if (filename == null) {
            return null;
        }
        String largeBasename = FileSystem.largeBasename(filename);
        int idx = largeBasename.lastIndexOf(FileSystem.getFileExtensionCharacter());
        if (idx <= 0) {
            return "";
        }
        return largeBasename.substring(idx);
    }

    @Pure
    public static String extension(String filename) {
        if (filename == null) {
            return null;
        }
        String largeBasename = FileSystem.largeBasename(filename);
        int idx = largeBasename.lastIndexOf(FileSystem.getFileExtensionCharacter());
        if (idx <= 0) {
            return "";
        }
        return largeBasename.substring(idx);
    }

    @Pure
    public static String extension(URL filename) {
        if (filename == null) {
            return null;
        }
        String largeBasename = FileSystem.largeBasename(filename);
        int idx = largeBasename.lastIndexOf(FileSystem.getFileExtensionCharacter());
        if (idx <= 0) {
            return "";
        }
        return FileSystem.decodeHTMLEntities(largeBasename.substring(idx));
    }

    @Pure
    public static String[] extensions(File filename) {
        if (filename == null) {
            return new String[0];
        }
        String largeBasename = FileSystem.largeBasename(filename);
        String[] parts = largeBasename.split(Pattern.quote(Character.toString(FileSystem.getFileExtensionCharacter())));
        if (parts.length <= 1) {
            return new String[0];
        }
        String[] result = new String[parts.length - 1];
        System.arraycopy(parts, 1, result, 0, result.length);
        return result;
    }

    @Pure
    public static String[] extensions(String filename) {
        if (filename == null) {
            return new String[0];
        }
        String largeBasename = FileSystem.largeBasename(filename);
        String[] parts = largeBasename.split(Pattern.quote(Character.toString(FileSystem.getFileExtensionCharacter())));
        if (parts.length <= 1) {
            return new String[0];
        }
        String[] result = new String[parts.length - 1];
        System.arraycopy(parts, 1, result, 0, result.length);
        return result;
    }

    @Pure
    public static String[] extensions(URL filename) {
        if (filename == null) {
            return new String[0];
        }
        String largeBasename = FileSystem.largeBasename(filename);
        String[] parts = largeBasename.split(Pattern.quote(Character.toString(FileSystem.getFileExtensionCharacter())));
        if (parts.length <= 1) {
            return new String[0];
        }
        String[] result = new String[parts.length - 1];
        int i = 0;
        while (i < result.length) {
            result[i] = FileSystem.decodeHTMLEntities(parts[i + 1]);
            ++i;
        }
        return result;
    }

    @Pure
    public static String[] split(File filename) {
        if (filename == null) {
            return new String[0];
        }
        return filename.getPath().split(Pattern.quote(File.separator));
    }

    @Pure
    public static String[] split(URL filename) {
        if (filename == null) {
            return new String[0];
        }
        if (FileSystem.isJarURL(filename)) {
            return FileSystem.split(FileSystem.getJarFile(filename));
        }
        String path = filename.getPath();
        String[] tab = path.split(Pattern.quote("/"));
        if (tab.length >= 2 && "".equals(tab[0]) && Pattern.matches("^[a-zA-Z][:|]$", tab[1])) {
            tab = Arrays.copyOfRange(tab, 1, tab.length);
            int i = 1;
            while (i < tab.length) {
                tab[i] = FileSystem.decodeHTMLEntities(tab[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < tab.length) {
                tab[i] = FileSystem.decodeHTMLEntities(tab[i]);
                ++i;
            }
        }
        return tab;
    }

    @Pure
    public static File join(File fileBase, String ... elements) {
        if (fileBase == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(fileBase.getPath());
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            boolean empty;
            String elt = stringArray[n2];
            boolean bl = empty = elt == null || elt.length() == 0;
            if (!empty) {
                assert (elt != null);
                if (!elt.startsWith(File.separator) && buf.length() >= 0 && buf.charAt(buf.length() - 1) != File.separatorChar) {
                    buf.append(File.separatorChar);
                }
                buf.append(elt);
            }
            ++n2;
        }
        return new File(buf.toString());
    }

    @Pure
    public static File join(File fileBase, File ... elements) {
        if (fileBase == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(fileBase.getPath());
        File[] fileArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            File elt = fileArray[n2];
            if (!elt.isAbsolute() && buf.length() >= 0 && buf.charAt(buf.length() - 1) != File.separatorChar) {
                buf.append(File.separatorChar);
            }
            buf.append(elt.getPath());
            ++n2;
        }
        return new File(buf.toString());
    }

    @Pure
    public static URL join(URL urlBase, String ... elements) {
        if (urlBase == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(FileSystem.decodeHTMLEntities(urlBase.getPath().replaceFirst(String.valueOf(Pattern.quote("/")) + "+$", "")));
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            boolean empty;
            String elt = stringArray[n2];
            boolean bl = empty = elt == null || elt.length() == 0;
            if (!empty) {
                assert (elt != null);
                if (!(elt.startsWith(File.separator) || buf.length() != 0 && buf.charAt(buf.length() - 1) == '/')) {
                    buf.append('/');
                }
                buf.append(elt);
            }
            ++n2;
        }
        try {
            if (FileSystem.isJarURL(urlBase)) {
                return new URL(urlBase.getProtocol(), urlBase.getHost(), urlBase.getPort(), buf.toString());
            }
            return new URI(urlBase.getProtocol(), urlBase.getUserInfo(), urlBase.getHost(), urlBase.getPort(), buf.toString(), FileSystem.decodeHTMLEntities(urlBase.getQuery()), urlBase.getRef()).toURL();
        }
        catch (Throwable throwable) {
            try {
                return new URL(urlBase.getProtocol(), urlBase.getHost(), buf.toString());
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    @Pure
    public static URL join(URL urlBase, File ... elements) {
        if (urlBase == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(urlBase.getPath());
        File[] fileArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            File elt = fileArray[n2];
            if (!(elt.isAbsolute() || buf.length() != 0 && buf.charAt(buf.length() - 1) == '/')) {
                buf.append('/');
            }
            buf.append(FileSystem.fromFileStandardToURLStandard(elt));
            ++n2;
        }
        try {
            if (FileSystem.isJarURL(urlBase)) {
                return new URL(urlBase.getProtocol(), urlBase.getHost(), urlBase.getPort(), buf.toString());
            }
            return new URI(urlBase.getProtocol(), urlBase.getUserInfo(), urlBase.getHost(), urlBase.getPort(), FileSystem.decodeHTMLEntities(buf.toString()), FileSystem.decodeHTMLEntities(urlBase.getQuery()), urlBase.getRef()).toURL();
        }
        catch (Throwable throwable) {
            try {
                return new URL(urlBase.getProtocol(), urlBase.getHost(), buf.toString());
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    @Pure
    public static boolean hasExtension(File filename, String extension) {
        String ext;
        if (filename == null) {
            return false;
        }
        assert (extension != null);
        String extent = extension;
        if (!"".equals(extent) && !extent.startsWith(".")) {
            extent = "." + extent;
        }
        if ((ext = FileSystem.extension(filename)) == null) {
            return false;
        }
        if (FileSystem.isCaseSensitiveFilenameSystem()) {
            return ext.equals(extent);
        }
        return ext.equalsIgnoreCase(extent);
    }

    @Pure
    public static boolean hasExtension(String filename, String extension) {
        String ext;
        if (filename == null) {
            return false;
        }
        assert (extension != null);
        String extent = extension;
        if (!"".equals(extent) && !extent.startsWith(".")) {
            extent = "." + extent;
        }
        if ((ext = FileSystem.extension(filename)) == null) {
            return false;
        }
        if (FileSystem.isCaseSensitiveFilenameSystem()) {
            return ext.equals(extent);
        }
        return ext.equalsIgnoreCase(extent);
    }

    @Pure
    public static boolean hasExtension(URL filename, String extension) {
        String ext;
        if (filename == null) {
            return false;
        }
        assert (extension != null);
        String extent = extension;
        if (!"".equals(extent) && !extent.startsWith(".")) {
            extent = "." + extent;
        }
        if ((ext = FileSystem.extension(filename)) == null) {
            return false;
        }
        if (FileSystem.isCaseSensitiveFilenameSystem()) {
            return ext.equals(extent);
        }
        return ext.equalsIgnoreCase(extent);
    }

    @Pure
    public static File removeExtension(File filename) {
        if (filename == null) {
            return null;
        }
        File dir = filename.getParentFile();
        String name = filename.getName();
        int idx = name.lastIndexOf(FileSystem.getFileExtensionCharacter());
        if (idx < 0) {
            return filename;
        }
        return new File(dir, name.substring(0, idx));
    }

    @Pure
    public static URL removeExtension(URL filename) {
        if (filename == null) {
            return null;
        }
        String path = filename.getPath().replaceFirst(String.valueOf(Pattern.quote("/")) + "+$", "");
        int idx = path.lastIndexOf("/");
        StringBuilder buf = new StringBuilder(idx < 0 ? "" : FileSystem.decodeHTMLEntities(path.substring(0, idx + 1)));
        String largeBasename = FileSystem.decodeHTMLEntities(path.substring(idx + 1));
        if ((idx = largeBasename.lastIndexOf(FileSystem.getFileExtensionCharacter())) < 0) {
            return filename;
        }
        buf.append(largeBasename.substring(0, idx));
        try {
            if (FileSystem.isJarURL(filename)) {
                return new URL(filename.getProtocol(), filename.getHost(), filename.getPort(), buf.toString());
            }
            return new URI(filename.getProtocol(), filename.getUserInfo(), filename.getHost(), filename.getPort(), buf.toString(), FileSystem.decodeHTMLEntities(filename.getQuery()), filename.getRef()).toURL();
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {
            try {
                return new URL(filename.getProtocol(), filename.getHost(), buf.toString());
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    @Pure
    public static File replaceExtension(File filename, String extension) {
        if (filename == null) {
            return null;
        }
        if (extension == null) {
            return filename;
        }
        File dir = filename.getParentFile();
        String name = filename.getName();
        int idx = name.lastIndexOf(FileSystem.getFileExtensionCharacter());
        StringBuilder n = new StringBuilder();
        if (idx < 0) {
            n.append(name);
        } else {
            n.append(name.substring(0, idx));
        }
        if (!name.endsWith(".") && !extension.startsWith(".")) {
            n.append(".");
        }
        n.append(extension);
        return new File(dir, n.toString());
    }

    @Pure
    public static URL replaceExtension(URL filename, String extension) {
        if (filename == null) {
            return null;
        }
        if (extension == null) {
            return filename;
        }
        String path = filename.getPath().replaceFirst(String.valueOf(Pattern.quote("/")) + "+$", "");
        if (!path.isEmpty()) {
            int idx = path.lastIndexOf("/");
            StringBuilder buf = new StringBuilder(idx < 0 ? "" : FileSystem.decodeHTMLEntities(path.substring(0, idx + 1)));
            String largeBasename = FileSystem.decodeHTMLEntities(path.substring(idx + 1));
            if ((idx = largeBasename.lastIndexOf(FileSystem.getFileExtensionCharacter())) < 0) {
                buf.append(largeBasename);
            } else {
                buf.append(largeBasename.substring(0, idx));
            }
            if (!"".equals(extension) && !extension.startsWith(".")) {
                buf.append(".");
            }
            buf.append(extension);
            path = buf.toString();
        }
        try {
            if (FileSystem.isJarURL(filename)) {
                return new URL(filename.getProtocol(), filename.getHost(), filename.getPort(), path);
            }
            return new URI(filename.getProtocol(), filename.getUserInfo(), filename.getHost(), filename.getPort(), path, FileSystem.encodeHTMLEntities(filename.getQuery()), filename.getRef()).toURL();
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {
            try {
                return new URL(filename.getProtocol(), filename.getHost(), path);
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    @Pure
    public static File addExtension(File filename, String extension) {
        if (filename != null && !FileSystem.hasExtension(filename, extension)) {
            String extent = extension;
            if (!"".equals(extent) && !extent.startsWith(".")) {
                extent = "." + extent;
            }
            return new File(filename.getParentFile(), String.valueOf(filename.getName()) + extent);
        }
        return filename;
    }

    @Pure
    public static URL addExtension(URL filename, String extension) {
        String basename;
        if (filename != null && !FileSystem.hasExtension(filename, extension) && !(basename = FileSystem.largeBasename(filename)).isEmpty()) {
            StringBuilder buf = new StringBuilder(FileSystem.decodeHTMLEntities(filename.getPath()).replaceFirst(String.valueOf(Pattern.quote("/")) + "+$", ""));
            if (!"".equals(extension) && !extension.startsWith(".")) {
                buf.append(".");
            }
            buf.append(extension);
            String path = buf.toString();
            try {
                if (FileSystem.isJarURL(filename)) {
                    return new URL(filename.getProtocol(), filename.getHost(), filename.getPort(), path);
                }
                return new URI(filename.getProtocol(), filename.getUserInfo(), filename.getHost(), filename.getPort(), path, FileSystem.encodeHTMLEntities(filename.getQuery()), filename.getRef()).toURL();
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    return new URL(filename.getProtocol(), filename.getHost(), path);
                }
                catch (AssertionError e) {
                    throw e;
                }
                catch (Throwable throwable2) {
                    return null;
                }
            }
        }
        return filename;
    }

    public static void delete(File file) throws IOException {
        if (file != null) {
            LinkedList<File> candidates = new LinkedList<File>();
            candidates.add(file);
            while (!candidates.isEmpty()) {
                File fl = (File)candidates.getFirst();
                if (fl.isDirectory()) {
                    File[] children = fl.listFiles();
                    if (children != null && children.length > 0) {
                        File[] fileArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File c = fileArray[n2];
                            candidates.push(c);
                            ++n2;
                        }
                        continue;
                    }
                    candidates.removeFirst();
                    fl.delete();
                    continue;
                }
                candidates.removeFirst();
                fl.delete();
            }
        }
    }

    public static void deleteOnExit(File file) throws IOException {
        if (file != null) {
            DELETE_ON_EXIT_HOOK.add(file);
        }
    }

    public static void undeleteOnExit(File file) throws IOException {
        if (file != null) {
            DELETE_ON_EXIT_HOOK.remove(file);
        }
    }

    public static void copy(File in, File out) throws IOException {
        assert (in != null);
        assert (out != null);
        File outFile = out;
        if (out.isDirectory()) {
            outFile = new File(out, FileSystem.largeBasename(in));
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream fis = new FileInputStream(in);){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (FileOutputStream fos = new FileOutputStream(outFile);){
                FileSystem.copy(fis, (int)in.length(), fos);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static void copy(URL in, File out) throws IOException {
        assert (in != null);
        assert (out != null);
        File outFile = out;
        if (out.isDirectory()) {
            outFile = new File(out, FileSystem.largeBasename(in));
        }
        URLConnection connection = in.openConnection();
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream fos = new FileOutputStream(outFile);){
            FileSystem.copy(connection.getInputStream(), connection.getContentLength(), fos);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void copy(InputStream in, int inSize, FileOutputStream out) throws IOException {
        if (!FileSystem.$assertionsDisabled && in == null) {
            throw new AssertionError();
        }
        if (!FileSystem.$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        var3_3 = null;
        var4_5 = null;
        try {
            inChannel = Channels.newChannel(in);
            try {
                var6_8 = null;
                var7_10 = null;
                try {
                    outChannel = out.getChannel();
                    try {
                        if (inSize < 0 || OperatingSystem.WIN.isCurrentOS()) {
                            position = 0L;
                            copied = 1L;
                            block10: while (inSize >= 0 && position < (long)inSize) {
                                while (true) {
                                    copied = outChannel.transferFrom(inChannel, position, 67076096L);
                                    position += copied;
                                    continue block10;
                                    break;
                                }
                            }
                            if (inSize < 0) {
                                if (copied > 0L) ** continue;
                            }
                        } else {
                            outChannel.transferFrom(inChannel, 0L, inSize);
                        }
                    }
                    finally {
                        if (outChannel != null) {
                            outChannel.close();
                        }
                    }
                }
                catch (Throwable var7_11) {
                    if (var6_8 == null) {
                        var6_8 = var7_11;
                    } else if (var6_8 != var7_11) {
                        var6_8.addSuppressed(var7_11);
                    }
                    throw var6_8;
                }
            }
            finally {
                if (inChannel != null) {
                    inChannel.close();
                }
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
    }

    @Pure
    public static File getUserHomeDirectory() throws FileNotFoundException {
        File file;
        String userHome = System.getProperty("user.home");
        if (userHome != null && !userHome.isEmpty() && (file = new File(userHome)).isDirectory()) {
            return file;
        }
        if (OperatingSystem.ANDROID.isCurrentOS()) {
            return FileSystem.join(File.listRoots()[0], "sdcard");
        }
        throw new FileNotFoundException();
    }

    @Pure
    public static String getUserHomeDirectoryName() {
        String userHome = System.getProperty("user.home");
        if ((userHome == null || userHome.isEmpty()) && OperatingSystem.ANDROID.isCurrentOS()) {
            return FileSystem.join(File.listRoots()[0], "sdcard").toString();
        }
        return userHome;
    }

    @Pure
    public static File getUserConfigurationDirectoryFor(String software) {
        if (software == null || "".equals(software)) {
            throw new IllegalArgumentException();
        }
        try {
            String userName;
            File userHome = FileSystem.getUserHomeDirectory();
            OperatingSystem os = OperatingSystem.getCurrentOS();
            if (os == OperatingSystem.ANDROID) {
                return FileSystem.join(userHome, "Android", "data", Android.makeAndroidApplicationName(software));
            }
            if (os.isUnixCompliant()) {
                return new File(new File(userHome, ".config"), software);
            }
            if (os == OperatingSystem.WIN && (userName = System.getProperty("user.name")) != null && !"".equals(userName)) {
                return FileSystem.join(new File("C:"), "Documents and Settings", userName, "Local Settings", "Application Data", software);
            }
            return new File(userHome, software);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Pure
    public static String getUserConfigurationDirectoryNameFor(String software) {
        File directory = FileSystem.getUserConfigurationDirectoryFor(software);
        if (directory != null) {
            return directory.getAbsolutePath();
        }
        return null;
    }

    @Pure
    public static File getSystemConfigurationDirectoryFor(String software) {
        if (software == null || "".equals(software)) {
            throw new IllegalArgumentException();
        }
        OperatingSystem os = OperatingSystem.getCurrentOS();
        if (os == OperatingSystem.ANDROID) {
            return FileSystem.join(File.listRoots()[0], "config", Android.makeAndroidApplicationName(software));
        }
        if (os.isUnixCompliant()) {
            File[] roots = File.listRoots();
            return FileSystem.join(roots[0], "etc", software);
        }
        if (os == OperatingSystem.WIN) {
            File[] fileArray = File.listRoots();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File root = fileArray[n2];
                File pfDirectory = new File(root, "Program Files");
                if (pfDirectory.isDirectory()) {
                    return new File(root, software);
                }
                ++n2;
            }
        }
        return null;
    }

    @Pure
    public static String getSystemConfigurationDirectoryNameFor(String software) {
        File directory = FileSystem.getSystemConfigurationDirectoryFor(software);
        if (directory != null) {
            return directory.getAbsolutePath();
        }
        return null;
    }

    @Pure
    public static File getSystemSharedLibraryDirectoryFor(String software) {
        if (software == null || "".equals(software)) {
            throw new IllegalArgumentException();
        }
        OperatingSystem os = OperatingSystem.getCurrentOS();
        if (os == OperatingSystem.ANDROID) {
            return FileSystem.join(File.listRoots()[0], "data", Android.makeAndroidApplicationName(software));
        }
        if (os.isUnixCompliant()) {
            File[] roots = File.listRoots();
            return FileSystem.join(roots[0], "usr", "lib", software);
        }
        if (os == OperatingSystem.WIN) {
            File[] fileArray = File.listRoots();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File root = fileArray[n2];
                File pfDirectory = new File(root, "Program Files");
                if (pfDirectory.isDirectory()) {
                    return new File(root, software);
                }
                ++n2;
            }
        }
        return null;
    }

    @Pure
    public static String getSystemSharedLibraryDirectoryNameFor(String software) {
        File f = FileSystem.getSystemSharedLibraryDirectoryFor(software);
        if (f == null) {
            return null;
        }
        return f.getAbsolutePath();
    }

    @Pure
    public static File convertStringToFile(String filename) {
        if (filename == null || "".equals(filename)) {
            return null;
        }
        if (FileSystem.isWindowsNativeFilename(filename)) {
            return FileSystem.normalizeWindowsNativeFilename(filename);
        }
        return new File(FileSystem.extractLocalPath(filename).replaceAll(Pattern.quote("/"), Matcher.quoteReplacement(File.separator)));
    }

    @Pure
    public static File convertURLToFile(URL url) {
        URI uri;
        URL theUrl = url;
        if (theUrl == null) {
            return null;
        }
        if (URISchemeType.RESOURCE.isURL(theUrl) && (theUrl = Resources.getResource(FileSystem.decodeHTMLEntities(theUrl.getFile()))) == null) {
            theUrl = url;
        }
        try {
            uri = theUrl.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                uri = new URI(theUrl.getProtocol(), theUrl.getUserInfo(), theUrl.getHost(), theUrl.getPort(), FileSystem.decodeHTMLEntities(theUrl.getPath()), FileSystem.decodeHTMLEntities(theUrl.getQuery()), theUrl.getRef());
            }
            catch (URISyntaxException uRISyntaxException2) {
                throw new IllegalArgumentException(Locale.getString("E1", theUrl));
            }
        }
        if (uri != null && URISchemeType.FILE.isURI(uri)) {
            String auth = uri.getAuthority();
            String path = uri.getPath();
            if (path == null) {
                path = uri.getRawPath();
            }
            if (path == null) {
                path = uri.getSchemeSpecificPart();
            }
            if (path == null) {
                path = uri.getRawSchemeSpecificPart();
            }
            if (path != null) {
                path = auth == null || "".equals(auth) ? FileSystem.decodeHTMLEntities(path) : FileSystem.decodeHTMLEntities(String.valueOf(auth) + path);
                if (Pattern.matches("^" + Pattern.quote("/") + "[a-zA-Z][:|].*$", path)) {
                    path = path.substring("/".length());
                }
                return new File(path);
            }
        }
        throw new IllegalArgumentException(Locale.getString("E2", theUrl));
    }

    @Pure
    public static URL convertStringToURL(String urlDescription, boolean allowResourceSearch) {
        return FileSystem.convertStringToURL(urlDescription, allowResourceSearch, true, true);
    }

    @Pure
    public static URL convertStringToURL(String urlDescription, boolean allowResourceSearch, boolean repliesFileURL) {
        return FileSystem.convertStringToURL(urlDescription, allowResourceSearch, repliesFileURL, true);
    }

    @Pure
    static URL convertStringToURL(String urlDescription, boolean allowResourceSearch, boolean repliesFileURL, boolean supportWindowsPaths) {
        URL url = null;
        if (urlDescription != null && urlDescription.length() > 0) {
            File file;
            if (supportWindowsPaths && FileSystem.isWindowsNativeFilename(urlDescription) && (file = FileSystem.normalizeWindowsNativeFilename(urlDescription)) != null) {
                return FileSystem.convertFileToURL(file);
            }
            if (URISchemeType.RESOURCE.isScheme(urlDescription)) {
                if (allowResourceSearch) {
                    String resourceName = urlDescription.substring(9);
                    url = Resources.getResource(resourceName);
                }
            } else if (URISchemeType.FILE.isScheme(urlDescription)) {
                file = new File(URISchemeType.FILE.removeScheme(urlDescription));
                try {
                    url = new URL(URISchemeType.FILE.name(), "", FileSystem.fromFileStandardToURLStandard(file));
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                try {
                    url = new URL(urlDescription);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (url == null) {
                if (allowResourceSearch) {
                    url = Resources.getResource(urlDescription);
                }
                if (url == null && URISchemeType.RESOURCE.isScheme(urlDescription)) {
                    return null;
                }
                if (url == null && repliesFileURL) {
                    URL jarURL;
                    int idx;
                    String urlPart = URISchemeType.removeAnyScheme(urlDescription);
                    if (URISchemeType.JAR.isScheme(urlDescription) && (idx = urlPart.indexOf(JAR_URL_FILE_ROOT)) > 0 && (jarURL = FileSystem.convertStringToURL(urlPart.substring(0, idx), allowResourceSearch)) != null) {
                        try {
                            url = FileSystem.toJarURL(jarURL, urlPart.substring(idx + 2));
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                    if (url == null) {
                        try {
                            File file2 = new File(urlPart);
                            url = new URL(URISchemeType.FILE.name(), "", FileSystem.fromFileStandardToURLStandard(file2));
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
            }
        }
        return url;
    }

    @Pure
    public static File makeAbsolute(File filename, File current) {
        if (filename == null) {
            return null;
        }
        if (current != null && !filename.isAbsolute()) {
            try {
                return new File(current.getCanonicalFile(), filename.getPath());
            }
            catch (IOException iOException) {
                return new File(current.getAbsoluteFile(), filename.getPath());
            }
        }
        return filename;
    }

    @Pure
    public static URL makeAbsolute(URL filename, File current) {
        try {
            return FileSystem.makeAbsolute(filename, current == null ? null : current.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return filename;
        }
    }

    @Pure
    public static URL makeAbsolute(URL filename, URL current) {
        if (filename == null) {
            return null;
        }
        URISchemeType scheme = URISchemeType.getSchemeType(filename);
        switch (scheme) {
            case JAR: {
                try {
                    URL jarUrl = FileSystem.getJarURL(filename);
                    jarUrl = FileSystem.makeAbsolute(jarUrl, current);
                    File jarFile = FileSystem.getJarFile(filename);
                    return FileSystem.toJarURL(jarUrl, jarFile);
                }
                catch (MalformedURLException malformedURLException) {
                    break;
                }
            }
            case FILE: {
                File file = new File(filename.getFile());
                if (file.isAbsolute() || current == null) break;
                return FileSystem.join(current, file);
            }
        }
        return filename;
    }

    @Pure
    public static URL makeAbsolute(File filename, URL current) {
        if (filename != null) {
            if (!filename.isAbsolute() && current != null) {
                return FileSystem.join(current, filename);
            }
            try {
                return new URL(String.valueOf(URISchemeType.FILE.toString()) + FileSystem.fromFileStandardToURLStandard(filename.getAbsolutePath()));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    @Pure
    public static URL getParentURL(URL url) throws MalformedURLException {
        String parentStr;
        String prefix;
        int index;
        if (url == null) {
            return url;
        }
        String path = url.getPath();
        switch (URISchemeType.getSchemeType(url)) {
            case JAR: {
                index = path.indexOf(JAR_URL_FILE_ROOT);
                assert (index > 0);
                prefix = path.substring(0, index + 1);
                path = path.substring(index + 1);
                parentStr = "/";
                break;
            }
            case FILE: {
                prefix = null;
                parentStr = "../";
                break;
            }
            default: {
                prefix = null;
                parentStr = "/";
            }
        }
        if (path == null || "".equals(path)) {
            path = parentStr;
        }
        path = (index = path.lastIndexOf(47)) == -1 ? parentStr : (index == path.length() - 1 ? ((index = path.lastIndexOf(47, index - 1)) == -1 ? parentStr : path.substring(0, index + 1)) : path.substring(0, index + 1));
        if (prefix != null) {
            path = String.valueOf(prefix) + path;
        }
        return new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
    }

    @Pure
    private static String extractLocalPath(String filename) {
        if (filename == null) {
            return null;
        }
        int max = Math.min(FILE_PREFIX.length, filename.length());
        int inner = max - 2;
        if (inner <= 0) {
            return filename;
        }
        boolean foundInner = false;
        boolean foundFull = false;
        int i = 0;
        while (i < max) {
            char c = Character.toLowerCase(filename.charAt(i));
            if (FILE_PREFIX[i] != c) {
                foundFull = false;
                foundInner = i >= inner;
                break;
            }
            foundFull = true;
            ++i;
        }
        String fn = foundFull ? filename.substring(FILE_PREFIX.length) : (foundInner ? filename.substring(inner) : filename);
        if (Pattern.matches("^(" + Pattern.quote("/") + "|" + Pattern.quote(WINDOWS_SEPARATOR_STRING) + ")[a-zA-Z][:|].*$", fn)) {
            fn = fn.substring(1);
        }
        return fn;
    }

    @Pure
    public static boolean isWindowsNativeFilename(String filename) {
        String fn = FileSystem.extractLocalPath(filename);
        if (fn == null || fn.length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile(WINDOW_NATIVE_FILENAME_PATTERN);
        Matcher matcher = pattern.matcher(fn);
        return matcher.matches();
    }

    @Pure
    public static File normalizeWindowsNativeFilename(String filename) {
        Pattern pattern;
        Matcher matcher;
        String fn = FileSystem.extractLocalPath(filename);
        if (fn != null && fn.length() > 0 && (matcher = (pattern = Pattern.compile(WINDOW_NATIVE_FILENAME_PATTERN)).matcher(fn)).find()) {
            return new File(fn.replace('\\', File.separatorChar));
        }
        return null;
    }

    @Pure
    public static URL convertFileToURL(File file) {
        if (file == null) {
            return null;
        }
        try {
            File thefile = file;
            if (FileSystem.isWindowsNativeFilename(file.toString()) && (thefile = FileSystem.normalizeWindowsNativeFilename(file.toString())) == null) {
                thefile = file;
            }
            URL url = thefile.toURI().toURL();
            return FileSystem.toShortestURL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Pure
    public static URL toShortestURL(URL url) {
        if (url == null) {
            return null;
        }
        String shorterUrl = url.toExternalForm().replaceAll("/$", "");
        Iterator<URL> classpath = ClasspathUtil.getClasspath();
        while (classpath.hasNext()) {
            URL path = classpath.next();
            String sp = path.toExternalForm().replaceAll("/$", "");
            if (!shorterUrl.startsWith(sp)) continue;
            StringBuilder buffer = new StringBuilder("resource:");
            buffer.append(shorterUrl.substring(sp.length()).replaceAll("^/", ""));
            try {
                return new URL(buffer.toString());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        try {
            return new URL(shorterUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return url;
        }
    }

    @Pure
    public static File makeRelative(File filenameToMakeRelative, File rootPath) throws IOException {
        return FileSystem.makeRelative(filenameToMakeRelative, rootPath, true);
    }

    private static File makeRelative(File filenameToMakeRelative, File rootPath, boolean appendCurrentDirectorySymbol) throws IOException {
        if (filenameToMakeRelative == null || rootPath == null) {
            throw new IllegalArgumentException();
        }
        if (!filenameToMakeRelative.isAbsolute()) {
            return filenameToMakeRelative;
        }
        if (!rootPath.isAbsolute()) {
            return filenameToMakeRelative;
        }
        File root = rootPath.getCanonicalFile();
        File dir = filenameToMakeRelative.getParentFile().getCanonicalFile();
        String[] parts1 = FileSystem.split(dir);
        String[] parts2 = FileSystem.split(root);
        String relPath = FileSystem.makeRelative(parts1, parts2, filenameToMakeRelative.getName());
        if (appendCurrentDirectorySymbol) {
            return new File(".", relPath);
        }
        return new File(relPath);
    }

    @Pure
    public static File makeRelative(File filenameToMakeRelative, URL rootPath) throws IOException {
        if (filenameToMakeRelative == null || rootPath == null) {
            throw new IllegalArgumentException();
        }
        if (!filenameToMakeRelative.isAbsolute()) {
            return filenameToMakeRelative;
        }
        File dir = filenameToMakeRelative.getParentFile().getCanonicalFile();
        String[] parts1 = FileSystem.split(dir);
        String[] parts2 = FileSystem.split(rootPath);
        String relPath = FileSystem.makeRelative(parts1, parts2, filenameToMakeRelative.getName());
        return new File(".", relPath);
    }

    @Pure
    public static File makeRelative(URL filenameToMakeRelative, URL rootPath) throws IOException {
        if (filenameToMakeRelative == null || rootPath == null) {
            throw new IllegalArgumentException();
        }
        String basename = FileSystem.largeBasename(filenameToMakeRelative);
        URL dir = FileSystem.dirname(filenameToMakeRelative);
        String[] parts1 = FileSystem.split(dir);
        String[] parts2 = FileSystem.split(rootPath);
        String relPath = FileSystem.makeRelative(parts1, parts2, basename);
        return new File(".", relPath);
    }

    private static String makeRelative(String[] parts1, String[] parts2, String basename) {
        int firstDiff = -1;
        int i = 0;
        while (firstDiff < 0 && i < parts1.length && i < parts2.length) {
            if (!parts1[i].equals(parts2[i])) {
                firstDiff = i;
            }
            ++i;
        }
        StringBuilder result = new StringBuilder();
        if (firstDiff < 0) {
            firstDiff = Math.min(parts1.length, parts2.length);
        }
        int i2 = firstDiff;
        while (i2 < parts2.length) {
            if (result.length() > 0) {
                result.append(File.separator);
            }
            result.append(PARENT_DIRECTORY);
            ++i2;
        }
        i2 = firstDiff;
        while (i2 < parts1.length) {
            if (result.length() > 0) {
                result.append(File.separator);
            }
            result.append(parts1[i2]);
            ++i2;
        }
        if (result.length() > 0) {
            result.append(File.separator);
        }
        result.append(basename);
        return result.toString();
    }

    @Pure
    public static URL makeCanonicalURL(URL url) {
        if (url != null) {
            String[] pathComponents = url.getPath().split(Pattern.quote("/"));
            LinkedList<String> canonicalPath = new LinkedList<String>();
            String[] stringArray = pathComponents;
            int n = pathComponents.length;
            int n2 = 0;
            while (n2 < n) {
                String component = stringArray[n2];
                if (!".".equals(component)) {
                    if (PARENT_DIRECTORY.equals(component)) {
                        if (!canonicalPath.isEmpty()) {
                            canonicalPath.remove(canonicalPath.size() - 1);
                        } else {
                            canonicalPath.add(component);
                        }
                    } else {
                        canonicalPath.add(component);
                    }
                }
                ++n2;
            }
            StringBuilder newPathBuffer = new StringBuilder();
            boolean isFirst = true;
            for (String component : canonicalPath) {
                if (!isFirst) {
                    newPathBuffer.append('/');
                } else {
                    isFirst = false;
                }
                newPathBuffer.append(component);
            }
            try {
                return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), newPathBuffer.toString(), url.getQuery(), url.getRef()).toURL();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {}
            try {
                return new URL(url.getProtocol(), url.getHost(), newPathBuffer.toString());
            }
            catch (Throwable throwable) {}
        }
        return url;
    }

    public static void zipFile(File input, File output) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fos = new FileOutputStream(output);){
            FileSystem.zipFile(input, fos);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void zipFile(File input, OutputStream output) throws IOException {
        try (ZipOutputStream zos = null;){
            zos = new ZipOutputStream(output);
            if (input == null) {
                return;
            }
            LinkedList<File> candidates = new LinkedList<File>();
            candidates.add(input);
            byte[] buffer = new byte[4096];
            File rootDirectory = input.isDirectory() ? input : input.getParentFile();
            while (!candidates.isEmpty()) {
                String zipFilename;
                File file = (File)candidates.removeFirst();
                assert (file != null);
                File relativeFile = file.getAbsoluteFile().equals(rootDirectory.getAbsoluteFile()) ? null : FileSystem.makeRelative(file, rootDirectory, false);
                if (file.isDirectory()) {
                    if (relativeFile != null) {
                        zipFilename = String.valueOf(FileSystem.fromFileStandardToURLStandard(relativeFile)) + "/";
                        ZipEntry zipEntry = new ZipEntry(zipFilename);
                        zos.putNextEntry(zipEntry);
                        zos.closeEntry();
                    }
                    candidates.addAll(Arrays.asList(file.listFiles()));
                    continue;
                }
                if (relativeFile == null) continue;
                Throwable throwable = null;
                Object var11_12 = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    int len;
                    zipFilename = FileSystem.fromFileStandardToURLStandard(relativeFile);
                    ZipEntry zipEntry = new ZipEntry(zipFilename);
                    zos.putNextEntry(zipEntry);
                    while ((len = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    zos.closeEntry();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public static void unzipFile(InputStream input, File output) throws IOException {
        if (output == null) {
            return;
        }
        output.mkdirs();
        if (!output.isDirectory()) {
            throw new IOException(Locale.getString("E3", output));
        }
        try (ZipInputStream zis = null;){
            byte[] buffer = new byte[4096];
            zis = new ZipInputStream(input);
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                String name = zipEntry.getName();
                File outFile = new File(output, name).getCanonicalFile();
                if (zipEntry.isDirectory()) {
                    outFile.mkdirs();
                } else {
                    outFile.getParentFile().mkdirs();
                    Throwable throwable = null;
                    Object var9_10 = null;
                    try (FileOutputStream fos = new FileOutputStream(outFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                zipEntry = zis.getNextEntry();
            }
        }
    }

    public static void unzipFile(File input, File output) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fis = new FileInputStream(input);){
            FileSystem.unzipFile(fis, output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return FileSystem.createTempDirectory(prefix, suffix, null);
    }

    public static File createTempDirectory(String prefix, String suffix, File directory) throws IOException {
        StringBuilder buffer;
        File filename;
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException(Locale.getString("E4", 3, prefix));
        }
        String string = suffix == null ? ".tmp" : suffix;
        File targetDirectory = directory == null ? new File(System.getProperty("java.io.tmpdir")) : directory;
        do {
            long index;
            index = (index = RANDOM.nextLong()) == Long.MIN_VALUE ? 0L : Math.abs(index);
            buffer = new StringBuilder();
            buffer.append(prefix);
            buffer.append(Long.toString(index));
            buffer.append(string);
        } while (!(filename = new File(targetDirectory, buffer.toString())).mkdirs());
        return filename;
    }

    private static class DeleteOnExitHook
    extends Thread {
        private List<File> filesToDelete;

        DeleteOnExitHook() {
            this.setName("DeleteOnExitHook");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DeleteOnExitHook deleteOnExitHook = this;
            synchronized (deleteOnExitHook) {
                if (this.filesToDelete != null) {
                    for (File f : this.filesToDelete) {
                        try {
                            FileSystem.delete(f);
                        }
                        catch (IOException iOException) {}
                    }
                    this.filesToDelete.clear();
                    this.filesToDelete = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(File file) {
            assert (file != null);
            DeleteOnExitHook deleteOnExitHook = this;
            synchronized (deleteOnExitHook) {
                if (this.filesToDelete == null) {
                    this.filesToDelete = new LinkedList<File>();
                    Runtime.getRuntime().addShutdownHook(this);
                }
                this.filesToDelete.add(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(File file) {
            DeleteOnExitHook deleteOnExitHook = this;
            synchronized (deleteOnExitHook) {
                if (this.filesToDelete != null) {
                    this.filesToDelete.remove(file);
                    if (this.filesToDelete.isEmpty()) {
                        this.filesToDelete = null;
                        Runtime.getRuntime().removeShutdownHook(this);
                    }
                }
            }
        }
    }
}

