/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.arakhne.afc.vmutil.ClassLoaderFinder;
import org.arakhne.afc.vmutil.DynamicURLClassLoader;
import org.arakhne.afc.vmutil.FileSystem;
import org.eclipse.xtext.xbase.lib.Pure;

public final class ClasspathUtil {
    private ClasspathUtil() {
    }

    @Pure
    public static Iterator<URL> getStartClasspath() {
        return new PathIterator(System.getProperty("java.class.path"));
    }

    @Pure
    public static Iterator<URL> getClasspath() {
        Iterator<URL> iterator;
        block4: {
            iterator = ClasspathUtil.getStartClasspath();
            ClassLoader loader = ClassLoaderFinder.findClassLoader();
            try {
                DynamicURLClassLoader dLoader = (DynamicURLClassLoader)loader;
                iterator = new FilteringIterator(Arrays.asList(dLoader.getURLs()).iterator());
            }
            catch (ClassCastException classCastException) {
                if (ClasspathUtil.class.getClassLoader() == loader) break block4;
                try {
                    URLClassLoader dLoader = (URLClassLoader)loader;
                    iterator = new IteratorIterator(new FilteringIterator(Arrays.asList(dLoader.getURLs()).iterator()), iterator);
                }
                catch (ClassCastException classCastException2) {}
            }
        }
        return iterator;
    }

    private static class FilteringIterator
    implements Iterator<URL> {
        private final Iterator<URL> iterator;
        private URL next;

        FilteringIterator(Iterator<URL> iterator) {
            assert (iterator != null);
            this.iterator = iterator;
            this.searchNext();
        }

        private void searchNext() {
            this.next = null;
            while (this.next == null && this.iterator.hasNext()) {
                URL u = this.iterator.next();
                if (u == null) continue;
                this.next = u;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public URL next() {
            URL n = this.next;
            if (n == null) {
                throw new NoSuchElementException();
            }
            this.searchNext();
            return n;
        }
    }

    private static class IteratorIterator
    implements Iterator<URL> {
        private final Iterator<URL> i1;
        private final Iterator<URL> i2;

        IteratorIterator(Iterator<URL> i1, Iterator<URL> i2) {
            assert (i1 != null && i2 != null);
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i1.hasNext() || this.i2.hasNext();
        }

        @Override
        public URL next() {
            if (this.i1.hasNext()) {
                return this.i1.next();
            }
            return this.i2.next();
        }
    }

    private static class PathIterator
    implements Iterator<URL> {
        private String path;
        private URL next;
        private int nextIndex;

        PathIterator(String path) {
            this.path = path;
            this.nextIndex = -1;
            this.searchNext();
        }

        private void searchNext() {
            this.next = null;
            while (this.next == null && this.path != null && this.nextIndex < this.path.length()) {
                String path;
                int index = this.path.indexOf(File.pathSeparatorChar, this.nextIndex + 1);
                if (index > this.nextIndex + 1) {
                    path = this.path.substring(this.nextIndex + 1, index);
                } else {
                    path = this.path.substring(this.nextIndex + 1);
                    this.path = null;
                }
                this.nextIndex = index;
                if (path == null || "".equals(path)) continue;
                try {
                    URL url = FileSystem.convertStringToURL(path, false, true, false);
                    if (url == null) continue;
                    this.next = url;
                }
                catch (AssertionError e) {
                    throw e;
                }
                catch (Throwable throwable) {}
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public URL next() {
            URL n = this.next;
            if (n == null) {
                throw new NoSuchElementException();
            }
            this.searchNext();
            return n;
        }
    }
}

