/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.InputStream;
import java.net.URL;
import org.arakhne.afc.vmutil.Android;
import org.arakhne.afc.vmutil.ResourceWrapper;

class AndroidResourceWrapper
implements ResourceWrapper {
    AndroidResourceWrapper() {
    }

    private static String decodeResourceName(String resourceName) {
        if (resourceName.startsWith("/")) {
            return resourceName.substring(1);
        }
        return resourceName;
    }

    @Override
    public URL getResource(ClassLoader classLoader, String path) {
        String resourceName = AndroidResourceWrapper.decodeResourceName(path);
        try {
            ClassLoader androidClassLoader = Android.getContextClassLoader();
            assert (androidClassLoader != null);
            URL url = androidClassLoader.getResource(resourceName);
            if (url != null) {
                return url;
            }
        }
        catch (Android.AndroidException androidException) {}
        if (classLoader != null) {
            return classLoader.getResource(resourceName);
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(ClassLoader classLoader, String path) {
        String resourceName = AndroidResourceWrapper.decodeResourceName(path);
        try {
            ClassLoader androidClassLoader = Android.getContextClassLoader();
            assert (androidClassLoader != null);
            InputStream stream = androidClassLoader.getResourceAsStream(resourceName);
            if (stream != null) {
                return stream;
            }
        }
        catch (Android.AndroidException androidException) {}
        if (classLoader != null) {
            return classLoader.getResourceAsStream(resourceName);
        }
        return null;
    }

    @Override
    public String translateResourceName(String resourceName) {
        return resourceName.replaceAll("[.]", "/");
    }
}

