/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.arakhne.afc.sizediterator.ArraySizedIterator;
import org.arakhne.afc.sizediterator.SizedIterator;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> void reverse(T[] tab) {
        int i = 0;
        while (i < tab.length / 2) {
            T tmp = tab[i];
            tab[i] = tab[tab.length - i - 1];
            tab[tab.length - i - 1] = tmp;
            ++i;
        }
    }

    @Pure
    public static <T> T[] toArray(Collection<? extends T> collection, Class<T> clazz) {
        int size = collection == null ? 0 : collection.size();
        T[] tab = ArrayUtil.newInstance(clazz, size);
        if (collection != null && size > 0) {
            collection.toArray(tab);
        }
        return tab;
    }

    public static <T> T[] toArrayAndClear(Collection<? extends T> collection, Class<T> clazz) {
        T[] tab = ArrayUtil.toArray(collection, clazz);
        collection.clear();
        return tab;
    }

    @Pure
    public static <T> T[] merge(Class<T> clazz, T[] ... arrays) {
        int length = 0;
        T[][] TArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            T[] tab = TArray[n2];
            if (tab != null) {
                length += tab.length;
            }
            ++n2;
        }
        T[] result = ArrayUtil.newInstance(clazz, length);
        int i = 0;
        T[][] TArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            T[] tab = TArray2[n4];
            if (tab != null) {
                System.arraycopy(tab, 0, result, i, tab.length);
                i += tab.length;
            }
            ++n4;
        }
        return result;
    }

    @Pure
    public static <T> T[] merge(Class<T> clazz, T ... elements) {
        T[] result = ArrayUtil.newInstance(clazz, elements.length);
        System.arraycopy(elements, 0, result, 0, elements.length);
        return result;
    }

    @Pure
    public static <T> T[] merge(Class<T> clazz, T[] source, T ... elements) {
        T[] result = ArrayUtil.newInstance(clazz, source.length + elements.length);
        System.arraycopy(source, 0, result, 0, source.length);
        System.arraycopy(elements, 0, result, source.length, elements.length);
        return result;
    }

    @Pure
    @Inline(value="ArrayUtil.mergeWithoutNull($1, $2)", imported={ArrayUtil.class})
    @Deprecated
    public static <T> T[] merge_without_null(Class<T> clazz, T[] ... arrays) {
        return ArrayUtil.mergeWithoutNull(clazz, arrays);
    }

    @Pure
    @Inline(value="ArrayUtil.mergeWithoutNull($1, $2)", imported={ArrayUtil.class})
    @Deprecated
    public static <T> T[] merge_without_null(Class<T> clazz, T ... elements) {
        return ArrayUtil.mergeWithoutNull(clazz, elements);
    }

    @Pure
    @Inline(value="ArrayUtil.mergeWithoutNull($1, $2, $3)", imported={ArrayUtil.class})
    @Deprecated
    public static <T> T[] merge_without_null(Class<T> clazz, T[] source, T ... elements) {
        return ArrayUtil.mergeWithoutNull(clazz, source, elements);
    }

    @Pure
    public static <T> T[] mergeWithoutNull(Class<T> clazz, T[] ... arrays) {
        int length = 0;
        T[][] TArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            T[] tab = TArray[n2];
            if (tab != null) {
                T[] TArray2 = tab;
                int n3 = tab.length;
                int n4 = 0;
                while (n4 < n3) {
                    T t = TArray2[n4];
                    if (t != null) {
                        ++length;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        T[] result = ArrayUtil.newInstance(clazz, length);
        int i = 0;
        T[][] TArray3 = arrays;
        int n5 = arrays.length;
        int n6 = 0;
        while (n6 < n5) {
            T[] tab = TArray3[n6];
            if (tab != null) {
                T[] TArray4 = tab;
                int n7 = tab.length;
                int n8 = 0;
                while (n8 < n7) {
                    T t = TArray4[n8];
                    if (t != null) {
                        result[i] = t;
                        ++i;
                    }
                    ++n8;
                }
            }
            ++n6;
        }
        return result;
    }

    @Pure
    public static <T> T[] mergeWithoutNull(Class<T> clazz, T ... elements) {
        int nbNotNull = 0;
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t != null) {
                ++nbNotNull;
            }
            ++n2;
        }
        T[] result = ArrayUtil.newInstance(clazz, nbNotNull);
        int i = 0;
        T[] TArray2 = elements;
        int n3 = elements.length;
        int n4 = 0;
        while (n4 < n3) {
            T t = TArray2[n4];
            if (t != null) {
                result[i++] = t;
            }
            ++n4;
        }
        return result;
    }

    @Pure
    public static <T> T[] mergeWithoutNull(Class<T> clazz, T[] source, T ... elements) {
        T t;
        int nbNotNull = 0;
        T[] TArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            t = TArray[n2];
            if (t != null) {
                ++nbNotNull;
            }
            ++n2;
        }
        TArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            t = TArray[n2];
            if (t != null) {
                ++nbNotNull;
            }
            ++n2;
        }
        T[] result = ArrayUtil.newInstance(clazz, nbNotNull);
        int i = 0;
        T[] TArray2 = source;
        int n3 = source.length;
        int n4 = 0;
        while (n4 < n3) {
            T t2 = TArray2[n4];
            if (t2 != null) {
                result[i++] = t2;
            }
            ++n4;
        }
        TArray2 = elements;
        n3 = elements.length;
        n4 = 0;
        while (n4 < n3) {
            T t3 = TArray2[n4];
            if (t3 != null) {
                result[i++] = t3;
            }
            ++n4;
        }
        return result;
    }

    @Pure
    public static <T> T[] removeElements(Class<T> clazz, T[] source, T ... toRemove) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(Arrays.asList(source));
        T[] TArray = toRemove;
        int n = toRemove.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            list.remove(t);
            ++n2;
        }
        return ArrayUtil.toArrayAndClear(list, clazz);
    }

    @Pure
    public static <I, T> T[] castArray(I[] originalArray, Class<T> clazz) {
        int size = originalArray == null ? 0 : originalArray.length;
        T[] result = ArrayUtil.newInstance(clazz, size);
        if (originalArray != null && size > 0) {
            int index = 0;
            I[] IArray = originalArray;
            int n = originalArray.length;
            int n2 = 0;
            while (n2 < n) {
                I to = IArray[n2];
                result[index] = clazz.isInstance(to) ? clazz.cast(to) : null;
                ++index;
                ++n2;
            }
        }
        return result;
    }

    @Pure
    public static <I, O> O[] castArray(Collection<I> originalArray, Class<O> clazz) {
        int size = originalArray == null ? 0 : originalArray.size();
        O[] result = ArrayUtil.newInstance(clazz, size);
        if (originalArray != null && size > 0) {
            int index = 0;
            for (I to : originalArray) {
                result[index] = clazz.isInstance(to) ? clazz.cast(to) : null;
                ++index;
            }
        }
        return result;
    }

    @Pure
    public static <T> T[] restrictArray(T[] originalArray, Class<T> clazz, Filter<T> comparator) {
        int size = originalArray == null ? 0 : originalArray.length;
        ArrayList<T> result = new ArrayList<T>();
        if (originalArray != null && size > 0) {
            T[] TArray = originalArray;
            int n = originalArray.length;
            int n2 = 0;
            while (n2 < n) {
                T to = TArray[n2];
                if (comparator.filter(to)) {
                    result.add(to);
                }
                ++n2;
            }
        }
        return ArrayUtil.toArrayAndClear(result, clazz);
    }

    @Pure
    public static <I, O> O[] castRestrictedArray(I[] originalArray, Class<O> clazz) {
        int size = originalArray == null ? 0 : originalArray.length;
        ArrayList<I> result = new ArrayList<I>();
        if (originalArray != null && size > 0) {
            I[] IArray = originalArray;
            int n = originalArray.length;
            int n2 = 0;
            while (n2 < n) {
                I to = IArray[n2];
                if (clazz.isInstance(to)) {
                    result.add(to);
                }
                ++n2;
            }
        }
        return ArrayUtil.toArrayAndClear(result, clazz);
    }

    @Pure
    public static <I, O> O[] castRestrictedArray(Collection<I> originalArray, Class<O> clazz) {
        int size = originalArray == null ? 0 : originalArray.size();
        ArrayList<I> result = new ArrayList<I>();
        if (originalArray != null && size > 0) {
            for (I to : originalArray) {
                if (!clazz.isInstance(to)) continue;
                result.add(to);
            }
        }
        return ArrayUtil.toArrayAndClear(result, clazz);
    }

    @Pure
    public static <T> boolean containsObject(T elt, T[] array) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t == elt) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Pure
    public static <T> boolean containsAllObjects(T[] elts, T[] array) {
        T[] TArray = elts;
        int n = elts.length;
        int n2 = 0;
        while (n2 < n) {
            T elt = TArray[n2];
            boolean found = false;
            T[] TArray2 = array;
            int n3 = array.length;
            int n4 = 0;
            while (n4 < n3) {
                T t = TArray2[n4];
                if (t == elt) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Pure
    public static <T> boolean contains(T elt, T ... array) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t == elt || t != null && t.equals(elt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Pure
    public static <T> boolean contains(Comparator<T> comparator, T elt, T ... array) {
        assert (comparator != null);
        assert (elt != null);
        assert (array != null);
        int first = 0;
        int last = array.length - 1;
        while (last >= first) {
            int center = (first + last) / 2;
            T indata = array[center];
            int cmp = comparator.compare(elt, indata);
            if (cmp == 0) {
                return true;
            }
            if (cmp < 0) {
                last = center - 1;
                continue;
            }
            first = center + 1;
        }
        return false;
    }

    @Pure
    public static <T> boolean containsAll(T[] elts, T[] array) {
        T[] TArray = elts;
        int n = elts.length;
        int n2 = 0;
        while (n2 < n) {
            T elt = TArray[n2];
            boolean found = false;
            T[] TArray2 = array;
            int n3 = array.length;
            int n4 = 0;
            while (n4 < n3) {
                T t = TArray2[n4];
                if (t == elt || t != null && t.equals(elt)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Pure
    public static <T> boolean intersects(T[] elts, T[] array) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            T[] TArray2 = elts;
            int n3 = elts.length;
            int n4 = 0;
            while (n4 < n3) {
                T elt = TArray2[n4];
                if (elt == t || t != null && t.equals(elt)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @Pure
    public static <T> T[] newInstance(Class<T> clazz, int size) {
        if (size < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(size) + "<0");
        }
        return (Object[])Array.newInstance(clazz, size);
    }

    @Pure
    @Inline(value="ArrayUtil.shuffle($1, new Random())", imported={ArrayUtil.class, Random.class}, statementExpression=true)
    public static <T> void shuffle(T[] array) {
        ArrayUtil.shuffle(array, new Random());
    }

    @Pure
    public static <T> void shuffle(T[] array, Random rnd) {
        int i = array.length;
        while (i > 1) {
            int ir = rnd.nextInt(i);
            T tmp = array[i - 1];
            array[i - 1] = array[ir];
            array[ir] = tmp;
            --i;
        }
    }

    @Pure
    @Inline(value="ArrayUtil.shuffle($1, new Random())", imported={ArrayUtil.class, Random.class}, statementExpression=true)
    public static void shuffle(boolean[] array) {
        ArrayUtil.shuffle(array, new Random());
    }

    @Pure
    public static void shuffle(boolean[] array, Random rnd) {
        int i = array.length;
        while (i > 1) {
            int ir = rnd.nextInt(i);
            boolean tmp = array[i - 1];
            array[i - 1] = array[ir];
            array[ir] = tmp;
            --i;
        }
    }

    @Pure
    @Inline(value="ArrayUtil.shuffle($1, new Random())", imported={ArrayUtil.class, Random.class}, statementExpression=true)
    public static void shuffle(byte[] array) {
        ArrayUtil.shuffle(array, new Random());
    }

    @Pure
    public static void shuffle(byte[] array, Random rnd) {
        int i = array.length;
        while (i > 1) {
            int ir = rnd.nextInt(i);
            byte tmp = array[i - 1];
            array[i - 1] = array[ir];
            array[ir] = tmp;
            --i;
        }
    }

    @Pure
    @Inline(value="ArrayUtil.shuffle($1, new Random())", imported={ArrayUtil.class, Random.class}, statementExpression=true)
    public static void shuffle(char[] array) {
        ArrayUtil.shuffle(array, new Random());
    }

    @Pure
    public static void shuffle(char[] array, Random rnd) {
        int i = array.length;
        while (i > 1) {
            int ir = rnd.nextInt(i);
            char tmp = array[i - 1];
            array[i - 1] = array[ir];
            array[ir] = tmp;
            --i;
        }
    }

    @Pure
    @Inline(value="ArrayUtil.shuffle($1, new Random())", imported={ArrayUtil.class, Random.class}, statementExpression=true)
    public static void shuffle(int[] array) {
        ArrayUtil.shuffle(array, new Random());
    }

    @Pure
    public static void shuffle(int[] array, Random rnd) {
        int i = array.length;
        while (i > 1) {
            int ir = rnd.nextInt(i);
            int tmp = array[i - 1];
            array[i - 1] = array[ir];
            array[ir] = tmp;
            --i;
        }
    }

    @Pure
    @Inline(value="ArrayUtil.shuffle($1, new Random())", imported={ArrayUtil.class, Random.class}, statementExpression=true)
    public static void shuffle(long[] array) {
        ArrayUtil.shuffle(array, new Random());
    }

    @Pure
    public static void shuffle(long[] array, Random rnd) {
        int i = array.length;
        while (i > 1) {
            int ir = rnd.nextInt(i);
            long tmp = array[i - 1];
            array[i - 1] = array[ir];
            array[ir] = tmp;
            --i;
        }
    }

    @Pure
    @Inline(value="ArrayUtil.shuffle($1, new Random())", imported={ArrayUtil.class, Random.class}, statementExpression=true)
    public static void shuffle(float[] array) {
        ArrayUtil.shuffle(array, new Random());
    }

    @Pure
    public static void shuffle(float[] array, Random rnd) {
        int i = array.length;
        while (i > 1) {
            int ir = rnd.nextInt(i);
            float tmp = array[i - 1];
            array[i - 1] = array[ir];
            array[ir] = tmp;
            --i;
        }
    }

    @Pure
    @Inline(value="ArrayUtil.shuffle($1, new Random())", imported={ArrayUtil.class, Random.class}, statementExpression=true)
    public static void shuffle(double[] array) {
        ArrayUtil.shuffle(array, new Random());
    }

    @Pure
    public static void shuffle(double[] array, Random rnd) {
        int i = array.length;
        while (i > 1) {
            int ir = rnd.nextInt(i);
            double tmp = array[i - 1];
            array[i - 1] = array[ir];
            array[ir] = tmp;
            --i;
        }
    }

    @Pure
    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof Object[]) {
            return Arrays.toString((Object[])obj);
        }
        return obj.toString();
    }

    @Pure
    @Inline(value="new ArraySizedIterator<>($1)", imported={ArraySizedIterator.class})
    public static <T> SizedIterator<T> sizedIterator(T[] array) {
        return new ArraySizedIterator<T>(array);
    }

    @Pure
    public static SizedIterator<Character> sizedIterator(char[] array) {
        return new NativeCharacterToObjectCharacterIterator(array);
    }

    @Pure
    public static SizedIterator<Byte> sizedIterator(byte[] array) {
        return new NativeByteToObjectByteIterator(array);
    }

    @Pure
    public static SizedIterator<Short> sizedIterator(short[] array) {
        return new NativeShortToObjectShortIterator(array);
    }

    @Pure
    public static SizedIterator<Integer> sizedIterator(int[] array) {
        return new NativeIntegerToObjectIntegerIterator(array);
    }

    @Pure
    public static SizedIterator<Long> sizedIterator(long[] array) {
        return new NativeLongToObjectLongIterator(array);
    }

    @Pure
    public static SizedIterator<Float> sizedIterator(float[] array) {
        return new NativeFloatToObjectFloatIterator(array);
    }

    @Pure
    public static SizedIterator<Double> sizedIterator(double[] array) {
        return new NativeDoubleToObjectDoubleIterator(array);
    }

    @Pure
    public static SizedIterator<Boolean> sizedIterator(boolean[] array) {
        return new NativeBooleanToObjectBooleanIterator(array);
    }

    @Pure
    @Inline(value="new ArraySizedIterator<>($1)", imported={ArraySizedIterator.class})
    public static <T> Iterator<T> iterator(T[] array) {
        return new ArraySizedIterator<T>(array);
    }

    @Pure
    public static Iterator<Boolean> iterator(boolean[] array) {
        return new NativeBooleanToObjectBooleanIterator(array);
    }

    @Pure
    public static Iterator<Character> iterator(char[] array) {
        return new NativeCharacterToObjectCharacterIterator(array);
    }

    @Pure
    public static Iterator<Byte> iterator(byte[] array) {
        return new NativeByteToObjectByteIterator(array);
    }

    @Pure
    public static Iterator<Short> iterator(short[] array) {
        return new NativeShortToObjectShortIterator(array);
    }

    @Pure
    public static Iterator<Integer> iterator(int[] array) {
        return new NativeIntegerToObjectIntegerIterator(array);
    }

    @Pure
    public static Iterator<Long> iterator(long[] array) {
        return new NativeLongToObjectLongIterator(array);
    }

    @Pure
    public static Iterator<Float> iterator(float[] array) {
        return new NativeFloatToObjectFloatIterator(array);
    }

    @Pure
    public static Iterator<Double> iterator(double[] array) {
        return new NativeDoubleToObjectDoubleIterator(array);
    }

    public static interface Filter<T> {
        @Pure
        public boolean filter(T var1);
    }

    private static class NativeBooleanToObjectBooleanIterator
    implements SizedIterator<Boolean> {
        private final boolean[] array;
        private int idx;

        NativeBooleanToObjectBooleanIterator(boolean[] data) {
            this.array = data;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.idx >= 0 && this.idx < this.array.length;
        }

        @Override
        public Boolean next() {
            if (this.array != null && this.idx >= 0 && this.idx < this.array.length) {
                Boolean b = this.array[this.idx];
                ++this.idx;
                return b;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int totalSize() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        public int index() {
            return this.idx - 1;
        }

        @Override
        public int rest() {
            return this.totalSize() - (this.index() + 1);
        }
    }

    private static class NativeByteToObjectByteIterator
    implements SizedIterator<Byte> {
        private final byte[] array;
        private int idx;

        NativeByteToObjectByteIterator(byte[] data) {
            this.array = data;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.idx >= 0 && this.idx < this.array.length;
        }

        @Override
        public Byte next() {
            if (this.array != null && this.idx >= 0 && this.idx < this.array.length) {
                Byte b = this.array[this.idx];
                ++this.idx;
                return b;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int totalSize() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        public int index() {
            return this.idx - 1;
        }

        @Override
        public int rest() {
            return this.totalSize() - (this.index() + 1);
        }
    }

    private static class NativeCharacterToObjectCharacterIterator
    implements SizedIterator<Character> {
        private final char[] array;
        private int idx;

        NativeCharacterToObjectCharacterIterator(char[] data) {
            this.array = data;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.idx >= 0 && this.idx < this.array.length;
        }

        @Override
        public Character next() {
            if (this.array != null && this.idx >= 0 && this.idx < this.array.length) {
                Character c = Character.valueOf(this.array[this.idx]);
                ++this.idx;
                return c;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int totalSize() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        public int index() {
            return this.idx - 1;
        }

        @Override
        public int rest() {
            return this.totalSize() - (this.index() + 1);
        }
    }

    private static class NativeDoubleToObjectDoubleIterator
    implements SizedIterator<Double> {
        private final double[] array;
        private int idx;

        NativeDoubleToObjectDoubleIterator(double[] data) {
            this.array = data;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.idx >= 0 && this.idx < this.array.length;
        }

        @Override
        public Double next() {
            if (this.array != null && this.idx >= 0 && this.idx < this.array.length) {
                Double d = this.array[this.idx];
                ++this.idx;
                return d;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int totalSize() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        public int index() {
            return this.idx - 1;
        }

        @Override
        public int rest() {
            return this.totalSize() - (this.index() + 1);
        }
    }

    private static class NativeFloatToObjectFloatIterator
    implements SizedIterator<Float> {
        private final float[] array;
        private int idx;

        NativeFloatToObjectFloatIterator(float[] data) {
            this.array = data;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.idx >= 0 && this.idx < this.array.length;
        }

        @Override
        public Float next() {
            if (this.array != null && this.idx >= 0 && this.idx < this.array.length) {
                Float f = Float.valueOf(this.array[this.idx]);
                ++this.idx;
                return f;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int totalSize() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        public int index() {
            return this.idx - 1;
        }

        @Override
        public int rest() {
            return this.totalSize() - (this.index() + 1);
        }
    }

    private static class NativeIntegerToObjectIntegerIterator
    implements SizedIterator<Integer> {
        private final int[] array;
        private int idx;

        NativeIntegerToObjectIntegerIterator(int[] data) {
            this.array = data;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.idx >= 0 && this.idx < this.array.length;
        }

        @Override
        public Integer next() {
            if (this.array != null && this.idx >= 0 && this.idx < this.array.length) {
                Integer f = this.array[this.idx];
                ++this.idx;
                return f;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int totalSize() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        public int index() {
            return this.idx - 1;
        }

        @Override
        public int rest() {
            return this.totalSize() - (this.index() + 1);
        }
    }

    private static class NativeLongToObjectLongIterator
    implements SizedIterator<Long> {
        private final long[] array;
        private int idx;

        NativeLongToObjectLongIterator(long[] data) {
            this.array = data;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.idx >= 0 && this.idx < this.array.length;
        }

        @Override
        public Long next() {
            if (this.array != null && this.idx >= 0 && this.idx < this.array.length) {
                Long l = this.array[this.idx];
                ++this.idx;
                return l;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int totalSize() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        public int index() {
            return this.idx - 1;
        }

        @Override
        public int rest() {
            return this.totalSize() - (this.index() + 1);
        }
    }

    private static class NativeShortToObjectShortIterator
    implements SizedIterator<Short> {
        private final short[] array;
        private int idx;

        NativeShortToObjectShortIterator(short[] data) {
            this.array = data;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.idx >= 0 && this.idx < this.array.length;
        }

        @Override
        public Short next() {
            if (this.array != null && this.idx >= 0 && this.idx < this.array.length) {
                Short s = this.array[this.idx];
                ++this.idx;
                return s;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int totalSize() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        public int index() {
            return this.idx - 1;
        }

        @Override
        public int rest() {
            return this.totalSize() - (this.index() + 1);
        }
    }
}

