/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.sizediterator;

import java.util.Collection;
import java.util.Iterator;
import org.arakhne.afc.sizediterator.ModifiableCollectionSizedIteratorOwner;
import org.arakhne.afc.sizediterator.SizedIterator;
import org.eclipse.xtext.xbase.lib.Pure;

public class ModifiableCollectionSizedIterator<M>
implements SizedIterator<M> {
    private final ModifiableCollectionSizedIteratorOwner<M> owner;
    private int total;
    private int rest;
    private final Iterator<M> iterator;
    private M lastReplied;

    public ModifiableCollectionSizedIterator(Collection<M> collection) {
        this(collection, null);
    }

    public ModifiableCollectionSizedIterator(Collection<M> collection, ModifiableCollectionSizedIteratorOwner<M> owner) {
        assert (collection != null);
        this.owner = owner;
        this.rest = this.total = collection.size();
        this.iterator = collection.iterator();
    }

    @Override
    @Pure
    public int rest() {
        return this.rest;
    }

    @Override
    @Pure
    public int index() {
        return this.total - this.rest;
    }

    @Override
    @Pure
    public int totalSize() {
        return this.total;
    }

    @Override
    @Pure
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public M next() {
        M elt = this.iterator.next();
        --this.rest;
        this.lastReplied = elt;
        return elt;
    }

    @Override
    public void remove() {
        this.iterator.remove();
        M data = this.lastReplied;
        this.lastReplied = null;
        --this.total;
        --this.rest;
        if (data != null && this.owner != null) {
            this.owner.onRemoveFromIterator(data);
        }
    }
}

