/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.sizediterator;

import java.util.NoSuchElementException;
import org.arakhne.afc.sizediterator.SizedIterator;
import org.eclipse.xtext.xbase.lib.Pure;

public class ArraySizedIterator<OBJECT>
implements SizedIterator<OBJECT> {
    private final OBJECT[] array;
    private final int length;
    private int index;
    private OBJECT next;
    private int nextIndex;

    public ArraySizedIterator(OBJECT[] array) {
        this.array = array;
        this.length = array != null ? array.length : 0;
        this.searchNext();
    }

    private void searchNext() {
        this.next = null;
        while (this.index >= 0 && this.index < this.length) {
            OBJECT obj;
            if ((obj = this.array[this.index++]) == null) continue;
            this.next = obj;
            return;
        }
        this.index = -1;
    }

    @Override
    @Pure
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public OBJECT next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        OBJECT obj = this.next;
        this.nextIndex = this.index - 1;
        this.searchNext();
        return obj;
    }

    @Override
    @Pure
    public int index() {
        if (this.nextIndex < 0) {
            throw new NoSuchElementException();
        }
        return this.nextIndex;
    }

    @Override
    @Pure
    public int totalSize() {
        return this.length;
    }

    @Override
    @Pure
    public int rest() {
        return this.length - this.nextIndex;
    }
}

