/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.progress;

import org.arakhne.afc.progress.Progression;
import org.arakhne.afc.progress.SubProgressionModel;

public final class ProgressionUtil {
    private ProgressionUtil() {
    }

    public static void init(Progression model, int value, int min, int max, boolean isAdjusting, boolean isInderterminate) {
        if (model != null) {
            model.setProperties(value, min, max, isAdjusting);
            model.setIndeterminate(isInderterminate);
        }
    }

    public static void init(Progression model, int min, int max, boolean isAdjusting) {
        if (model != null) {
            model.setProperties(min, min, max, isAdjusting);
        }
    }

    public static void init(Progression model, int min, int max) {
        if (model != null) {
            model.setProperties(min, min, max, false);
        }
    }

    public static void init(Progression model, int value, int min, int max, boolean isAdjusting, boolean isInderterminate, String comment) {
        if (model != null) {
            model.setProperties(value, min, max, isAdjusting, comment);
            model.setIndeterminate(isInderterminate);
        }
    }

    public static void init(Progression model, int min, int max, boolean isAdjusting, String comment) {
        if (model != null) {
            model.setProperties(min, min, max, isAdjusting, comment);
        }
    }

    public static void init(Progression model, int min, int max, String comment) {
        if (model != null) {
            model.setProperties(min, min, max, false, comment);
        }
    }

    public static Progression sub(Progression model, int extent) {
        if (model != null) {
            return model.subTask(extent);
        }
        return null;
    }

    public static Progression sub(Progression model, int extent, boolean overwriteComment) {
        if (model != null) {
            return model.subTask(extent, overwriteComment);
        }
        return null;
    }

    public static Progression subToEnd(Progression model) {
        if (model != null) {
            return model.subTask(model.getMaximum() - model.getValue());
        }
        return null;
    }

    public static Progression subToEnd(Progression model, boolean overwriteComment) {
        if (model != null) {
            return model.subTask(model.getMaximum() - model.getValue(), overwriteComment);
        }
        return null;
    }

    public static void advance(Progression model, int value) {
        if (model != null && value > 0) {
            double base;
            SubProgressionModel sub = (SubProgressionModel)model.getSubTask();
            if (sub == null) {
                base = model.getValue();
            } else {
                base = sub.getMinInParent();
                model.ensureNoSubTask();
            }
            model.setValue((int)base + value);
        }
    }

    public static void advance(Progression model) {
        ProgressionUtil.advance(model, 1);
    }

    public static void advance(Progression model, int value, String comment) {
        if (model != null && value > 0) {
            model.setValue(model.getValue() + value, comment);
        }
    }

    public static void advance(Progression model, String comment) {
        ProgressionUtil.advance(model, 1, comment);
    }

    public static int getValue(Progression model) {
        if (model != null) {
            return model.getValue();
        }
        return 0;
    }

    public static int getValueToEnd(Progression model) {
        if (model != null) {
            return model.getMaximum() - model.getValue();
        }
        return 0;
    }

    public static double getPercent(Progression model) {
        if (model != null) {
            return model.getPercent();
        }
        return Double.NaN;
    }

    public static void setValue(Progression model, int value) {
        if (model != null && value > model.getValue()) {
            model.setValue(value);
        }
    }

    public static void setValue(Progression model, int value, String comment) {
        if (model != null && value > model.getValue()) {
            model.setValue(value, comment);
        }
    }

    public static void end(Progression model) {
        if (model != null) {
            model.end();
            model.setComment(null);
        }
    }

    public static void ensureNoSubTask(Progression model) {
        if (model != null) {
            model.ensureNoSubTask();
        }
    }

    public static boolean isMinValue(Progression model) {
        if (model != null) {
            return model.getValue() <= model.getMinimum();
        }
        return true;
    }
}

