/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.progress;

import java.lang.ref.WeakReference;
import java.text.NumberFormat;
import java.util.logging.Logger;
import org.arakhne.afc.progress.DefaultProgression;
import org.arakhne.afc.progress.Progression;
import org.arakhne.afc.progress.ProgressionEvent;
import org.arakhne.afc.progress.ProgressionListener;

public class ProgressionConsoleMonitor
implements ProgressionListener {
    private final NumberFormat numberFormat;
    private Progression model = new DefaultProgression();
    private Logger logger;
    private int previousValue;

    public ProgressionConsoleMonitor() {
        this.numberFormat = NumberFormat.getPercentInstance();
        this.numberFormat.setMaximumFractionDigits(0);
        this.logger = null;
        this.previousValue = this.model.getValue();
        this.model.addProgressionListener(new WeakListener(this, this.model));
    }

    public Progression getModel() {
        return this.model;
    }

    public void setModel(Progression model) {
        this.model.removeProgressionListener(new WeakListener(this, this.model));
        this.model = model == null ? new DefaultProgression() : model;
        this.previousValue = this.model.getValue();
        this.model.addProgressionListener(new WeakListener(this, this.model));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void onProgressionValueChanged(ProgressionEvent event) {
        if (!event.isIndeterminate() && event.getValue() != this.previousValue) {
            this.previousValue = event.getValue();
            String message = this.buildMessage(event.getProgressionFactor(), event.getComment(), event.isRoot(), event.isFinished(), this.numberFormat);
            if (this.logger == null) {
                System.out.println(message);
            } else {
                this.logger.info(message);
            }
        }
    }

    protected String buildMessage(double progress, String comment, boolean isRoot, boolean isFinished, NumberFormat numberFormat) {
        StringBuilder txt = new StringBuilder();
        txt.append('[');
        txt.append(numberFormat.format(progress));
        txt.append("] ");
        if (comment != null) {
            txt.append(comment);
        }
        return txt.toString();
    }

    private static class WeakListener
    implements ProgressionListener {
        private final WeakReference<ProgressionListener> listener;
        private final WeakReference<Progression> model;

        WeakListener(ProgressionListener listener, Progression model) {
            this.listener = new WeakReference<ProgressionListener>(listener);
            this.model = new WeakReference<Progression>(model);
        }

        @Override
        public void onProgressionValueChanged(ProgressionEvent event) {
            ProgressionListener list = (ProgressionListener)this.listener.get();
            if (list != null) {
                list.onProgressionValueChanged(event);
            } else {
                this.removeListener();
            }
        }

        @Override
        public void onProgressionStateChanged(ProgressionEvent event) {
            ProgressionListener list = (ProgressionListener)this.listener.get();
            if (list != null) {
                list.onProgressionStateChanged(event);
            } else {
                this.removeListener();
            }
        }

        private void removeListener() {
            Progression prog = (Progression)this.model.get();
            if (prog != null) {
                prog.removeProgressionListener(this);
            }
        }
    }
}

