/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.Address;
import java.io.Serializable;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Pure;

public abstract class Event
implements Serializable {
    private static final long serialVersionUID = -4314428111329600890L;
    private Address source;

    public Event() {
    }

    public Event(Address source) {
        this.source = source;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass().equals(obj.getClass())) {
            Event event = (Event)obj;
            return this.source == null && event.source == null || this.source != null && this.source.equals(event.source);
        }
        return false;
    }

    @Pure
    public int hashCode() {
        int hash = 31 + this.getClass().hashCode();
        if (this.source != null) {
            hash = hash * 31 + this.source.hashCode();
        }
        return hash;
    }

    @Pure
    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    @Pure
    protected String attributesToString() {
        StringBuilder result = new StringBuilder();
        result.append("source = ");
        result.append(this.source);
        return result.toString();
    }

    @Pure
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + this.attributesToString() + "]";
    }

    @Pure
    public boolean isFrom(Address address) {
        return address != null && address.equals(this.getSource());
    }

    @Pure
    public boolean isFrom(UUID entityId) {
        Address iSource = this.getSource();
        return entityId != null && iSource != null && entityId.equals(iSource.getUUID());
    }
}

