/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Skill;
import java.lang.ref.WeakReference;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

abstract class AgentTrait {
    private WeakReference<Agent> agentRef;

    AgentTrait(Agent agent) {
        this.agentRef = new WeakReference<Agent>(agent);
    }

    AgentTrait() {
        this.agentRef = new WeakReference<Object>(null);
    }

    @Pure
    protected String attributesToString() {
        StringBuilder result = new StringBuilder();
        result.append("owner = ");
        result.append(this.getOwner());
        return result.toString();
    }

    @Pure
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + this.attributesToString() + "]";
    }

    void setOwner(Agent agent) {
        this.agentRef = new WeakReference<Agent>(agent);
    }

    @Pure
    protected Agent getOwner() {
        return (Agent)this.agentRef.get();
    }

    @Pure
    protected <S extends Capacity> S getSkill(Class<S> capacity) {
        return this.getOwner().getSkill(capacity);
    }

    @Inline(value="$setSkill($2, $1)")
    protected <S extends Skill> void operator_mappedTo(Class<? extends Capacity> capacity, S skill) {
        this.setSkill(skill, capacity);
    }

    @SafeVarargs
    @Inline(value="$setSkill($1, $2)")
    protected final <S extends Skill> S setSkill(S skill, Class<? extends Capacity> ... capacities) {
        return this.$setSkill(skill, capacities);
    }

    protected <S extends Skill> S $setSkill(S skill, Class<? extends Capacity> ... capacities) {
        return this.getOwner().$setSkill(skill, capacities);
    }

    protected <S extends Capacity> S clearSkill(Class<S> capacity) {
        return this.getOwner().clearSkill(capacity);
    }
}

