/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.SpaceID;
import java.io.Serializable;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Pure;

public class Address
implements Serializable,
Comparable<Address> {
    private static final long serialVersionUID = 1519844913685586094L;
    private final UUID agentId;
    private final SpaceID spaceId;

    public Address(SpaceID spaceId, UUID agentId) {
        assert (agentId != null);
        assert (spaceId != null);
        this.agentId = agentId;
        this.spaceId = spaceId;
    }

    @Pure
    public String toString() {
        return "Address [agentId=" + this.agentId + ", spaceId=" + this.spaceId + "]";
    }

    @Pure
    public UUID getUUID() {
        return this.agentId;
    }

    @Pure
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.agentId == null ? 0 : this.agentId.hashCode());
        result = 31 * result + (this.spaceId == null ? 0 : this.spaceId.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            return this.equals((Address)obj);
        }
        return false;
    }

    @Pure
    public boolean equals(Address address) {
        return address != null && this.spaceId.equals(address.getSpaceId()) && this.agentId.equals(address.getUUID());
    }

    @Override
    @Pure
    public int compareTo(Address address) {
        if (address == null) {
            return 1;
        }
        return this.agentId.compareTo(address.getUUID());
    }

    @Pure
    public SpaceID getSpaceId() {
        return this.spaceId;
    }
}

