/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.services.network;

import com.google.common.base.Charsets;
import io.janusproject.JanusConfig;
import io.janusproject.modules.eventserial.NetworkEventModule;
import java.nio.charset.Charset;
import java.util.Properties;

public final class NetworkConfig {
    public static final String AES_KEY = "network.encrypter.aes.key";
    public static final String SERIALIZER_CLASSNAME = "network.serializer.class";
    public static final String ENCRYPTER_CLASSNAME = "network.encrypter.class";
    public static final String BYTE_ARRAY_STRING_CHARSET_NAME = "network.serializer.charset";
    public static final Charset BYTE_ARRAY_STRING_CHARSET_VALUE = Charsets.UTF_8;
    private static Charset currentStringEncoding;

    private NetworkConfig() {
    }

    public static void getDefaultValues(Properties defaultValues) {
        NetworkEventModule.getDefaultValues(defaultValues);
        defaultValues.put(AES_KEY, "");
        defaultValues.put(BYTE_ARRAY_STRING_CHARSET_NAME, BYTE_ARRAY_STRING_CHARSET_VALUE.name());
    }

    public static Charset getStringEncodingCharset() {
        if (currentStringEncoding == null) {
            String value = JanusConfig.getSystemProperty(BYTE_ARRAY_STRING_CHARSET_NAME, null);
            if (value != null) {
                try {
                    currentStringEncoding = Charset.forName(value);
                    if (currentStringEncoding == null) {
                        currentStringEncoding = BYTE_ARRAY_STRING_CHARSET_VALUE;
                    }
                }
                catch (Throwable throwable) {
                    currentStringEncoding = BYTE_ARRAY_STRING_CHARSET_VALUE;
                }
            } else {
                currentStringEncoding = BYTE_ARRAY_STRING_CHARSET_VALUE;
            }
        }
        return currentStringEncoding;
    }
}

