/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules.kernel;

import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.janusproject.kernel.annotations.Kernel;
import io.janusproject.kernel.bic.StandardBuiltinCapacitiesProvider;
import io.janusproject.kernel.bic.internaleventdispatching.AgentInternalEventsDispatcher;
import io.janusproject.kernel.space.EventSpaceSpecificationImpl;
import io.janusproject.kernel.space.OpenEventSpaceSpecificationImpl;
import io.janusproject.kernel.space.RestrictedAccessEventSpaceSpecificationImpl;
import io.janusproject.services.GoogleServiceManager;
import io.janusproject.services.IServiceManager;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.sarl.lang.annotation.PerceptGuardEvaluator;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.BuiltinCapacitiesProvider;
import io.sarl.lang.core.EventSpaceSpecification;
import io.sarl.util.OpenEventSpaceSpecification;
import io.sarl.util.RestrictedAccessEventSpaceSpecification;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class MandatoryKernelModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.requireBinding(Key.get(UUID.class, (Annotation)Names.named("janus.context.id")));
        this.requireBinding(Key.get(UUID.class, (Annotation)Names.named("janus.context.space.id")));
        this.requireBinding(Logger.class);
        this.bind(BuiltinCapacitiesProvider.class).to(StandardBuiltinCapacitiesProvider.class).in(Singleton.class);
        this.bind(EventSpaceSpecification.class).to(EventSpaceSpecificationImpl.class).in(Singleton.class);
        this.bind(OpenEventSpaceSpecification.class).to(OpenEventSpaceSpecificationImpl.class).in(Singleton.class);
        this.bind(RestrictedAccessEventSpaceSpecification.class).to(RestrictedAccessEventSpaceSpecificationImpl.class).in(Singleton.class);
    }

    @Provides
    @Kernel
    @Singleton
    private static AgentContext getKernel(ContextSpaceService contextService, @Named(value="janus.context.id") UUID janusContextID, @Named(value="janus.context.space.id") UUID defaultJanusSpaceId) {
        return contextService.createContext(janusContextID, defaultJanusSpaceId);
    }

    @Provides
    private static AgentInternalEventsDispatcher createAgentInternalEventsDispatcher(Injector injector) {
        AgentInternalEventsDispatcher aeb = new AgentInternalEventsDispatcher(PerceptGuardEvaluator.class);
        injector.injectMembers(aeb);
        return aeb;
    }

    @Provides
    @Singleton
    private static IServiceManager createServiceManager(Set<Service> services) {
        return new GoogleServiceManager(services);
    }
}

