/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.space;

import io.janusproject.kernel.repository.UniqueAddressParticipantRepository;
import io.janusproject.kernel.space.AbstractEventSpace;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.SpaceID;
import io.sarl.util.RestrictedAccessEventSpace;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.Permission;

public class RestrictedAccessEventSpaceImpl
extends AbstractEventSpace
implements RestrictedAccessEventSpace {
    private final Acl acl;
    private final Permission accessPermission;

    public RestrictedAccessEventSpaceImpl(SpaceID id, Acl acl, Permission accessPermission, DistributedDataStructureService factory) {
        super(id, factory);
        assert (acl != null);
        assert (accessPermission != null);
        this.acl = acl;
        this.accessPermission = accessPermission;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public Permission getRegistrationPermission() {
        return this.accessPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address register(EventListener entity, Principal principal) {
        if (this.acl.checkPermission(principal, this.accessPermission)) {
            Address a = new Address(this.getSpaceID(), entity.getID());
            UniqueAddressParticipantRepository uniqueAddressParticipantRepository = this.participants;
            synchronized (uniqueAddressParticipantRepository) {
                return this.participants.registerParticipant(a, entity);
            }
        }
        return null;
    }

    @Override
    public final <P extends EventListener & Principal> Address register(P entity) {
        return this.register(entity, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address unregister(EventListener entity) {
        UniqueAddressParticipantRepository uniqueAddressParticipantRepository = this.participants;
        synchronized (uniqueAddressParticipantRepository) {
            return (Address)this.participants.unregisterParticipant(entity);
        }
    }
}

