/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.spawn;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.janusproject.kernel.bic.BuiltinCapacityUtil;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.janusproject.services.spawn.KernelAgentSpawnListener;
import io.janusproject.services.spawn.SpawnService;
import io.janusproject.services.spawn.SpawnServiceListener;
import io.janusproject.util.ListenerCollection;
import io.sarl.core.AgentKilled;
import io.sarl.core.AgentSpawned;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.BuiltinCapacitiesProvider;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.Collections3;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.inject.Inject;
import org.arakhne.afc.vmutil.locale.Locale;

@Singleton
public class StandardSpawnService
extends AbstractDependentService
implements SpawnService {
    private final ListenerCollection<?> globalListeners = new ListenerCollection();
    private final Multimap<UUID, SpawnServiceListener> agentLifecycleListeners = ArrayListMultimap.create();
    private final Map<UUID, Agent> agents = new TreeMap<UUID, Agent>();
    private final Injector injector;

    @Inject
    public StandardSpawnService(Injector injector) {
        this.injector = injector;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return SpawnService.class;
    }

    @Override
    public Collection<Class<? extends Service>> getServiceDependencies() {
        return Arrays.asList(ContextSpaceService.class);
    }

    private static void ensureSarlSpecificationVersion(Class<? extends Agent> agentClazz) {
        String value;
        SarlSpecification annotation = agentClazz.getAnnotation(SarlSpecification.class);
        if (annotation != null && !Strings.isNullOrEmpty(value = annotation.value()) && "0.4".equals(value)) {
            return;
        }
        throw new InvalidSarlSpecificationException(agentClazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID spawn(AgentContext parent, UUID agentID, Class<? extends Agent> agentClazz, Object ... params) {
        if (this.isRunning()) {
            try {
                StandardSpawnService.ensureSarlSpecificationVersion(agentClazz);
                JustInTimeAgentInjectionModule agentInjectionModule = new JustInTimeAgentInjectionModule(this.injector, agentClazz, parent.getID(), agentID);
                Injector agentInjector = this.injector.createChildInjector(agentInjectionModule);
                Agent agent = agentInjector.getInstance(Agent.class);
                assert (agent != null);
                Map<UUID, Agent> map = this.agents;
                synchronized (map) {
                    this.agents.put(agent.getID(), agent);
                }
                this.fireAgentSpawned(parent, agent, params);
                return agent.getID();
            }
            catch (Throwable e) {
                throw new CannotSpawnException(agentClazz, e);
            }
        }
        throw new SpawnDisabledException(parent.getID(), agentClazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KillAgentResultStructure $killAgent(UUID agentID) {
        Map<UUID, Agent> map = this.agents;
        synchronized (map) {
            Agent agent = this.agents.get(agentID);
            if (agent != null) {
                KillAgentResultStructure k = new KillAgentResultStructure();
                if (this.canKillAgent(agent)) {
                    this.agents.remove(agentID);
                    k.isLast = this.agents.isEmpty();
                    k.canKill = Boolean.TRUE;
                    k.killAgent = agent;
                    return k;
                }
                return k;
            }
            return null;
        }
    }

    @Override
    public void killAgent(UUID agentID) throws SpawnService.AgentKillException {
        boolean error = !this.isRunning();
        KillAgentResultStructure synchroTests = this.$killAgent(agentID);
        if (synchroTests != null && synchroTests.canKill.booleanValue()) {
            this.fireAgentDestroyed(synchroTests.killAgent);
            if (synchroTests.isLast.booleanValue()) {
                this.fireKernelAgentDestroy();
            }
            if (error) {
                throw new SpawnServiceStopException(agentID);
            }
        } else if (synchroTests == null) {
            throw new SpawnService.AgentKillException(agentID);
        }
    }

    public synchronized SynchronizedSet<UUID> getAgents() {
        return Collections3.synchronizedSet(this.agents.keySet(), this);
    }

    synchronized Agent getAgent(UUID id) {
        assert (id != null);
        return this.agents.get(id);
    }

    @Override
    public void addKernelAgentSpawnListener(KernelAgentSpawnListener listener) {
        this.globalListeners.add(KernelAgentSpawnListener.class, listener);
    }

    @Override
    public void removeKernelAgentSpawnListener(KernelAgentSpawnListener listener) {
        this.globalListeners.remove(KernelAgentSpawnListener.class, listener);
    }

    protected void fireKernelAgentSpawn() {
        KernelAgentSpawnListener[] kernelAgentSpawnListenerArray = (KernelAgentSpawnListener[])this.globalListeners.getListeners(KernelAgentSpawnListener.class);
        int n = kernelAgentSpawnListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KernelAgentSpawnListener l = kernelAgentSpawnListenerArray[n2];
            l.kernelAgentSpawn();
            ++n2;
        }
    }

    protected void fireKernelAgentDestroy() {
        KernelAgentSpawnListener[] kernelAgentSpawnListenerArray = (KernelAgentSpawnListener[])this.globalListeners.getListeners(KernelAgentSpawnListener.class);
        int n = kernelAgentSpawnListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KernelAgentSpawnListener l = kernelAgentSpawnListenerArray[n2];
            l.kernelAgentDestroy();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSpawnServiceListener(UUID id, SpawnServiceListener agentLifecycleListener) {
        Multimap<UUID, SpawnServiceListener> multimap = this.agentLifecycleListeners;
        synchronized (multimap) {
            this.agentLifecycleListeners.put(id, agentLifecycleListener);
        }
    }

    @Override
    public void addSpawnServiceListener(SpawnServiceListener agentLifecycleListener) {
        this.globalListeners.add(SpawnServiceListener.class, agentLifecycleListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSpawnServiceListener(UUID id, SpawnServiceListener agentLifecycleListener) {
        Multimap<UUID, SpawnServiceListener> multimap = this.agentLifecycleListeners;
        synchronized (multimap) {
            this.agentLifecycleListeners.remove(id, agentLifecycleListener);
        }
    }

    @Override
    public void removeSpawnServiceListener(SpawnServiceListener agentLifecycleListener) {
        this.globalListeners.remove(SpawnServiceListener.class, agentLifecycleListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAgentSpawned(AgentContext context, Agent agent, Object[] initializationParameters) {
        SpawnServiceListener[] agentListeners;
        SpawnServiceListener[] spawnServiceListenerArray = (SpawnServiceListener[])this.globalListeners.getListeners(SpawnServiceListener.class);
        int n = spawnServiceListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpawnServiceListener l = spawnServiceListenerArray[n2];
            l.agentSpawned(context, agent, initializationParameters);
            ++n2;
        }
        Multimap<UUID, SpawnServiceListener> multimap = this.agentLifecycleListeners;
        synchronized (multimap) {
            Collection<SpawnServiceListener> list = this.agentLifecycleListeners.get(agent.getID());
            agentListeners = new SpawnServiceListener[list.size()];
            list.toArray(agentListeners);
        }
        SpawnServiceListener[] spawnServiceListenerArray2 = agentListeners;
        int n3 = agentListeners.length;
        int list = 0;
        while (list < n3) {
            SpawnServiceListener l = spawnServiceListenerArray2[list];
            l.agentSpawned(context, agent, initializationParameters);
            ++list;
        }
        UUID agentID = agent.getID();
        assert (agentID != null) : "Empty agent identifier";
        EventSpace defSpace = context.getDefaultSpace();
        assert (defSpace != null) : "A context does not contain a default space";
        Address agentAddress = defSpace.getAddress(agentID);
        if (agentAddress != null) {
            defSpace.emit(new AgentSpawned(agentAddress, agentID, agent.getClass().getName()));
        }
    }

    public synchronized boolean canKillAgent(Agent agent) {
        try {
            SynchronizedSet<UUID> participants;
            AgentContext ac = BuiltinCapacityUtil.getContextIn(agent);
            return ac == null || (participants = ac.getDefaultSpace().getParticipants()) == null || participants.size() <= 1 && (participants.size() != 1 || participants.contains(agent.getID()));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAgentDestroyed(Agent agent) {
        SpawnServiceListener l;
        SpawnServiceListener[] ilisteners;
        Multimap<UUID, SpawnServiceListener> multimap = this.agentLifecycleListeners;
        synchronized (multimap) {
            Collection<SpawnServiceListener> list = this.agentLifecycleListeners.get(agent.getID());
            ilisteners = new SpawnServiceListener[list.size()];
            list.toArray(ilisteners);
        }
        SpawnServiceListener[] ilisteners2 = (SpawnServiceListener[])this.globalListeners.getListeners(SpawnServiceListener.class);
        try {
            SynchronizedCollection<AgentContext> sc = BuiltinCapacityUtil.getContextsOf(agent);
            Object object = sc.mutex();
            synchronized (object) {
                for (AgentContext context : sc) {
                    EventSpace defSpace = context.getDefaultSpace();
                    defSpace.emit(new AgentKilled(defSpace.getAddress(agent.getID()), agent.getID(), agent.getClass().getName()));
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SpawnServiceListener[] spawnServiceListenerArray = ilisteners;
        int n = ilisteners.length;
        int n2 = 0;
        while (n2 < n) {
            l = spawnServiceListenerArray[n2];
            l.agentDestroy(agent);
            ++n2;
        }
        spawnServiceListenerArray = ilisteners2;
        n = ilisteners2.length;
        n2 = 0;
        while (n2 < n) {
            l = spawnServiceListenerArray[n2];
            l.agentDestroy(agent);
            ++n2;
        }
    }

    @Override
    protected synchronized void doStart() {
        this.fireKernelAgentSpawn();
        this.notifyStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void doStop() {
        Multimap<UUID, SpawnServiceListener> multimap = this.agentLifecycleListeners;
        synchronized (multimap) {
            this.agentLifecycleListeners.clear();
        }
        this.notifyStopped();
    }

    public static class CannotSpawnException
    extends RuntimeException {
        private static final long serialVersionUID = -380402400888610762L;

        public CannotSpawnException(Class<? extends Agent> agentClazz, Throwable cause) {
            super(Locale.getString(StandardSpawnService.class, "CANNOT_INSTANCIATE_AGENT", agentClazz, cause == null ? null : cause.getLocalizedMessage()), cause);
        }
    }

    public static class InvalidSarlSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = -3194494637438344108L;

        public InvalidSarlSpecificationException(Class<? extends Agent> agentType) {
            super(Locale.getString(StandardSpawnService.class, "INVALID_SARL_SPECIFICATION", agentType.getName()));
        }
    }

    private static class JustInTimeAgentInjectionModule
    extends AbstractModule
    implements Provider<Agent> {
        private final Injector injector;
        private final Class<? extends Agent> agentType;
        private final UUID parentID;
        private final UUID agentID;

        JustInTimeAgentInjectionModule(Injector injector, Class<? extends Agent> agentType, UUID parentID, UUID agentID) {
            assert (injector != null);
            assert (agentType != null);
            assert (parentID != null);
            this.injector = injector;
            this.agentType = agentType;
            this.parentID = parentID;
            this.agentID = agentID == null ? UUID.randomUUID() : agentID;
        }

        @Override
        public void configure() {
            this.bind(Agent.class).toProvider(this);
        }

        @Override
        public Agent get() {
            try {
                BuiltinCapacitiesProvider capacityProvider = this.injector.getInstance(BuiltinCapacitiesProvider.class);
                Constructor<? extends Agent> constructor = this.agentType.getConstructor(BuiltinCapacitiesProvider.class, UUID.class, UUID.class);
                return constructor.newInstance(capacityProvider, this.parentID, this.agentID);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                throw new CannotSpawnException(this.agentType, (Throwable)exception);
            }
        }
    }

    private class KillAgentResultStructure {
        Boolean canKill = Boolean.FALSE;
        Boolean isLast = Boolean.FALSE;
        Agent killAgent;

        KillAgentResultStructure() {
        }
    }

    public static class SpawnDisabledException
    extends RuntimeException {
        private static final long serialVersionUID = -380402400888610762L;

        public SpawnDisabledException(UUID parentID, Class<? extends Agent> agentClazz) {
            super(Locale.getString(StandardSpawnService.class, "SPAWN_DISABLED", parentID, agentClazz));
        }
    }

    public static class SpawnServiceStopException
    extends RuntimeException {
        private static final long serialVersionUID = 8104012713598435249L;

        public SpawnServiceStopException(UUID agentID) {
            super(Locale.getString(StandardSpawnService.class, "KILL_DISABLED", agentID));
        }
    }
}

