/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.network;

import com.google.inject.Inject;
import io.janusproject.services.network.AbstractEventSerializer;
import io.janusproject.services.network.EventDispatch;
import io.janusproject.services.network.EventEncrypter;
import io.janusproject.services.network.EventEnvelope;
import io.janusproject.services.network.NetworkUtil;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.core.SpaceSpecification;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.UUID;
import org.arakhne.afc.vmutil.ClassLoaderFinder;
import org.arakhne.afc.vmutil.locale.Locale;

public class JavaBinaryEventSerializer
extends AbstractEventSerializer {
    @Inject
    public JavaBinaryEventSerializer(EventEncrypter encrypter) {
        super(encrypter);
    }

    @Override
    public EventEnvelope serialize(EventDispatch dispatch) throws Exception {
        assert (this.encrypter != null) : "Invalid injection of the encrypter";
        assert (dispatch != null) : "Parameter 'dispatch' must not be null";
        Event event = dispatch.getEvent();
        assert (event != null);
        SpaceID spaceID = dispatch.getSpaceID();
        assert (spaceID != null);
        assert (spaceID.getSpaceSpecification() != null);
        Map<String, String> headers = dispatch.getCustomHeaders();
        assert (headers != null);
        headers.put("x-java-spacespec-class", spaceID.getSpaceSpecification().getName());
        Scope<?> scope = dispatch.getScope();
        EventEnvelope envelope = new EventEnvelope(NetworkUtil.toByteArray(spaceID.getContextID()), NetworkUtil.toByteArray(spaceID.getID()), JavaBinaryEventSerializer.toBytes(scope), JavaBinaryEventSerializer.toBytes(dispatch.getCustomHeaders()), JavaBinaryEventSerializer.toBytes(event));
        this.encrypter.encrypt(envelope);
        return envelope;
    }

    private static byte[] toBytes(Object object) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            return baos.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public EventDispatch deserialize(EventEnvelope envelope) throws Exception {
        assert (this.encrypter != null) : "Invalid injection of the encrypter";
        assert (envelope != null) : "Parameter 'envelope' must not be null";
        this.encrypter.decrypt(envelope);
        Map headers = JavaBinaryEventSerializer.fromBytes(envelope.getCustomHeaders(), Map.class);
        assert (headers != null);
        Class<?> spaceSpec = null;
        String classname = (String)headers.get("x-java-spacespec-class");
        if (classname != null) {
            try {
                spaceSpec = Class.forName(classname);
            }
            catch (Throwable throwable) {}
        }
        if (spaceSpec == null || !SpaceSpecification.class.isAssignableFrom(spaceSpec)) {
            throw new ClassCastException(Locale.getString(JavaBinaryEventSerializer.class, "INVALID_TYPE", spaceSpec));
        }
        UUID contextId = NetworkUtil.fromByteArray(envelope.getContextId());
        UUID spaceId = NetworkUtil.fromByteArray(envelope.getSpaceId());
        SpaceID spaceID = new SpaceID(contextId, spaceId, spaceSpec);
        Event event = JavaBinaryEventSerializer.fromBytes(envelope.getBody(), Event.class);
        assert (event != null);
        Scope scope = JavaBinaryEventSerializer.fromBytes(envelope.getScope(), Scope.class);
        return new EventDispatch(spaceID, event, scope, headers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T fromBytes(byte[] data, Class<T> type) throws IOException, ClassNotFoundException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try {
                Throwable throwable2 = null;
                Object var6_9 = null;
                try {
                    T t;
                    ClassLoaderObjectInputStream oos = new ClassLoaderObjectInputStream(bais);
                    Object object = oos.readObject();
                    if (object != null && type.isInstance(object)) {
                        t = type.cast(object);
                    } else {
                        throw new ClassCastException(Locale.getString(JavaBinaryEventSerializer.class, "INVALID_TYPE", type.getName()));
                    }
                    finally {
                        block17: {
                            if (oos != null) break block17;
                            if (bais == null) return t;
                            bais.close();
                            return t;
                        }
                        oos.close();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                        throw throwable2;
                    }
                    if (throwable2 == throwable3) throw throwable2;
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (bais == null) throw throwable4;
                bais.close();
                throw throwable4;
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    public static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public ClassLoaderObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
            this(null, inputStream);
        }

        public ClassLoaderObjectInputStream(ClassLoader classLoader, InputStream inputStream) throws IOException {
            super(inputStream);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            Class<?> type = this.resolve(objectStreamClass.getName());
            if (type != null) {
                return type;
            }
            return super.resolveClass(objectStreamClass);
        }

        private Class<?> resolve(String className) {
            ClassLoader classLoader;
            if (this.classLoader != null) {
                try {
                    return Class.forName(className, true, this.classLoader);
                }
                catch (Exception exception) {}
            }
            if ((classLoader = ClassLoaderFinder.findClassLoader()) != null) {
                try {
                    return classLoader.loadClass(className);
                }
                catch (Exception exception) {}
            }
            try {
                return Class.forName(className, true, this.getClass().getClassLoader());
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            Class[] interfaceClasses = new Class[interfaces.length];
            ClassLoader cl = null;
            int i = 0;
            while (i < interfaces.length) {
                Class<?> type = this.resolve(interfaces[i]);
                if (type == null) {
                    throw new ClassNotFoundException(interfaces[i]);
                }
                interfaceClasses[i] = type;
                cl = type.getClassLoader();
                ++i;
            }
            try {
                return Proxy.getProxyClass(cl, interfaceClasses);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return super.resolveProxyClass(interfaces);
            }
        }
    }
}

