/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.executors;

import com.google.inject.Inject;
import io.janusproject.JanusConfig;
import io.janusproject.kernel.services.jdk.executors.JdkJanusScheduledFutureTask;
import io.janusproject.kernel.services.jdk.executors.JdkTaskListener;
import io.janusproject.services.executor.ChuckNorrisException;
import io.janusproject.util.ListenerCollection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class JdkScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private ListenerCollection<JdkTaskListener> listeners;

    @Inject
    public JdkScheduledThreadPoolExecutor(ThreadFactory factory) {
        super(JanusConfig.getSystemPropertyAsInteger("janus.executors.threads.max", 50), factory);
    }

    public synchronized void addTaskListener(JdkTaskListener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerCollection();
        }
        this.listeners.add(JdkTaskListener.class, listener);
    }

    public synchronized void removeTaskListener(JdkTaskListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(JdkTaskListener.class, listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTaskFinished(Thread thread, Runnable task) {
        JdkTaskListener[] iListeners;
        JdkScheduledThreadPoolExecutor jdkScheduledThreadPoolExecutor = this;
        synchronized (jdkScheduledThreadPoolExecutor) {
            if (this.listeners == null) {
                return;
            }
            iListeners = (JdkTaskListener[])this.listeners.getListeners(JdkTaskListener.class);
        }
        JdkTaskListener[] jdkTaskListenerArray = iListeners;
        int n = iListeners.length;
        int n2 = 0;
        while (n2 < n) {
            JdkTaskListener listener = jdkTaskListenerArray[n2];
            listener.taskFinished(thread, task);
            ++n2;
        }
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return new JdkJanusScheduledFutureTask<V>(task);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return new JdkJanusScheduledFutureTask<V>(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.schedule(new ResultRunnable<T>(task, result), 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        if (runnable instanceof JdkJanusScheduledFutureTask) {
            ((JdkJanusScheduledFutureTask)runnable).setThread(thread);
        }
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable thread) {
        assert (thread == null);
        assert (runnable instanceof JdkJanusScheduledFutureTask);
        JdkJanusScheduledFutureTask task = (JdkJanusScheduledFutureTask)runnable;
        assert (task.isDone() || task.isCancelled() || task.isPeriodic());
        if (task.isDone() || task.isCancelled()) {
            task.reportException(task.getThread());
            this.fireTaskFinished(task.getThread(), task);
        }
    }

    private static class ResultRunnable<V>
    implements Callable<V> {
        private final Runnable runnable;
        private final V result;

        ResultRunnable(Runnable runnable, V result) {
            this.runnable = runnable;
            this.result = result;
        }

        @Override
        public V call() throws Exception {
            try {
                this.runnable.run();
            }
            catch (ChuckNorrisException chuckNorrisException) {}
            return this.result;
        }
    }
}

