/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.distributeddata;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.Service;
import io.janusproject.kernel.services.guava.DMultiMapView;
import io.janusproject.kernel.services.jdk.distributeddata.DMapView;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.distributeddata.DMap;
import io.janusproject.services.distributeddata.DMultiMap;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class StandardDistributedDataStructureService
extends AbstractDependentService
implements DistributedDataStructureService {
    @Override
    public final Class<? extends Service> getServiceType() {
        return DistributedDataStructureService.class;
    }

    @Override
    protected void doStart() {
        this.notifyStarted();
    }

    @Override
    protected void doStop() {
        this.notifyStopped();
    }

    @Override
    public <K, V> DMap<K, V> getMap(String name) {
        return new DMapView(name, Maps.newHashMap());
    }

    @Override
    public <K, V> DMap<K, V> getMap(String name, Comparator<? super K> comparator) {
        TreeMap map = comparator == null ? Maps.newTreeMap() : Maps.newTreeMap(comparator);
        return new DMapView(name, map);
    }

    @Override
    public <K, V> DMultiMap<K, V> getMultiMap(String name) {
        HashMap map = Maps.newHashMap();
        ListMultimap multimap = Multimaps.newListMultimap(map, new ArrayListSupplier());
        return new DMultiMapView(name, multimap);
    }

    @Override
    public <K, V> DMultiMap<K, V> getMultiMap(String name, Comparator<? super K> comparator) {
        TreeMap map = comparator == null ? Maps.newTreeMap() : Maps.newTreeMap(comparator);
        ListMultimap multimap = Multimaps.newListMultimap(map, new ArrayListSupplier());
        return new DMultiMapView(name, multimap);
    }

    private static class ArrayListSupplier<K>
    implements Supplier<List<K>> {
        ArrayListSupplier() {
        }

        @Override
        public List<K> get() {
            return Lists.newArrayList();
        }
    }
}

