/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic.internaleventdispatching;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.arakhne.afc.vmutil.locale.Locale;

public final class BehaviorGuardEvaluator {
    private final Object target;
    private final Method method;

    private BehaviorGuardEvaluator(Object target, Method method) {
        assert (target != null);
        this.target = target;
        this.method = method;
    }

    static BehaviorGuardEvaluator create(Object listener, Method method) {
        return new BehaviorGuardEvaluator(listener, method);
    }

    void evaluateGuard(Object event, Collection<Runnable> behaviorsMethodsToExecute) throws InvocationTargetException {
        this.invokeBehaviorGuardEvaluatorMethod(event, behaviorsMethodsToExecute);
    }

    private void invokeBehaviorGuardEvaluatorMethod(Object event, Collection<Runnable> behaviorsMethodsToExecute) throws InvocationTargetException {
        try {
            this.method.setAccessible(true);
            this.method.invoke(this.target, event, behaviorsMethodsToExecute);
        }
        catch (IllegalArgumentException e) {
            throw new Error(Locale.getString(this.getClass(), "EVALUATOR_REJECTION", event), e);
        }
        catch (IllegalAccessException e) {
            throw new Error(Locale.getString(this.getClass(), "INACCESSIBLE_EVALUATOR", event), e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
    }

    public Object getTarget() {
        return this.target;
    }

    public int hashCode() {
        return (31 + this.method.hashCode()) * 31 + System.identityHashCode(this.target);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BehaviorGuardEvaluator) {
            BehaviorGuardEvaluator that = (BehaviorGuardEvaluator)obj;
            return this.target == that.target && this.method.equals(that.method);
        }
        return false;
    }
}

