/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic.internaleventdispatching;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import io.janusproject.kernel.bic.internaleventdispatching.BehaviorGuardEvaluator;
import io.janusproject.kernel.bic.internaleventdispatching.BehaviorGuardEvaluatorRegistry;
import io.janusproject.services.executor.ExecutorService;
import io.sarl.lang.core.DeadEvent;
import io.sarl.lang.core.Event;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.arakhne.afc.util.MultiCollection;
import org.arakhne.afc.util.OutputParameter;
import org.eclipse.xtext.xbase.lib.Pair;

public class AgentInternalEventsDispatcher {
    private final BehaviorGuardEvaluatorRegistry behaviorGuardEvaluatorRegistry;
    private final ThreadLocal<Queue<Pair<Event, Collection<Runnable>>>> queue = new ThreadLocal<Queue<Pair<Event, Collection<Runnable>>>>(){

        @Override
        protected Queue<Pair<Event, Collection<Runnable>>> initialValue() {
            return Queues.newArrayDeque();
        }
    };
    private final ThreadLocal<Boolean> dispatching = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    @Inject
    private ExecutorService executor;

    public AgentInternalEventsDispatcher(Class<? extends Annotation> perceptGuardEvaluatorAnnotation) {
        this.behaviorGuardEvaluatorRegistry = new BehaviorGuardEvaluatorRegistry(perceptGuardEvaluatorAnnotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object object) {
        BehaviorGuardEvaluatorRegistry behaviorGuardEvaluatorRegistry = this.behaviorGuardEvaluatorRegistry;
        synchronized (behaviorGuardEvaluatorRegistry) {
            this.behaviorGuardEvaluatorRegistry.register(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Object object) {
        BehaviorGuardEvaluatorRegistry behaviorGuardEvaluatorRegistry = this.behaviorGuardEvaluatorRegistry;
        synchronized (behaviorGuardEvaluatorRegistry) {
            this.behaviorGuardEvaluatorRegistry.unregister(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void immediateDispatch(Event event) {
        assert (event != null);
        Collection<BehaviorGuardEvaluator> behaviorGuardEvaluators = null;
        BehaviorGuardEvaluatorRegistry behaviorGuardEvaluatorRegistry = this.behaviorGuardEvaluatorRegistry;
        synchronized (behaviorGuardEvaluatorRegistry) {
            behaviorGuardEvaluators = this.behaviorGuardEvaluatorRegistry.getBehaviorGuardEvaluators(event);
        }
        if (behaviorGuardEvaluators != null && !behaviorGuardEvaluators.isEmpty()) {
            try {
                Collection<Runnable> behaviorsMethodsToExecute = AgentInternalEventsDispatcher.evaluateGuards(event, behaviorGuardEvaluators);
                this.executeBehaviorMethodsInParalellWithSynchroAtTheEnd(event, behaviorsMethodsToExecute);
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (InterruptedException | InvocationTargetException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else if (!(event instanceof DeadEvent)) {
            this.immediateDispatch(new DeadEvent(event));
        }
    }

    public void asyncDispatch(Event event) {
        assert (event != null);
        this.executor.execute(() -> {
            Collection<BehaviorGuardEvaluator> behaviorGuardEvaluators = null;
            BehaviorGuardEvaluatorRegistry behaviorGuardEvaluatorRegistry = this.behaviorGuardEvaluatorRegistry;
            synchronized (behaviorGuardEvaluatorRegistry) {
                behaviorGuardEvaluators = this.behaviorGuardEvaluatorRegistry.getBehaviorGuardEvaluators(event);
            }
            if (behaviorGuardEvaluators != null && !behaviorGuardEvaluators.isEmpty()) {
                Collection<Runnable> behaviorsMethodsToExecute;
                try {
                    behaviorsMethodsToExecute = AgentInternalEventsDispatcher.evaluateGuards(event, behaviorGuardEvaluators);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                this.executeAsynchronouslyBehaviorMethods(event, behaviorsMethodsToExecute);
            } else if (!(event instanceof DeadEvent)) {
                this.asyncDispatch(new DeadEvent(event));
            }
        });
    }

    private static Collection<Runnable> evaluateGuards(Event event, Collection<BehaviorGuardEvaluator> behaviorGuardEvaluators) throws InvocationTargetException {
        MultiCollection<Runnable> behaviorsMethodsToExecute = new MultiCollection<Runnable>();
        try {
            behaviorGuardEvaluators.parallelStream().forEach(evaluator -> {
                try {
                    LinkedList<Runnable> behaviorsMethodsToExecutePerTarget = Lists.newLinkedList();
                    evaluator.evaluateGuard(event, behaviorsMethodsToExecutePerTarget);
                    MultiCollection multiCollection2 = behaviorsMethodsToExecute;
                    synchronized (multiCollection2) {
                        behaviorsMethodsToExecute.addCollection(behaviorsMethodsToExecutePerTarget);
                    }
                }
                catch (InvocationTargetException exception) {
                    throw new RuntimeException(exception);
                }
            });
        }
        catch (RuntimeException exception) {
            Throwable t = exception.getCause();
            if (t instanceof InvocationTargetException) {
                throw (InvocationTargetException)t;
            }
            throw exception;
        }
        return behaviorsMethodsToExecute;
    }

    private void executeBehaviorMethodsInParalellWithSynchroAtTheEnd(Event event, Collection<Runnable> behaviorsMethodsToExecute) throws InterruptedException, ExecutionException {
        CountDownLatch doneSignal = new CountDownLatch(behaviorsMethodsToExecute.size());
        OutputParameter runException = new OutputParameter();
        for (Runnable runnable : behaviorsMethodsToExecute) {
            this.executor.execute(() -> {
                try {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException e) {
                        runException.set(e);
                        throw e;
                    }
                    catch (Exception e) {
                        runException.set(e);
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    doneSignal.countDown();
                }
            });
        }
        doneSignal.await();
        if (runException.get() != null) {
            throw new ExecutionException((Throwable)runException.get());
        }
    }

    private void executeAsynchronouslyBehaviorMethods(Event event, Collection<Runnable> behaviorsMethodsToExecute) {
        Queue<Pair<Event, Collection<Runnable>>> queueForThread = this.queue.get();
        queueForThread.offer(new Pair<Event, Collection<Runnable>>(event, behaviorsMethodsToExecute));
        if (!this.dispatching.get().booleanValue()) {
            this.dispatching.set(Boolean.TRUE);
            try {
                Pair<Event, Collection<Runnable>> nextEvent;
                while ((nextEvent = queueForThread.poll()) != null) {
                    for (Runnable runnable : nextEvent.getValue()) {
                        this.executor.execute(runnable);
                    }
                }
            }
            finally {
                this.dispatching.remove();
                this.queue.remove();
            }
        }
    }
}

