/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.services.logging.LogService;
import io.janusproject.util.LoggerCreator;
import io.sarl.core.Logging;
import io.sarl.lang.core.Agent;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arakhne.afc.vmutil.locale.Locale;

public class LoggingSkill
extends BuiltinSkill
implements Logging {
    private static int installationOrder = -1;
    @Inject
    private LogService logService;
    private Logger logger;

    LoggingSkill(Agent agent) {
        super(agent);
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = LoggingSkill.installationOrder(this);
        }
        return installationOrder;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    protected void install() {
        UUID agentId = this.getOwner().getID();
        String loggerName = Locale.getString(LoggingSkill.class, "AGENT_NAME", agentId);
        this.logger = LoggerCreator.createLogger(loggerName, this.logService.getLogger());
    }

    @Override
    public void setLoggingName(String name) {
        String loggingName = name;
        if (loggingName == null || loggingName.isEmpty()) {
            loggingName = Locale.getString(LoggingSkill.class, "AGENT_NAME", this.getOwner().getID());
        }
        Level level = this.logger.getLevel();
        this.logger = LoggerCreator.createLogger(loggingName, this.logService.getLogger());
        this.logger.setLevel(level);
    }

    @Override
    public void println(Object message) {
        this.info(message);
    }

    @Override
    public void error(Object message, Throwable exception) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String loggableMessage = Strings.nullToEmpty(message == null ? null : message.toString());
            if (exception != null) {
                this.logger.log(Level.SEVERE, loggableMessage, exception);
            } else {
                this.logger.log(Level.SEVERE, loggableMessage);
            }
        }
    }

    @Override
    public void error(Object message) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String loggeableMessage = Strings.nullToEmpty(message == null ? null : message.toString());
            this.logger.log(Level.SEVERE, loggeableMessage);
        }
    }

    @Override
    public void warning(Object message, Throwable exception) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String loggeableMessage = Strings.nullToEmpty(message == null ? null : message.toString());
            if (exception != null) {
                this.logger.log(Level.WARNING, loggeableMessage, exception);
            } else {
                this.logger.log(Level.WARNING, loggeableMessage);
            }
        }
    }

    @Override
    public void warning(Object message) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String loggeableMessage = Strings.nullToEmpty(message == null ? null : message.toString());
            this.logger.log(Level.WARNING, loggeableMessage);
        }
    }

    @Override
    public void info(Object message) {
        if (this.logger.isLoggable(Level.INFO)) {
            String loggeableMessage = Strings.nullToEmpty(message == null ? null : message.toString());
            this.logger.log(Level.INFO, loggeableMessage);
        }
    }

    @Override
    public void debug(Object message) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            String loggeableMessage = Strings.nullToEmpty(message == null ? null : message.toString());
            this.logger.log(Level.CONFIG, loggeableMessage);
        }
    }

    @Override
    public boolean isErrorLogEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isWarningLogEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isInfoLogEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isDebugLogEnabled() {
        return this.logger.isLoggable(Level.CONFIG);
    }

    @Override
    public int getLogLevel() {
        return LoggerCreator.toInt(this.logger.getLevel());
    }

    @Override
    public void setLogLevel(int level) {
        this.logger.setLevel(LoggerCreator.fromInt(level));
    }
}

